/*
 * Decompiled with CFR 0.152.
 */
import java.text.BreakIterator;
import java.util.Locale;

public class UniLineBreak {
    private BreakIterator m_lineBreak;
    private char[] m_line;
    private int m_curLineEnd;
    private int m_curLineIndex;

    public UniLineBreak(String string) {
        this(string, Locale.getDefault());
    }

    public UniLineBreak(String string, Locale locale) {
        if (this.m_lineBreak == null) {
            this.m_lineBreak = BreakIterator.getLineInstance(locale);
        }
        this.setText(string);
    }

    public void setText(String string) {
        this.m_lineBreak.setText(string);
        this.m_line = string.toCharArray();
        this.first();
    }

    public int first() {
        this.m_curLineEnd = this.m_curLineIndex = this.m_lineBreak.first();
        return this.m_curLineIndex;
    }

    public int following(int n) {
        this.m_curLineEnd = this.m_curLineIndex = this.m_lineBreak.following(n);
        return this.m_curLineIndex;
    }

    public int next() {
        char c;
        int n = this.possibleNext();
        if (n != -1 && n < this.m_line.length && ((c = this.m_line[n]) > '\u3000' && c < '\u3020' && (c < '\u3004' || c > '\u3008' && c < '\u301c' && c % 2 != 0 || c == '\u301e' || c == '\u301f') || c > '\uff08' && c < '\uffa0' && (c == '\uff09' || c > '\uff0b' && c < '\uff0f' || c == '\uff3d' || c == '\uff5d' || c == '\uff61' || c == '\uff63' || c == '\uff64' || c == '\uff9e' || c == '\uff9f'))) {
            this.m_curLineIndex = ++n;
            this.m_curLineEnd = this.m_curLineIndex == this.m_line.length ? -1 : this.m_lineBreak.following(n);
        }
        return n;
    }

    private int possibleNext() {
        if (this.m_curLineEnd == -1) {
            return this.m_curLineEnd;
        }
        if (this.m_curLineIndex >= this.m_curLineEnd) {
            int n = this.m_lineBreak.current();
            int n2 = this.m_lineBreak.next();
            if (n2 != -1 && n2 - n > 1) {
                this.m_curLineIndex = n;
                this.m_curLineEnd = n2;
            } else {
                return n2;
            }
        }
        return this.segNext();
    }

    private int segNext() {
        int n = this.m_curLineIndex;
        while (this.m_curLineIndex < this.m_curLineEnd) {
            char c;
            if (((c = this.m_line[this.m_curLineIndex++]) <= '\u300f' || c >= '\u3100') && (c <= '\uff64' || c >= '\uff9e')) continue;
            if (this.m_curLineIndex - n <= 2) break;
            --this.m_curLineIndex;
            break;
        }
        return this.m_curLineIndex;
    }
}

