/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class WizOSD {
    String OSName = System.getProperty("os.name");

    public WizOSD() {
        if (this.OSName.compareTo("Windows NT") == 0 || this.OSName.compareTo("Windows 95") == 0) {
            String string = System.getProperty("user.dir");
            int n = string.toLowerCase().indexOf("assistants");
            if (n == -1) {
                n = string.toLowerCase().indexOf("jre");
                if (n != -1) {
                    string = string.substring(0, n - 1);
                }
            } else {
                string = string.substring(0, n - 1);
            }
            try {
                System.loadLibrary(String.valueOf(string) + "\\bin\\WizOSD");
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.exit(0);
                return;
            }
        }
    }

    public String CheckforOraclePath() {
        String string = "";
        if (this.OSName.compareTo("Windows NT") == 0 || this.OSName.compareTo("Windows 95") == 0) {
            String string2 = System.getProperty("user.dir");
            int n = string2.toLowerCase().indexOf("assistants");
            if (n == -1) {
                n = string2.toLowerCase().indexOf("jre");
                if (n != -1) {
                    string2 = string2.substring(0, n - 1);
                }
            } else {
                string2 = string2.substring(0, n - 1);
            }
            string = this.DBQueryKeys(string2, "ORACLE_HOME");
        } else if (this.OSName.compareTo("Solaris") == 0) {
            File file;
            String string3 = this.DBQueryEnv("ORACLE_HOME");
            string = string3 == null ? "" : ((file = new File(string3)).isDirectory() ? string3 : "");
        }
        return string;
    }

    public String CheckforListenerPath(String string) {
        String string2 = null;
        if (this.OSName.compareTo("Windows NT") == 0 || this.OSName.compareTo("Windows 95") == 0) {
            string2 = this.DBQueryKeys(string, "TNS_ADMIN");
        }
        if (this.CheckforExistingFile(String.valueOf(string2) + "\\listener.ora")) {
            return String.valueOf(string2) + "\\listener.ora";
        }
        string2 = String.valueOf(string) + "\\network\\admin\\listener.ora";
        if (this.CheckforExistingFile(string2)) {
            return string2;
        }
        string2 = String.valueOf(string) + "\\net81\\admin\\listener.ora";
        if (this.CheckforExistingFile(string2)) {
            return string2;
        }
        string2 = String.valueOf(string) + "\\net80\\admin\\listener.ora";
        if (this.CheckforExistingFile(string2)) {
            return string2;
        }
        return null;
    }

    public boolean CheckforExistingFile(String string) {
        File file = new File(string);
        return file.exists();
    }

    public boolean OSAuthEnabled(boolean bl, String string) {
        if (this.OSName.compareTo("Solaris") == 0) {
            return true;
        }
        if (this.OSName.compareTo("Windows NT") == 0 || this.OSName.compareTo("Windows 95") == 0) {
            if (bl) {
                return this.DBOSAuthEnabled(string);
            }
            return false;
        }
        return false;
    }

    public long DBQueryDiskSpace(String string) {
        long l = 0L;
        if (this.OSName.compareTo("Solaris") == 0) {
            Object object;
            Runtime runtime = Runtime.getRuntime();
            String string2 = "";
            String string3 = "";
            try {
                String string4;
                object = runtime.exec("/bin/df -b " + string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                while ((string4 = bufferedReader.readLine()) != null) {
                    string2 = string4;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            object = new StringTokenizer(string2);
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken();
            }
            l = Long.parseLong(string3);
        } else if (this.OSName.compareTo("Windows NT") == 0 || this.OSName.compareTo("Windows 95") == 0) {
            l = this.DBQueryDiskSpaceNT(string);
        }
        return l;
    }

    public long DBQueryAvailableRAM() {
        long l = 0L;
        if (this.OSName.compareTo("Solaris") == 0) {
            Object object;
            Runtime runtime = Runtime.getRuntime();
            String string = "";
            String string2 = "";
            String string3 = "";
            try {
                String string4;
                object = runtime.exec("/usr/sbin/swap -s ");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                while ((string4 = bufferedReader.readLine()) != null) {
                    string = string4;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken();
                if (string2.equals("available")) break;
                string3 = string2;
            }
            l = Long.parseLong(string3.substring(0, string3.indexOf(107)));
        } else if (this.OSName.compareTo("Windows NT") == 0 || this.OSName.compareTo("Windows 95") == 0) {
            l = this.DBQueryAvailableRAMNT();
        }
        return l;
    }

    public String DBBanner(String string) {
        String string2 = "Workgroup";
        if (this.OSName.compareTo("Solaris") == 0) {
            String string3 = null;
            String string4 = String.valueOf(string) + "/bin/svrmgrl";
            String string5 = String.valueOf(string4) + " command=exit";
            Runtime runtime = Runtime.getRuntime();
            try {
                Process process = runtime.exec(string5);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.indexOf("Enterprise Edition") == -1) continue;
                    string2 = "Enterprise Edition";
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.out.println("IOException : " + iOException);
            }
        } else if (this.OSName.compareTo("Windows NT") == 0 || this.OSName.compareTo("Windows 95") == 0) {
            string2 = this.DBBannerNT(string);
        }
        return string2;
    }

    public String DBQueryCD() {
        String string = "/etc/vold.conf";
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf("label_cdrom.so") == -1) continue;
                int n = 0;
                String string3 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (++n == 2) break;
                }
                bufferedReader.close();
                return "/" + string3;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return null;
    }

    public String DBQueryEnv(String string) {
        Runtime runtime = Runtime.getRuntime();
        String string2 = "";
        try {
            String string3;
            Process process = runtime.exec("/bin/env");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.startsWith(string)) continue;
                int n = string3.indexOf("=");
                try {
                    string2 = string3.substring(n + 1);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.out.println("StringIndex Exception: " + stringIndexOutOfBoundsException);
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException : " + iOException);
        }
        return string2;
    }

    public boolean CreateSymLink(String string, String string2) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec("/bin/ln -s " + string2 + " " + string);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean remshell(String string, String string2) {
        int n;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec("rsh " + string + " " + string2);
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return n <= 0;
    }

    public boolean remcopy(String string, String string2, String string3) {
        int n;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec("rcp " + string2 + " " + string + ":" + string3);
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return n <= 0;
    }

    public boolean DBStartExec(String string) {
        return true;
    }

    public boolean DBStartUp(String string) {
        return true;
    }

    public boolean DBShutDown(String string) {
        return true;
    }

    public boolean DBCheckRun(String string) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec("/bin/ps -e | grep " + string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                return true;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException : " + iOException);
        }
        return false;
    }

    public native String DBEnumerateService(String var1);

    public native String DBQueryRegistry(String var1, String var2);

    public native boolean DBQueryServiceExist(String var1, String var2);

    public native long DBQueryDiskSpaceNT(String var1);

    public native long DBQueryDriveType();

    public native boolean DBWriteRegistry(String var1, String var2, String var3, boolean var4);

    public native boolean DBAddRegistry(String var1, String var2, String var3);

    public native boolean DBDeleteRegistry(String var1, String var2);

    public native int DBQueryColors();

    public native String DBQueryKeys(String var1, String var2);

    public native boolean DBStartService(String var1);

    public native boolean DBStopService(String var1);

    public native boolean DBServiceStarted(String var1);

    public native String DBBannerNT(String var1);

    public native long DBQueryAvailableRAMNT();

    public native String DBQueryFileVersion(String var1);

    public native boolean DBOSAuthEnabled(String var1);
}

