/*
 * Decompiled with CFR 0.152.
 */
package oracle.ntpg.jnls;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import oracle.ntpg.jnls.JNLSException;
import oracle.ntpg.jnls.JNLSLib;
import oracle.ntpg.jnls.JNLSLib3;
import oracle.ntpg.jnls.JNLSLocale;
import oracle.ntpg.jnls.JNLSTool;
import oracle.ntpg.jnls.JNLSVers;

public class JNLS {
    private boolean m_libInitialized = false;
    private JNLSLib nlsLib = null;
    private static final int COUNTBYTES = 3;
    private static final int NLSI_NLS_LANG = 1;
    private static final int NLSI_Language = 2;
    private static final int NLSI_Territory = 3;
    private static final int NLSI_Charset = 4;
    private static final int NLSI_NCHARCharset = 5;
    private static final int NLSM_All_CS = 1;
    private static final int NLSM_ASCII_CS = 2;
    private static final int NLSM_EBCDIC_CS = 3;
    private static final int NLSM_Fixed_CS = 4;
    private static final int NLSM_National_CS = 5;
    private static final int NLSM_Storage_CS = 6;
    private static final int NLSM_All_Lang = 7;
    public static final int VTYPE_ANY = 1;
    public static final int VTYPE_NLS = 2;
    public static final int VTYPE_ORACLE = 3;

    public JNLS(String oracleVersion) throws JNLSException, UnsatisfiedLinkError {
        this(3, oracleVersion, "");
    }

    public JNLS(int versionType, String version) throws JNLSException, UnsatisfiedLinkError {
        this(versionType, version, "");
    }

    public JNLS(int versionType, String version, String nativeLibPath) throws JNLSException, UnsatisfiedLinkError {
        String nlsInternal;
        String nlsVers = version;
        JNLSVers jVers = new JNLSVers();
        switch (versionType) {
            case 3: {
                nlsVers = jVers.getNlsVers(version);
                if (nlsVers == null) {
                    throw new JNLSException(6);
                }
            }
            case 2: {
                nlsInternal = jVers.getNlsClsIndicator(nlsVers);
                if (nlsInternal != null) break;
                throw new JNLSException(7);
            }
            case 1: {
                JNLSTool nlsTool = new JNLSTool(nativeLibPath);
                nlsInternal = nlsTool.detectNLSVersion();
                break;
            }
            default: {
                throw new JNLSException(9);
            }
        }
        switch (nlsInternal.charAt(0)) {
            case '2': {
                System.out.println("NLS version 2 not supported");
                throw new JNLSException(6);
            }
            case '3': {
                this.nlsLib = new JNLSLib3(nlsInternal, nativeLibPath);
                this.m_libInitialized = true;
                break;
            }
            default: {
                throw new JNLSException(7);
            }
        }
    }

    public String getNLS_LANG() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        return this.getNLS_LANG(null);
    }

    public String getNLS_LANG(String language) throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        if (this.m_libInitialized) {
            int[] retlen;
            byte[] nlsInfo;
            byte[] bLang = language == null ? null : language.getBytes();
            int status = this.nlsLib.getNLS_LANG(bLang, nlsInfo = new byte[128], retlen = new int[1]);
            if (status == 1) {
                return new String(nlsInfo, 0, retlen[0]);
            }
            this.nlsLib.throwException(status);
            return null;
        }
        throw new JNLSException(1);
    }

    public String getLanguage() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        return this.getSingleNLSInfo(2, 32);
    }

    public String getTerritory() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        return this.getSingleNLSInfo(3, 32);
    }

    public String getCharset() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        return this.getCharset(null);
    }

    public String getCharset(String language) throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        if (this.m_libInitialized) {
            int[] retlen;
            byte[] nlsInfo;
            byte[] bLang = language == null ? null : language.getBytes();
            int status = this.nlsLib.getCharset(bLang, nlsInfo = new byte[32], retlen = new int[1]);
            if (status == 1) {
                return new String(nlsInfo, 0, retlen[0]);
            }
            this.nlsLib.throwException(status);
            return null;
        }
        throw new JNLSException(1);
    }

    public String getNCHARCharset() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        return this.getNCHARCharset(null);
    }

    String getNCHARCharset(String language) throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        if (this.m_libInitialized) {
            int[] retlen;
            byte[] nlsInfo;
            byte[] bLang = language == null ? null : language.getBytes();
            int status = this.nlsLib.getNCHARCharset(bLang, nlsInfo = new byte[32], retlen = new int[1]);
            if (status == 1) {
                return new String(nlsInfo, 0, retlen[0]);
            }
            this.nlsLib.throwException(status);
            return null;
        }
        throw new JNLSException(1);
    }

    public String[] getAllCharset() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        int[] itemcnt = new int[1];
        int status = this.nlsLib.getMaxCharsetCnt(itemcnt);
        if (status != 1) {
            this.nlsLib.throwException(status);
            return null;
        }
        int buflen = itemcnt[0] * 32;
        return this.getMultiCharset(1, buflen);
    }

    public String[] getAsciiCharset() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        int[] itemcnt = new int[1];
        int status = this.nlsLib.getMaxCharsetCnt(itemcnt);
        if (status != 1) {
            this.nlsLib.throwException(status);
            return null;
        }
        int buflen = itemcnt[0] * 32;
        return this.getMultiCharset(2, buflen);
    }

    public String[] getEbcdicCharset() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        int[] itemcnt = new int[1];
        int status = this.nlsLib.getMaxCharsetCnt(itemcnt);
        if (status != 1) {
            this.nlsLib.throwException(status);
            return null;
        }
        int buflen = itemcnt[0] * 32;
        return this.getMultiCharset(3, buflen);
    }

    public String[] getFixedCharset() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        int[] itemcnt = new int[1];
        int status = this.nlsLib.getMaxCharsetCnt(itemcnt);
        if (status != 1) {
            this.nlsLib.throwException(status);
            return null;
        }
        int buflen = itemcnt[0] * 32;
        return this.getMultiCharset(4, buflen);
    }

    public String[] getNationalCharset() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        int[] itemcnt = new int[1];
        int status = this.nlsLib.getMaxCharsetCnt(itemcnt);
        if (status != 1) {
            this.nlsLib.throwException(status);
            return null;
        }
        int buflen = itemcnt[0] * 32;
        return this.getMultiCharset(5, buflen);
    }

    public String[] getStorageCharset() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        int[] itemcnt = new int[1];
        int status = this.nlsLib.getMaxCharsetCnt(itemcnt);
        if (status != 1) {
            this.nlsLib.throwException(status);
            return null;
        }
        int buflen = itemcnt[0] * 32;
        return this.getMultiCharset(6, buflen);
    }

    public String[] getAllLanguage() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        int[] itemcnt = new int[1];
        int status = this.nlsLib.getMaxLanguageCnt(itemcnt);
        if (status != 1) {
            this.nlsLib.throwException(status);
            return null;
        }
        int buflen = itemcnt[0] * 32;
        return this.getMultiNLSInfo(7, buflen, null);
    }

    public String getNLSLocaleNLS() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        String NLS_LANG = this.getNLS_LANG();
        if (NLS_LANG != null) {
            int end = NLS_LANG.indexOf(46);
            NLS_LANG = NLS_LANG.substring(0, end);
        }
        return NLS_LANG;
    }

    public Locale getNLSLocale() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        JNLSLocale jnlsLoc;
        Locale loc = null;
        String nlsLocale = this.getNLSLocaleNLS();
        if (nlsLocale != null && (loc = (jnlsLoc = JNLSLocale.getInstance()).getJavaLocale(nlsLocale)) == null) {
            int brk = nlsLocale.indexOf(95);
            String lang = nlsLocale.substring(0, brk);
            String terr = nlsLocale.substring(brk + 1);
            loc = jnlsLoc.getJavaLocale(lang, terr);
        }
        return loc;
    }

    public boolean adoptNLSLocale() throws NoSuchMethodException, OutOfMemoryError, JNLSException {
        Locale loc = this.getNLSLocale();
        if (loc != null) {
            Locale.setDefault(loc);
            return true;
        }
        return false;
    }

    public void unloadNativeNLSLib() {
        this.nlsLib.unloadNativeLib();
    }

    private String getSingleNLSInfo(int infoIdx, int infoLen) throws JNLSException, OutOfMemoryError, NoSuchMethodException {
        int status;
        if (!this.m_libInitialized) {
            throw new JNLSException(1);
        }
        int[] retlen = new int[1];
        byte[] nlsInfo = new byte[infoLen];
        switch (infoIdx) {
            case 2: {
                status = this.nlsLib.getLanguage(nlsInfo, retlen);
                break;
            }
            case 3: {
                status = this.nlsLib.getTerritory(nlsInfo, retlen);
                break;
            }
            default: {
                throw new JNLSException("getSingleNLSInfo", 10);
            }
        }
        if (status == 1) {
            return new String(nlsInfo, 0, retlen[0]);
        }
        this.nlsLib.throwException(status);
        return null;
    }

    private String[] getMultiCharset(int infoIdx, int buflen) throws JNLSException, OutOfMemoryError, NoSuchMethodException {
        return this.getMultiNLSInfo(infoIdx, buflen, "8859_1");
    }

    private String[] getMultiNLSInfo(int infoIdx, int buflen, String enc) throws JNLSException, OutOfMemoryError, NoSuchMethodException {
        int status;
        if (!this.m_libInitialized) {
            throw new JNLSException(1);
        }
        int[] retLen = new int[1];
        int[] retCnt = new int[1];
        byte[] buf = new byte[buflen];
        switch (infoIdx) {
            case 1: {
                status = this.nlsLib.getAllCharset(buf, retLen, retCnt);
                break;
            }
            case 2: {
                status = this.nlsLib.getAsciiCharset(buf, retLen, retCnt);
                break;
            }
            case 3: {
                status = this.nlsLib.getEbcdicCharset(buf, retLen, retCnt);
                break;
            }
            case 4: {
                status = this.nlsLib.getFixedCharset(buf, retLen, retCnt);
                break;
            }
            case 5: {
                status = this.nlsLib.getNationalCharset(buf, retLen, retCnt);
                break;
            }
            case 6: {
                status = this.nlsLib.getStorageCharset(buf, retLen, retCnt);
                break;
            }
            case 7: {
                status = this.nlsLib.getAllLanguage(buf, retLen, retCnt);
                break;
            }
            default: {
                throw new JNLSException("getMultiNLSInfo", 10);
            }
        }
        if (status != 1) {
            this.nlsLib.throwException(status);
            return null;
        }
        if (retCnt[0] == 0 || retLen[0] == 0) {
            return null;
        }
        String[] multiInfo = new String[retCnt[0]];
        int bufIdx = 0;
        int csIdx = 0;
        while (csIdx < retCnt[0] && bufIdx < retLen[0]) {
            byte csLen;
            if ((csLen = buf[bufIdx++]) == 0 || bufIdx + csLen >= retLen[0]) break;
            if (enc == null) {
                multiInfo[csIdx] = new String(buf, bufIdx, (int)csLen);
            } else {
                try {
                    multiInfo[csIdx] = new String(buf, bufIdx, (int)csLen, enc);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    multiInfo[csIdx] = new String(buf, bufIdx, (int)csLen);
                }
            }
            bufIdx += csLen;
            ++csIdx;
        }
        return multiInfo;
    }
}

