/*
 * Decompiled with CFR 0.152.
 */
package oracle.ntpg.jnls;

import oracle.ntpg.jnls.JNLSException;

class JNLSLib {
    static final int ST_SUCCESS = 1;
    static final int ST_LOADBOOTERR = 0;
    static final int ST_INITERR = -1;
    static final int ST_TERMERR = -2;
    static final int ST_LOADRTLERR = -3;
    static final int ST_RTLNOTLOADED = -4;
    static final int ST_RTLNOTINIT = -5;
    static final int ST_OUTOFMEMORY = -6;
    static final int ST_NOSUCHAPI = -7;
    static final int ST_DATALOADERR = -8;
    static final int ST_NLSINVITEMCODE = -9;
    static final int ST_BUFTOOSMALL = -10;
    static final int CT_COUNTBYTE = 3;
    static final int CT_MAXNUMPERBYTE = 127;
    static final int CT_MAXCHARSETCNT = 381;
    static final int CT_MAX_NLS_LANG_LEN = 128;
    static final int CT_MAXCHARSETLEN = 32;
    static final int CT_MAXTERRLEN = 32;
    static final int CT_MAXLANGLEN = 32;
    static final int CT_MAXNAMELEN = 32;
    protected boolean m_libInitialized = false;
    protected String m_nativeLibPath;

    protected native int initLib(byte[] var1, byte[] var2);

    protected native int termLib();

    native int getNLS_LANG(byte[] var1, byte[] var2, int[] var3);

    native int getLanguage(byte[] var1, int[] var2);

    native int getTerritory(byte[] var1, int[] var2);

    native int getCharset(byte[] var1, byte[] var2, int[] var3);

    native int getNCHARCharset(byte[] var1, byte[] var2, int[] var3);

    native int getAllCharset(byte[] var1, int[] var2, int[] var3);

    native int getAsciiCharset(byte[] var1, int[] var2, int[] var3);

    native int getEbcdicCharset(byte[] var1, int[] var2, int[] var3);

    native int getFixedCharset(byte[] var1, int[] var2, int[] var3);

    native int getNationalCharset(byte[] var1, int[] var2, int[] var3);

    native int getStorageCharset(byte[] var1, int[] var2, int[] var3);

    native int getMaxCharsetCnt(int[] var1);

    native int getMaxLanguageCnt(int[] var1);

    native int getAllLanguage(byte[] var1, int[] var2, int[] var3);

    JNLSLib(String nlsVers, String nativeLibPath, String nativeLibName) throws JNLSException {
        this.m_nativeLibPath = nativeLibPath;
        System.loadLibrary(String.valueOf(nativeLibPath) + nativeLibName);
        switch (this.initLib(nlsVers.getBytes(), this.m_nativeLibPath.getBytes())) {
            case 1: {
                this.m_libInitialized = true;
                break;
            }
            case 0: {
                this.m_libInitialized = true;
                throw new JNLSException(3);
            }
            case -3: {
                this.m_libInitialized = false;
                throw new JNLSException(5);
            }
            default: {
                this.m_libInitialized = false;
                throw new JNLSException(2);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.m_libInitialized) {
            this.termLib();
            this.m_libInitialized = false;
        }
        super.finalize();
    }

    void throwException(int error) throws JNLSException, OutOfMemoryError, NoSuchMethodException {
        switch (error) {
            case 0: {
                throw new JNLSException(3);
            }
            case -1: {
                throw new JNLSException(2);
            }
            case -4: 
            case -3: {
                throw new JNLSException(5);
            }
            case -5: {
                throw new JNLSException(1);
            }
            case -6: {
                throw new OutOfMemoryError();
            }
            case -7: {
                throw new NoSuchMethodException();
            }
            case -10: 
            case -9: {
                throw new JNLSException(Integer.toString(error), 1);
            }
        }
    }

    void unloadNativeLib() {
        if (this.m_libInitialized) {
            this.termLib();
            this.m_libInitialized = false;
        }
    }
}

