/*
 * Decompiled with CFR 0.152.
 */
package oracle.ntpg.jnls;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class JNLSLocale {
    static JNLSLocale m_JNLSLocaleInstance;
    private Hashtable m_NLSLocale2JavaLocale;
    private Hashtable m_NLSLang2JavaLang;
    private Hashtable m_NLSTerr2JavaTerr;
    private Hashtable m_NLSCharset2JavaCharset;
    private Hashtable m_JavaCharset2NLSCharset;
    private Hashtable m_JavaLocale2NLSLocale;

    JNLSLocale() {
    }

    public static JNLSLocale getInstance() {
        if (m_JNLSLocaleInstance == null) {
            m_JNLSLocaleInstance = new JNLSLocale();
        }
        return m_JNLSLocaleInstance;
    }

    public Locale getJavaLocale(String nlsLocale) {
        return (Locale)this.getNLSLoc2JavaLocTable().get(nlsLocale);
    }

    public Locale getJavaLocale(String nlsLanguage, String nlsTerritory) {
        String javaTerritory;
        Locale loc = null;
        String javaLang = (String)this.getNLSLang2JavaLangTable().get(nlsLanguage);
        if (javaLang != null && (javaTerritory = (String)this.getNLSTerr2JavaTerrTable().get(nlsTerritory)) != null) {
            loc = new Locale(javaLang, javaTerritory);
        }
        return loc;
    }

    public Enumeration enumNLSLocales() {
        return this.getNLSLoc2JavaLocTable().keys();
    }

    public Enumeration enumJavaLocales() {
        return this.getJavaLoc2NLSLocTable().keys();
    }

    public String getJavaCharset(String nlsCharset) {
        return (String)this.getNLSCS2JavaCSTable().get(nlsCharset);
    }

    public String getNLSCharset(String javaCharset) {
        return (String)this.getJavaCS2NLSCSTable().get(javaCharset);
    }

    public Enumeration enumNLSCharsets() {
        return this.getNLSCS2JavaCSTable().keys();
    }

    public Enumeration enumJavaCharsets() {
        return this.getJavaCS2NLSCSTable().keys();
    }

    public String getNLSLocale() {
        return this.getNLSLocale(Locale.getDefault());
    }

    public String getNLSLocale(Locale javaLocale) {
        return (String)this.getJavaLoc2NLSLocTable().get(javaLocale);
    }

    Hashtable getNLSLoc2JavaLocTable() {
        if (this.m_NLSLocale2JavaLocale == null) {
            this.m_NLSLocale2JavaLocale = this.createNLSLocale2JavaLocale();
        }
        return this.m_NLSLocale2JavaLocale;
    }

    Hashtable getNLSLang2JavaLangTable() {
        if (this.m_NLSLang2JavaLang == null) {
            this.m_NLSLang2JavaLang = this.createNLSLang2JavaLang();
        }
        return this.m_NLSLang2JavaLang;
    }

    Hashtable getNLSTerr2JavaTerrTable() {
        if (this.m_NLSTerr2JavaTerr == null) {
            this.m_NLSTerr2JavaTerr = this.createNLSTerr2JavaTerr();
        }
        return this.m_NLSTerr2JavaTerr;
    }

    Hashtable getNLSCS2JavaCSTable() {
        if (this.m_NLSCharset2JavaCharset == null) {
            this.m_NLSCharset2JavaCharset = this.createNLSCharset2JavaCharset();
        }
        return this.m_NLSCharset2JavaCharset;
    }

    Hashtable getJavaCS2NLSCSTable() {
        if (this.m_JavaCharset2NLSCharset == null) {
            this.m_JavaCharset2NLSCharset = this.createJavaCharset2NLSCharset();
        }
        return this.m_JavaCharset2NLSCharset;
    }

    Hashtable getJavaLoc2NLSLocTable() {
        if (this.m_JavaLocale2NLSLocale == null) {
            this.m_JavaLocale2NLSLocale = this.createJavaLocale2NLSLocale();
        }
        return this.m_JavaLocale2NLSLocale;
    }

    Hashtable createNLSLang2JavaLang() {
        Hashtable<String, String> tab = new Hashtable<String, String>(40, 1.0f);
        tab.put("AMERICAN", "en");
        tab.put("ARABIC", "ar");
        tab.put("BRAZILIAN PORTUGUESE", "pt");
        tab.put("BULGARIAN", "bg");
        tab.put("CATALAN", "ca");
        tab.put("CROATIAN", "hr");
        tab.put("CZECH", "cs");
        tab.put("DANISH", "da");
        tab.put("DUTCH", "nl");
        tab.put("ENGLISH", "en");
        tab.put("ESTONIAN", "et");
        tab.put("FINNISH", "fi");
        tab.put("FRENCH", "fr");
        tab.put("GERMAN", "de");
        tab.put("GREEK", "el");
        tab.put("HEBREW", "iw");
        tab.put("HUNGARIAN", "hu");
        tab.put("ICELANDIC", "is");
        tab.put("INDONESIAN", "in");
        tab.put("ITALIAN", "it");
        tab.put("JAPANESE", "ja");
        tab.put("KOREAN", "ko");
        tab.put("LATVIAN", "lv");
        tab.put("LITHUANIAN", "lt");
        tab.put("MEXICAN SPANISH", "es");
        tab.put("NORWEGIAN", "no");
        tab.put("POLISH", "pl");
        tab.put("PORTUGUESE", "pt");
        tab.put("ROMANIAN", "ro");
        tab.put("RUSSIAN", "ru");
        tab.put("SIMPLIFIED CHINESE", "zh");
        tab.put("SLOVAK", "sk");
        tab.put("SOLVENIAN", "sl");
        tab.put("SPANISH", "es");
        tab.put("SWEDISH", "sv");
        tab.put("THAI", "th");
        tab.put("TRADITIONAL CHINESE", "zh");
        tab.put("TURKISH", "tr");
        tab.put("UKRAINIAN", "uk");
        tab.put("VIETNAMESE", "vi");
        return tab;
    }

    Hashtable createNLSTerr2JavaTerr() {
        Hashtable<String, String> tab = new Hashtable<String, String>(59, 1.0f);
        tab.put("ALGERIA", "DZ");
        tab.put("AMERICA", "US");
        tab.put("AUSTRIA", "AT");
        tab.put("BAHRAIN", "BH");
        tab.put("BRAZIL", "BR");
        tab.put("BULGARIA", "BG");
        tab.put("CANADA", "CA");
        tab.put("CATALONIA", "ES");
        tab.put("CHINA", "CN");
        tab.put("CIS", "RU");
        tab.put("CROATIA", "HR");
        tab.put("CZECH REPUBLIC", "CZ");
        tab.put("DENMARK", "DK");
        tab.put("EGYPT", "EG");
        tab.put("ESTONIA", "EE");
        tab.put("FINLAND", "FI");
        tab.put("FRANCE", "FR");
        tab.put("GERMANY", "DE");
        tab.put("GREECE", "GR");
        tab.put("HONG KONG", "HK");
        tab.put("HUNGARY", "HU");
        tab.put("ICELAND", "IS");
        tab.put("INDONESIA", "ID");
        tab.put("IRAQ", "IQ");
        tab.put("ISRAEL", "IL");
        tab.put("ITALY", "IT");
        tab.put("JAPAN", "JP");
        tab.put("JORDAN", "JO");
        tab.put("KOREA", "KR");
        tab.put("KUWAIT", "KW");
        tab.put("LATVIA", "LV");
        tab.put("LEBANON", "LB");
        tab.put("LIBYA", "LY");
        tab.put("LITHUANIA", "LT");
        tab.put("MEXICO", "MX");
        tab.put("MOROCCO", "MA");
        tab.put("NORWAY", "NO");
        tab.put("OMAN", "OM");
        tab.put("POLAND", "PL");
        tab.put("PORTUGAL", "PT");
        tab.put("QATAR", "QA");
        tab.put("ROMANIA", "RO");
        tab.put("SANDI ARABIA", "SA");
        tab.put("SLOVENIA", "SI");
        tab.put("SLOVKIA", "SK");
        tab.put("SPAIN", "ES");
        tab.put("SWEDEN", "SE");
        tab.put("SWITZERLAND", "CH");
        tab.put("SYRIA", "SY");
        tab.put("TAIWAN", "TW");
        tab.put("THAILAND", "TH");
        tab.put("THE NETHERLANDS", "NL");
        tab.put("TUNISIA", "TN");
        tab.put("TURKEY", "TR");
        tab.put("UKRAINE", "UA");
        tab.put("UNITED ARAB EMIRATES", "AE");
        tab.put("UNITED KINGDOM", "GB");
        tab.put("VIETNAM", "VN");
        tab.put("YEMAN", "YE");
        return tab;
    }

    Hashtable createNLSLocale2JavaLocale() {
        Hashtable<String, Locale> tab = new Hashtable<String, Locale>(63, 1.0f);
        tab.put("AMERICAN_AMERICA", new Locale("en", "US"));
        tab.put("ARABIC_ALGERIA", new Locale("ar", "DZ"));
        tab.put("ARABIC_BAHRAIN", new Locale("ar", "BH"));
        tab.put("ARABIC_EGYPT", new Locale("ar", "EG"));
        tab.put("ARABIC_IRAQ", new Locale("ar", "IQ"));
        tab.put("ARABIC_JORDAN", new Locale("ar", "JO"));
        tab.put("ARABIC_KUWAIT", new Locale("ar", "KW"));
        tab.put("ARABIC_LEBANON", new Locale("ar", "LB"));
        tab.put("ARABIC_LIBYA", new Locale("ar", "LY"));
        tab.put("ARABIC_MOROCCO", new Locale("ar", "MA"));
        tab.put("ARABIC_OMAN", new Locale("ar", "OM"));
        tab.put("ARABIC_QATAR", new Locale("ar", "QA"));
        tab.put("ARABIC_SANDI ARABIA", new Locale("ar", "SA"));
        tab.put("ARABIC_SYRIA", new Locale("ar", "SY"));
        tab.put("ARABIC_TUNISIA", new Locale("ar", "TN"));
        tab.put("ARABIC_UNITED ARAB EMIRATES", new Locale("ar", "AE"));
        tab.put("ARABIC_YEMAN", new Locale("ar", "YE"));
        tab.put("BRAZILIAN PORTUGUESE_BRAZIL", new Locale("pt", "BR"));
        tab.put("BULGARIAN_BULGARIA", new Locale("bg", "BG"));
        tab.put("CANADIAN FRENCH_CANADA", new Locale("fr", "CA"));
        tab.put("CATALAN_CATALONIA", new Locale("ca", "ES"));
        tab.put("CROATIAN_CROATIA", new Locale("hr", "HR"));
        tab.put("CZECH_CZECH REPUBLIC", new Locale("cs", "CZ"));
        tab.put("DANISH_DENMARK", new Locale("da", "DK"));
        tab.put("DUTCH_THE NETHERLANDS", new Locale("nl", "NL"));
        tab.put("ENGLISH_CANADA", new Locale("en", "CA"));
        tab.put("ENGLISH_UNITED KINGDOM", new Locale("en", "GB"));
        tab.put("ESTONIAN_ESTONIA", new Locale("et", "EE"));
        tab.put("FINNISH_FINLAND", new Locale("fi", "FI"));
        tab.put("FRENCH_FRANCE", new Locale("fr", "FR"));
        tab.put("FRENCH_SWITZERLAND", new Locale("fr", "CH"));
        tab.put("GERMAN_AUSTRIA", new Locale("de", "AT"));
        tab.put("GERMAN_GERMANY", new Locale("de", "DE"));
        tab.put("GERMAN_SWITZERLAND", new Locale("de", "CH"));
        tab.put("GREEK_GREECE", new Locale("el", "GR"));
        tab.put("HEBREW_ISRAEL", new Locale("iw", "IL"));
        tab.put("HUNGARIAN_HUNGARY", new Locale("hu", "HU"));
        tab.put("ICELANDIC_ICELAND", new Locale("is", "IS"));
        tab.put("INDONESIAN_INDONESIA", new Locale("in", "ID"));
        tab.put("ITALIAN_ITALY", new Locale("it", "IT"));
        tab.put("ITALIAN_SWITZERLAND", new Locale("it", "CH"));
        tab.put("JAPANESE_JAPAN", new Locale("ja", "JP"));
        tab.put("KOREAN_KOREA", new Locale("ko", "KR"));
        tab.put("LATVIAN_LATVIA", new Locale("lv", "LV"));
        tab.put("LITHUANIAN_LITHUANIA", new Locale("lt", "LT"));
        tab.put("MEXICAN SPANISH_MEXICO", new Locale("es", "MX"));
        tab.put("NORWEGIAN_NORWAY", new Locale("no", "NO"));
        tab.put("POLISH_POLAND", new Locale("pl", "PL"));
        tab.put("PORTUGUESE_PORTUGAL", new Locale("pt", "PT"));
        tab.put("ROMANIAN_ROMANIA", new Locale("ro", "RO"));
        tab.put("RUSSIAN_CIS", new Locale("ru", "RU"));
        tab.put("SIMPLIFIED CHINESE_CHINA", new Locale("zh", "CN"));
        tab.put("SLOVAK_SLOVKIA", new Locale("sk", "SK"));
        tab.put("SOLVENIAN_SLOVENIA", new Locale("sl", "SI"));
        tab.put("SPANISH_SPAIN", new Locale("es", "ES"));
        tab.put("SWEDISH_FINLAND", new Locale("sv", "FI"));
        tab.put("SWEDISH_SWEDEN", new Locale("sv", "SE"));
        tab.put("THAI_THAILAND", new Locale("th", "TH"));
        tab.put("TRADITIONAL CHINESE_HONG KONG", new Locale("zh", "TW"));
        tab.put("TRADITIONAL CHINESE_TAIWAN", new Locale("zh", "TW"));
        tab.put("TURKISH_TURKEY", new Locale("tr", "TR"));
        tab.put("UKRAINIAN_UKRAINE", new Locale("uk", "UA"));
        tab.put("VIETNAMESE_VIETNAM", new Locale("vi", "VN"));
        return tab;
    }

    Hashtable createNLSCharset2JavaCharset() {
        Hashtable<String, String> tab = new Hashtable<String, String>(88, 1.0f);
        tab.put("AL24UTFFSS", "UTF8");
        tab.put("AR8ARABICMAC", "MacArabic");
        tab.put("AR8ARABICMACS", "MacArabic");
        tab.put("AR8ISO8859P6", "8859_6");
        tab.put("AR8MSAWIN", "Cp1256");
        tab.put("AR8MSWIN1256", "Cp1256");
        tab.put("BLT8EBCDIC1112", "Cp1112");
        tab.put("BLT8MSWIN1257", "Cp1257");
        tab.put("BLT8PC775", "Cp775");
        tab.put("CDN8PC863", "Cp863");
        tab.put("CL8EBCDIC1025", "Cp1025");
        tab.put("CL8EBCDIC1025X", "Cp1025");
        tab.put("CL8ISO8859P5", "8859_5");
        tab.put("CL8KOI8R", "KOI8_R");
        tab.put("CL8MACCYRILLIC", "MacCyrillic");
        tab.put("CL8MACCYRILLICS", "MacCyrillic");
        tab.put("CL8MSWIN1251", "Cp1251");
        tab.put("D8EBCDIC273", "Cp273");
        tab.put("DK8EBCDIC277", "Cp277");
        tab.put("EE8EBCDIC870", "Cp870");
        tab.put("EE8ISO8859P2", "8859_2");
        tab.put("EE8MACCE", "MacCentralEurope");
        tab.put("EE8MACCES", "MacCentralEurope");
        tab.put("EE8MACCROATIAN", "MacCroatian");
        tab.put("EE8MACCROATIANS", "MacCroatian");
        tab.put("EE8MSWIN1250", "Cp1250");
        tab.put("EE8PC852", "Cp852");
        tab.put("EL8EBCDIC875", "Cp875");
        tab.put("EL8ISO8859P7", "8859_7");
        tab.put("EL8MACGREEK", "MacGreek");
        tab.put("EL8MACGREEKS", "MacGreek");
        tab.put("EL8MSWIN1253", "Cp1253");
        tab.put("EL8PC737", "Cp737");
        tab.put("EL8PC869", "Cp869");
        tab.put("F8EBCDIC297", "Cp297");
        tab.put("I8EBCDIC280", "Cp280");
        tab.put("IS8MACICELANDIC", "MacIceland");
        tab.put("IS8MACICELANDICS", "MacIceland");
        tab.put("IS8PC861", "Cp861");
        tab.put("IW8EBCDIC424", "Cp424");
        tab.put("IW8ISO8859P8", "8859_8");
        tab.put("IW8MACHEBREW", "MacHebrew");
        tab.put("IW8MACHEBREWS", "MacHebrew");
        tab.put("IW8MSWIN1255", "Cp1255");
        tab.put("JA16EBCDIC930", "Cp930");
        tab.put("JA16EUC", "EUCJIS");
        tab.put("JA16EUCYEN", "EUCJIS");
        tab.put("JA16MACSJIS", "SJIS");
        tab.put("JA16SJIS", "SJIS");
        tab.put("JA16SJISYEN", "SJIS");
        tab.put("JA16VMS", "JIS0208");
        tab.put("KO16KSC5601", "KSC5601");
        tab.put("LT8MSWIN921", "Cp921");
        tab.put("N8PC865", "Cp865");
        tab.put("NEE8ISO8859P4", "8859_4");
        tab.put("RU8PC855", "Cp855");
        tab.put("RU8PC866", "Cp866");
        tab.put("S8EBCDIC278", "Cp278");
        tab.put("SE8ISO8859P3", "8859_3");
        tab.put("TH8MACTHAI", "MacThai");
        tab.put("TH8MACTHAIS", "MacThai");
        tab.put("TH8TISASCII", "Cp874");
        tab.put("TR8EBCDIC1026", "Cp1026");
        tab.put("TR8MACTURKISH", "MacTurkish");
        tab.put("TR8MACTURKISHS", "MacTurkish");
        tab.put("TR8MSWIN1254", "Cp1254");
        tab.put("TR8PC857", "Cp857");
        tab.put("US7ASCII", "8859_1");
        tab.put("US8PC437", "Cp437");
        tab.put("UTF8", "UTF8");
        tab.put("WE8EBCDIC284", "Cp284");
        tab.put("WE8EBCDIC285", "Cp285");
        tab.put("WE8EBCDIC37", "Cp037");
        tab.put("WE8EBCDIC37C", "Cp037");
        tab.put("WE8EBCDIC500", "Cp500");
        tab.put("WE8EBCDIC500C", "Cp500");
        tab.put("WE8EBCDIC871", "Cp871");
        tab.put("WE8ISO8859P1", "8859_1");
        tab.put("WE8ISO8859P9", "8859_9");
        tab.put("WE8MACROMAN8", "MacRoman");
        tab.put("WE8MACROMAN8S", "MacRoman");
        tab.put("WE8MSWIN1252", "Cp1252");
        tab.put("WE8PC850", "Cp850");
        tab.put("WE8PC860", "Cp860");
        tab.put("ZHS16CGB231280", "GB2312");
        tab.put("ZHS16GBK", "GBK");
        tab.put("ZHS16MACCGB231280", "GB2312");
        tab.put("ZHT16BIG5", "Big5");
        return tab;
    }

    Hashtable createJavaCharset2NLSCharset() {
        Hashtable<String, String> tab = new Hashtable<String, String>(67, 1.0f);
        tab.put("8859_1", "WE8ISO8859P1");
        tab.put("8859_2", "EE8ISO8859P2");
        tab.put("8859_3", "SE8ISO8859P3");
        tab.put("8859_4", "NEE8ISO8859P4");
        tab.put("8859_5", "CL8ISO8859P5");
        tab.put("8859_6", "AR8ISO8859P6");
        tab.put("8859_7", "EL8ISO8859P7");
        tab.put("8859_8", "IW8ISO8859P8");
        tab.put("8859_9", "WE8ISO8859P9");
        tab.put("Big5", "ZHT16BIG5");
        tab.put("Cp037", "WE8EBCDIC37");
        tab.put("Cp1025", "CL8EBCDIC1025");
        tab.put("Cp1026", "TR8EBCDIC1026");
        tab.put("Cp1112", "BLT8EBCDIC1112");
        tab.put("Cp1250", "EE8MSWIN1250");
        tab.put("Cp1251", "CL8MSWIN1251");
        tab.put("Cp1252", "WE8MSWIN1252");
        tab.put("Cp1253", "EL8MSWIN1253");
        tab.put("Cp1254", "TR8MSWIN1254");
        tab.put("Cp1255", "IW8MSWIN1255");
        tab.put("Cp1256", "AR8MSWIN1256");
        tab.put("Cp1257", "BLT8MSWIN1257");
        tab.put("Cp273", "D8EBCDIC273");
        tab.put("Cp277", "DK8EBCDIC277");
        tab.put("Cp278", "S8EBCDIC278");
        tab.put("Cp280", "I8EBCDIC280");
        tab.put("Cp284", "WE8EBCDIC284");
        tab.put("Cp285", "WE8EBCDIC285");
        tab.put("Cp297", "F8EBCDIC297");
        tab.put("Cp424", "IW8EBCDIC424");
        tab.put("Cp437", "US8PC437");
        tab.put("Cp500", "WE8EBCDIC500");
        tab.put("Cp737", "EL8PC737");
        tab.put("Cp775", "BLT8PC775");
        tab.put("Cp850", "WE8PC850");
        tab.put("Cp852", "EE8PC852");
        tab.put("Cp855", "RU8PC855");
        tab.put("Cp857", "TR8PC857");
        tab.put("Cp860", "WE8PC860");
        tab.put("Cp861", "IS8PC861");
        tab.put("Cp863", "CDN8PC863");
        tab.put("Cp865", "N8PC865");
        tab.put("Cp866", "RU8PC866");
        tab.put("Cp869", "EL8PC869");
        tab.put("Cp870", "EE8EBCDIC870");
        tab.put("Cp871", "WE8EBCDIC871");
        tab.put("Cp874", "TH8TISASCII");
        tab.put("Cp875", "EL8EBCDIC875");
        tab.put("Cp921", "LT8MSWIN921");
        tab.put("Cp930", "JA16EBCDIC930");
        tab.put("EUCJIS", "JA16EUC");
        tab.put("GB2312", "ZHS16CGB231280");
        tab.put("GBK", "ZHS16GBK");
        tab.put("KOI8_R", "CL8KOI8R");
        tab.put("KSC5601", "KO16KSC5601");
        tab.put("MacArabic", "AR8ARABICMAC");
        tab.put("MacCentralEurope", "EE8MACCE");
        tab.put("MacCroatian", "EE8MACCROATIAN");
        tab.put("MacCyrillic", "CL8MACCYRILLIC");
        tab.put("MacGreek", "EL8MACGREEK");
        tab.put("MacHebrew", "IW8MACHEBREW");
        tab.put("MacIceland", "IS8MACICELANDIC");
        tab.put("MacRoman", "WE8MACROMAN8");
        tab.put("MacThai", "TH8MACTHAI");
        tab.put("MacTurkish", "TR8MACTURKISH");
        tab.put("SJIS", "JA16SJIS");
        tab.put("UTF8", "UTF8");
        return tab;
    }

    Hashtable createJavaLocale2NLSLocale() {
        Hashtable<Locale, String> tab = new Hashtable<Locale, String>(63, 1.0f);
        tab.put(new Locale("ar", "AE"), "ARABIC_UNITED ARAB EMIRATES");
        tab.put(new Locale("ar", "BH"), "ARABIC_BAHRAIN");
        tab.put(new Locale("ar", "DZ"), "ARABIC_ALGERIA");
        tab.put(new Locale("ar", "EG"), "ARABIC_EGYPT");
        tab.put(new Locale("ar", "IQ"), "ARABIC_IRAQ");
        tab.put(new Locale("ar", "JO"), "ARABIC_JORDAN");
        tab.put(new Locale("ar", "KW"), "ARABIC_KUWAIT");
        tab.put(new Locale("ar", "LB"), "ARABIC_LEBANON");
        tab.put(new Locale("ar", "LY"), "ARABIC_LIBYA");
        tab.put(new Locale("ar", "MA"), "ARABIC_MOROCCO");
        tab.put(new Locale("ar", "OM"), "ARABIC_OMAN");
        tab.put(new Locale("ar", "QA"), "ARABIC_QATAR");
        tab.put(new Locale("ar", "SA"), "ARABIC_SANDI ARABIA");
        tab.put(new Locale("ar", "SY"), "ARABIC_SYRIA");
        tab.put(new Locale("ar", "TN"), "ARABIC_TUNISIA");
        tab.put(new Locale("ar", "YE"), "ARABIC_YEMAN");
        tab.put(new Locale("bg", "BG"), "BULGARIAN_BULGARIA");
        tab.put(new Locale("ca", "ES"), "CATALAN_CATALONIA");
        tab.put(new Locale("cs", "CZ"), "CZECH_CZECH REPUBLIC");
        tab.put(new Locale("da", "DK"), "DANISH_DENMARK");
        tab.put(new Locale("de", "AT"), "GERMAN_AUSTRIA");
        tab.put(new Locale("de", "CH"), "GERMAN_SWITZERLAND");
        tab.put(new Locale("de", "DE"), "GERMAN_GERMANY");
        tab.put(new Locale("el", "GR"), "GREEK_GREECE");
        tab.put(new Locale("en", "US"), "AMERICAN_AMERICA");
        tab.put(new Locale("en", "CA"), "ENGLISH_CANADA");
        tab.put(new Locale("en", "GB"), "ENGLISH_UNITED KINGDOM");
        tab.put(new Locale("es", "ES"), "SPANISH_SPAIN");
        tab.put(new Locale("es", "MX"), "MEXICAN SPANISH_MEXICO");
        tab.put(new Locale("et", "EE"), "ESTONIAN_ESTONIA");
        tab.put(new Locale("fi", "FI"), "FINNISH_FINLAND");
        tab.put(new Locale("fr", "CA"), "CANADIAN FRENCH_CANADA");
        tab.put(new Locale("fr", "CH"), "FRENCH_SWITZERLAND");
        tab.put(new Locale("fr", "FR"), "FRENCH_FRANCE");
        tab.put(new Locale("hr", "HR"), "CROATIAN_CROATIA");
        tab.put(new Locale("hu", "HU"), "HUNGARIAN_HUNGARY");
        tab.put(new Locale("in", "ID"), "INDONESIAN_INDONESIA");
        tab.put(new Locale("is", "IS"), "ICELANDIC_ICELAND");
        tab.put(new Locale("it", "CH"), "ITALIAN_SWITZERLAND");
        tab.put(new Locale("it", "IT"), "ITALIAN_ITALY");
        tab.put(new Locale("iw", "IL"), "HEBREW_ISRAEL");
        tab.put(new Locale("ja", "JP"), "JAPANESE_JAPAN");
        tab.put(new Locale("ko", "KR"), "KOREAN_KOREA");
        tab.put(new Locale("lt", "LT"), "LITHUANIAN_LITHUANIA");
        tab.put(new Locale("lv", "LV"), "LATVIAN_LATVIA");
        tab.put(new Locale("nl", "NL"), "DUTCH_THE NETHERLANDS");
        tab.put(new Locale("no", "NO"), "NORWEGIAN_NORWAY");
        tab.put(new Locale("pl", "PL"), "POLISH_POLAND");
        tab.put(new Locale("pt", "BR"), "BRAZILIAN PORTUGUESE_BRAZIL");
        tab.put(new Locale("pt", "PT"), "PORTUGUESE_PORTUGAL");
        tab.put(new Locale("ro", "RO"), "ROMANIAN_ROMANIA");
        tab.put(new Locale("ru", "RU"), "RUSSIAN_CIS");
        tab.put(new Locale("sk", "SK"), "SLOVAK_SLOVKIA");
        tab.put(new Locale("sl", "SI"), "SOLVENIAN_SLOVENIA");
        tab.put(new Locale("sv", "FI"), "SWEDISH_FINLAND");
        tab.put(new Locale("sv", "SE"), "SWEDISH_SWEDEN");
        tab.put(new Locale("th", "TH"), "THAI_THAILAND");
        tab.put(new Locale("tr", "TR"), "TURKISH_TURKEY");
        tab.put(new Locale("uk", "UA"), "UKRAINIAN_UKRAINE");
        tab.put(new Locale("vi", "VN"), "VIETNAMESE_VIETNAM");
        tab.put(new Locale("zh", "CN"), "SIMPLIFIED CHINESE_CHINA");
        tab.put(new Locale("zh", "HK"), "TRADITIONAL CHINESE_HONG KONG");
        tab.put(new Locale("zh", "TW"), "TRADITIONAL CHINESE_TAIWAN");
        return tab;
    }
}

