/*
 * Decompiled with CFR 0.152.
 */
package oracle.ntpg.jnls;

import oracle.ntpg.jnls.JNLSException;

class JNLSTool {
    static final int JNT_SUCCESS = 1;
    static final int JNT_MISCERR = -1;
    static final int JNT_OUTOFMEMORY = -2;
    static final int JNT_ENVIRONMERR = -3;
    static final int JNT_INVALIDPARAM = -4;
    static final int JNT_KEYNOTFOUND = -5;
    static final int JNT_LOADRTLERR = -6;
    static final int JNT_RTLINCOMPATIBLE = -7;
    private String m_nativeLibPath;

    JNLSTool(String nativeLibPath) {
        System.loadLibrary(String.valueOf(nativeLibPath) + "JNLSTool");
        this.nativeSetLibPath(nativeLibPath.getBytes());
        this.m_nativeLibPath = nativeLibPath;
    }

    native int nativeDetNLSVersion(byte[] var1, int[] var2);

    native int nativeSetLibPath(byte[] var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String detectNLSVersion() throws JNLSException, OutOfMemoryError {
        String nlsVerStr = null;
        byte[] nlsVer = new byte[8];
        int[] retlen = new int[1];
        int status = this.nativeDetNLSVersion(nlsVer, retlen);
        if (status == 1) {
            if (retlen[0] <= 0) throw new JNLSException("No NLS version detected");
            return new String(nlsVer, 0, retlen[0]);
        }
        this.throwException(status);
        return nlsVerStr;
    }

    void throwException(int error) throws JNLSException, OutOfMemoryError {
        switch (error) {
            case -2: {
                throw new OutOfMemoryError();
            }
            case -3: {
                throw new JNLSException("Miscellaneous environment error");
            }
            case -4: {
                throw new JNLSException("Internal error");
            }
            case -5: {
                throw new JNLSException("NLSRTL key not found in registry");
            }
            case -6: {
                throw new JNLSException("Failed to load library (maybe CORE)");
            }
            case -7: {
                throw new JNLSException("Native support library is not compatible");
            }
            default: {
                throw new JNLSException("Miscellaneous error condition");
            }
            case 1: 
        }
    }
}

