/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applet;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import sunw.hotjava.applet.AppletClassLoader;
import sunw.hotjava.applet.AppletIllegalArgumentException;

class AppletObjectInputStream
extends ObjectInputStream {
    private AppletClassLoader loader;
    private SecurityManager manager;

    public AppletObjectInputStream(InputStream inputStream, AppletClassLoader appletClassLoader, SecurityManager securityManager) throws IOException, StreamCorruptedException {
        super(inputStream);
        if (appletClassLoader == null) {
            throw new AppletIllegalArgumentException("appletillegalargumentexception.objectinputstream");
        }
        this.loader = appletClassLoader;
        this.manager = securityManager;
    }

    private Class primitiveType(char c) {
        switch (c) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (string.startsWith("[")) {
            Class clazz;
            Object object;
            int n = 1;
            while (string.charAt(n) == '[') {
                ++n;
            }
            if (string.charAt(n) == 'L') {
                object = string.substring(n + 1, string.length() - 1);
                clazz = this.loader.loadClass((String)object, this.manager);
            } else {
                if (string.length() != n + 1) {
                    throw new ClassNotFoundException(string);
                }
                clazz = this.primitiveType(string.charAt(n));
            }
            object = new int[n];
            int n2 = 0;
            while (n2 < n) {
                object[n2] = false;
                ++n2;
            }
            return Array.newInstance(clazz, (int[])object).getClass();
        }
        return this.loader.loadClass(string, this.manager);
    }
}

