/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import sunw.hotjava.misc.Globals;

public class DisplayOnlyEditor
implements PropertyEditor {
    private Displayable value;

    public void setValue(Object object) {
        this.value = (Displayable)object;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = Globals.localProps.handleGetString("bean.show.property.text");
        Color color = Globals.mapNamedColor(System.getProperty("bean.show.property.fg"));
        Color color2 = Globals.mapNamedColor(System.getProperty("bean.show.property.bg"));
        if (color == null) {
            color = graphics.getColor();
        }
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fill3DRect(0, 0, rectangle.width, rectangle.height, true);
        }
        graphics.setColor(color);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        int n2 = fontMetrics.stringWidth(string);
        int n3 = (rectangle.width - n2) / 2;
        graphics.drawString(string, n3, rectangle.height - n);
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        String string = this.value.toDisplayString();
        TextArea textArea = new TextArea(string, 30, 80);
        textArea.setEditable(false);
        return textArea;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public interface Displayable {
        public String toDisplayString();
    }
}

