/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean;

import java.awt.Adjustable;
import java.awt.Frame;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sunw.hotjava.bean.BrowserHistoryEvent;
import sunw.hotjava.bean.BrowserHistoryListener;
import sunw.hotjava.bean.CurrentDocument;
import sunw.hotjava.bean.DocumentSelection;
import sunw.hotjava.doc.BeanDocumentPanel;
import sunw.hotjava.doc.DocException;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.DocParser;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.ElementInfo;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.RequestProcessor;

public class HotJavaBrowserBean
extends BeanDocumentPanel
implements Externalizable,
ComponentListener,
BrowserHistoryListener,
Observer,
Serializable {
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected VetoableChangeSupport vetoChangeSupport = new VetoableChangeSupport(this);
    private String statusMessage;
    private String documentTitle;
    private String errorMessage;
    private CurrentDocument curDoc = new CurrentDocument();
    private Reader htmlReader;
    private boolean isSecure = false;
    private DocumentSelection docSel;
    private int countConn;
    private double percentRec;
    private long totalBytes;
    private long totalRec;
    private String[] frameList;
    private String propertyNotSet;
    private CurrentDocument serializedDoc;
    private static final int externalizedVersion = 1;
    private transient boolean cloneNecessary = true;
    private transient Vector targets;
    private transient Vector listeners;
    private boolean nextAvailable = false;
    private boolean previousAvailable = false;
    private boolean fireDocumentPropertyChange = true;

    public HotJavaBrowserBean() {
        try {
            Globals.initSystem(true);
        }
        catch (Exception exception) {
            System.out.println("Unable to initialize bean:  " + exception);
            exception.printStackTrace();
        }
        this.propertyNotSet = Globals.localProps.handleGetString("HotJavaBrowserBean.property.not.set");
        this.addComponentListener(this);
        RequestProcessor.startProcessing();
    }

    protected HotJavaBrowserBean(HotJavaBrowserBean hotJavaBrowserBean) {
        super(hotJavaBrowserBean);
    }

    public Object clone() {
        return new HotJavaBrowserBean(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setDocumentString(String string) {
        if (string.equals(this.curDoc.documentString)) {
            return;
        }
        string = Globals.canonicalize(string);
        try {
            CurrentDocument currentDocument = new CurrentDocument();
            currentDocument.documentURL = this.curDoc.documentURL == null || !this.curDoc.documentURL.toString().equals(string) ? new URL(string) : this.curDoc.documentURL;
            currentDocument.documentString = string;
            currentDocument.frameName = "_self";
            currentDocument.externalHint = false;
            CurrentDocument currentDocument2 = this.curDoc;
            this.setCurrentDocument(currentDocument);
            if (!this.curDoc.documentString.equals(currentDocument2.documentString)) {
                this.changeSupport.firePropertyChange("documentString", currentDocument2.documentString, this.curDoc.documentString);
            }
            if (!this.curDoc.documentURL.equals(currentDocument2.documentURL)) {
                this.changeSupport.firePropertyChange("documentURL", currentDocument2.documentURL, this.curDoc.documentURL);
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage("Malformed URL");
        }
    }

    public String getDocumentString() {
        String string = this.curDoc.documentString;
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setDocumentURL(URL uRL) {
        if (uRL == null) {
            this.setDocumentString("");
            return;
        }
        if (this.curDoc != null && this.curDoc.documentString != null && uRL.toString().equals(this.curDoc.documentString)) {
            return;
        }
        CurrentDocument currentDocument = new CurrentDocument();
        currentDocument.documentString = this.curDoc.documentString == null || !this.curDoc.documentString.equals(uRL.toString()) ? uRL.toString() : this.curDoc.documentString;
        currentDocument.documentURL = uRL;
        currentDocument.frameName = "_self";
        currentDocument.externalHint = false;
        CurrentDocument currentDocument2 = this.curDoc;
        this.setCurrentDocument(currentDocument);
        if (!this.curDoc.documentString.equals(currentDocument2.documentString)) {
            this.changeSupport.firePropertyChange("documentString", currentDocument2.documentString, this.curDoc.documentString);
        }
        if (!this.curDoc.documentURL.equals(currentDocument2.documentURL)) {
            this.changeSupport.firePropertyChange("documentURL", currentDocument2.documentURL, this.curDoc.documentURL);
        }
    }

    protected boolean isSetCurrentDocumentAllowed(URL uRL, String string, boolean bl) {
        boolean bl2 = true;
        if (uRL == null) {
            return this.htmlReader != null;
        }
        if (uRL != null && this.curDoc != null && this.curDoc.documentString != null && uRL.toString().equals(this.curDoc.documentString)) {
            return true;
        }
        if (string == null && bl) {
            string = "_top";
        }
        CurrentDocument currentDocument = new CurrentDocument();
        currentDocument.documentURL = uRL;
        currentDocument.documentString = uRL.toString();
        currentDocument.frameName = string;
        currentDocument.externalHint = bl;
        try {
            this.vetoChangeSupport.fireVetoableChange("currentDocument", this.curDoc, currentDocument);
            CurrentDocument currentDocument2 = this.curDoc;
            this.curDoc = currentDocument;
            boolean bl3 = currentDocument.documentString.startsWith("https");
            String string2 = null;
            if (this.curDoc.documentURL != null) {
                string2 = this.curDoc.documentURL.toString();
            }
            if (string2 == null || !string2.equals(this.curDoc.documentString)) {
                this.curDoc.documentString = string2;
            }
            this.changeSupport.firePropertyChange("currentDocument", currentDocument2, this.curDoc);
            if (this.fireDocumentPropertyChange) {
                if (!this.curDoc.documentString.equals(currentDocument2.documentString)) {
                    this.changeSupport.firePropertyChange("documentString", currentDocument2.documentString, this.curDoc.documentString);
                }
                if (!this.curDoc.documentURL.equals(currentDocument2.documentURL)) {
                    this.changeSupport.firePropertyChange("documentURL", currentDocument2.documentURL, this.curDoc.documentURL);
                }
            }
            if (bl3 != this.isSecure) {
                this.isSecure = bl3;
                this.changeSupport.firePropertyChange("secureConnection", new Boolean(!this.isSecure), new Boolean(this.isSecure));
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            bl2 = false;
        }
        return bl2;
    }

    public void setCurrentDocument(CurrentDocument currentDocument) {
        if (currentDocument.documentURL != null) {
            this.push(this, currentDocument.frameName, currentDocument.documentURL, null);
        }
    }

    public CurrentDocument getCurrentDocument() {
        return this.curDoc;
    }

    public void push(DocumentPanel documentPanel, Document document) {
        if (documentPanel == null) {
            System.out.println("DocumentPanel is null");
        }
        if (this.docPanelStack == null) {
            System.out.println("docStack is null");
        }
        super.push(documentPanel, document);
        this.notifyHistoryChanges();
    }

    protected void notifyHistoryChanges() {
        if (this.nextAvailable != this.canForward()) {
            this.nextAvailable = !this.nextAvailable;
            this.dispatchBrowserHistoryEvent(3, new Boolean(this.nextAvailable));
        }
        if (this.previousAvailable != this.canBack()) {
            this.previousAvailable = !this.previousAvailable;
            this.dispatchBrowserHistoryEvent(4, new Boolean(this.previousAvailable));
        }
    }

    public URL getDocumentURL() {
        return this.curDoc.documentURL;
    }

    public Reader getDocumentSource() {
        InputStream inputStream;
        if (this.htmlReader != null) {
            return this.htmlReader;
        }
        if (this.curDoc == null || this.curDoc.documentURL == null) {
            return null;
        }
        try {
            URLConnection uRLConnection = this.curDoc.documentURL.openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            this.setErrorMessage("IOException generated when attempting to getInputStream()");
            return null;
        }
        String string = Globals.localProps.handleGetString("hotjava.charset");
        try {
            return new InputStreamReader(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.setErrorMessage("Conversion " + string + " not found.");
            return null;
        }
    }

    public void setDocumentSource(Reader reader) {
        Reader reader2 = this.htmlReader;
        this.htmlReader = reader;
        try {
            if (this.getDocFont() != null) {
                Document document = new Document();
                new DocParser(document, this.htmlReader);
                this.push((DocumentPanel)this, document);
                this.changeSupport.firePropertyChange("documentSource", reader2, reader);
                return;
            }
        }
        catch (DocException docException) {}
    }

    protected void setDocumentTitle(String string) {
        this.changeSupport.firePropertyChange("documentTitle", this.documentTitle, string);
        this.documentTitle = string;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    protected void setErrorMessage(String string) {
        this.changeSupport.firePropertyChange("errorMessage", this.errorMessage, string);
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected void setIndicatedElement(ElementInfo elementInfo) {
        ElementInfo elementInfo2 = this.getIndicatedElement();
        super.setIndicatedElement(elementInfo);
        this.changeSupport.firePropertyChange("indicatedElement", elementInfo2, elementInfo);
    }

    public ElementInfo getIndicatedElement() {
        return super.getIndicatedElement();
    }

    protected void setStatusMessage(String string) {
        this.changeSupport.firePropertyChange("statusMessage", this.statusMessage, string);
        this.statusMessage = string;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean isSecureConnection() {
        return this.isSecure;
    }

    public String[] getFrameList() {
        return this.frameList;
    }

    protected void setFrameList(String[] stringArray) {
        String[] stringArray2 = this.frameList;
        this.frameList = stringArray;
        this.changeSupport.firePropertyChange("frameList", stringArray2, stringArray);
    }

    public String getFrameList(int n) {
        if (n > 0 && n < this.frameList.length) {
            return this.frameList[n];
        }
        return null;
    }

    protected void setFrameList(int n, String string) {
        if (n > 0 && n < this.frameList.length) {
            String string2 = this.frameList[n];
            this.frameList[n] = string;
            this.changeSupport.firePropertyChange("frameList", string2, string);
            return;
        }
        if (n < 0) {
            boolean bl = false;
            if (this.frameList == null) {
                String[] stringArray = new String[]{string};
                this.setFrameList(stringArray);
                return;
            }
            int n2 = 0;
            while (n2 < this.frameList.length) {
                if (this.frameList[n2] == null) {
                    this.setFrameList(n2, string);
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                String[] stringArray = new String[this.frameList.length + 1];
                System.arraycopy(this.frameList, 0, stringArray, 0, this.frameList.length);
                int n3 = this.frameList.length;
                stringArray[n3] = string;
                this.setFrameList(stringArray);
            }
        }
    }

    public DocumentSelection getSelection() {
        return this.docSel;
    }

    public String getCharset() {
        Document document = this.getDocument();
        String string = null;
        if (document != null) {
            string = (String)document.getProperty("charset");
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setCharset(String string) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                document.setProperty("charset", string);
                Globals.setCharset(string);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public double getLoadingProgress() {
        return this.percentRec;
    }

    public boolean isDocumentReloadable() {
        return super.canReload();
    }

    public void showDocument(Document document, boolean bl) {
        boolean bl2 = this.canReload();
        super.showDocument(document, bl);
        if (this.canReload() != bl2) {
            this.changeSupport.firePropertyChange("documentReloadable", new Boolean(bl2), new Boolean(!bl2));
        }
    }

    public void reload() {
        super.reload();
    }

    public void stopLoading() {
        super.stopLoading();
    }

    public void stop() {
        this.getFormatter().stop();
    }

    public void start() {
        this.getFormatter().start();
    }

    public void clearImageCache() {
        Globals.flushImages();
    }

    public int find(int n, String string) {
        DocumentFormatter documentFormatter = this.getFormatter();
        if (documentFormatter != null) {
            documentFormatter.showSelection(false);
            documentFormatter.select(n, n);
            if (super.find(string, true, false)) {
                int n2 = documentFormatter.getSelectEnd();
                return n2;
            }
        }
        return -1;
    }

    public void print(PrintJob printJob) {
        try {
            super.print(printJob, this);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private DocFont setDocFont() {
        DocFont docFont = DocFont.findFont(false, 0, 5 + Integer.getInteger("hotjava.docfontsize", 0));
        this.setDocFont(docFont);
        return docFont;
    }

    public void addNotify() {
        super.addNotify();
        ProgressData.pdata.addObserver(this);
        Frame frame = this.getContainingFrame();
        if (frame != null) {
            Adjustable adjustable;
            Globals.registerFrame(frame);
            DocFont docFont = this.setDocFont();
            int n = Globals.getFontMetrics(docFont).getAscent();
            Adjustable adjustable2 = this.getHAdjustable();
            if (adjustable2 != null) {
                adjustable2.setUnitIncrement(n);
            }
            if ((adjustable = this.getVAdjustable()) != null) {
                adjustable.setUnitIncrement(n);
            }
            this.parentFrm = frame;
            if (this.serializedDoc != null) {
                this.setCurrentDocument(this.serializedDoc);
                return;
            }
            if (this.htmlReader != null) {
                Document document = new Document();
                try {
                    new DocParser(document, this.htmlReader);
                    this.push((DocumentPanel)this, document);
                    this.changeSupport.firePropertyChange("documentSource", null, this.htmlReader);
                    return;
                }
                catch (DocException docException) {
                    return;
                }
            }
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        this.vetoChangeSupport.fireVetoableChange(string, object2, object);
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        switch (documentEvent.getID()) {
            case 1029: {
                this.setFrameList(-1, (String)documentEvent.getArgument());
                return;
            }
            case 1030: {
                if (this.frameList == null) break;
                int n = 0;
                while (n < this.frameList.length) {
                    if (this.frameList[n] != null && this.frameList[n].equals((String)documentEvent.getArgument())) {
                        this.setFrameList(n, null);
                        return;
                    }
                    ++n;
                }
                return;
            }
            case 1007: {
                DocumentSelection documentSelection = new DocumentSelection();
                DocumentFormatter documentFormatter = (DocumentFormatter)documentEvent.getSource();
                documentSelection.text = documentFormatter.getSelectedText();
                documentSelection.html = documentFormatter.getSelectedSource();
                this.changeSupport.firePropertyChange("selection", this.docSel, documentSelection);
                this.docSel = documentSelection;
                return;
            }
            case 1004: {
                String[] stringArray = new String[]{"background.img", "background.color", "text.color", "link.color", "vlink.color", "alink.color", "title", "charset"};
                String[] stringArray2 = new String[]{"backgroundImage", "backgroundColor", "textColor", "linkColor", "visitedLinkColor", "clickLinkColor", "documentTitle", "charset"};
                String string = (String)documentEvent.getArgument();
                Document document = this.getDocument();
                if (string.equals("url")) {
                    URL uRL;
                    this.curDoc.documentURL = uRL = document.getURL();
                    this.curDoc.documentString = uRL.toString();
                    this.gotoLabel(uRL.getRef());
                    return;
                }
                if (string.equals("refresh")) {
                    this.requestTimedRefresh(document);
                    return;
                }
                int n = 0;
                if (n < stringArray.length) {
                    if (!string.equals(stringArray[n])) break;
                    this.changeSupport.firePropertyChange(stringArray2[n], null, document.getProperty(string));
                    return;
                }
                return;
            }
            case 1006: {
                URL uRL;
                Document document = (Document)documentEvent.getArgument();
                String string = (String)document.getProperty("charset");
                if (string != null) {
                    Globals.setCharset(string);
                }
                this.fireDocumentPropertyChange = documentEvent.getSource() == this;
                if (document == null || !this.isSetCurrentDocumentAllowed(uRL = document.getURL(), null, false)) break;
                this.notifyHistoryChanges();
                return;
            }
            default: {
                super.processDocumentEvent(documentEvent);
            }
            case 1032: 
        }
    }

    public void removeNotify() {
        ProgressData.pdata.deleteObserver(this);
        super.removeNotify();
    }

    public synchronized void update(Observable observable, Object object) {
        if (!this.isVisible()) {
            return;
        }
        ProgressEntry progressEntry = (ProgressEntry)object;
        try {
            double d = this.percentRec;
            switch (progressEntry.what) {
                case 0: {
                    if (this.countConn == 0) {
                        this.percentRec = 0.0;
                        this.totalBytes = 0L;
                        this.totalRec = 0L;
                    }
                    ++this.countConn;
                    break;
                }
                case 1: {
                    this.totalBytes += (long)progressEntry.need;
                    this.totalRec += (long)progressEntry.read;
                }
                case 2: {
                    this.percentRec = (double)this.totalBytes / (double)this.totalRec;
                    break;
                }
                case 3: {
                    --this.countConn;
                    if (this.countConn > 0) break;
                    this.countConn = 0;
                    this.percentRec = 1.0;
                    break;
                }
            }
            this.changeSupport.firePropertyChange("loadingProgress", new Double(d), new Double(this.percentRec));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void executeHistoryCommand(BrowserHistoryEvent browserHistoryEvent) {
        switch (browserHistoryEvent.getCommand()) {
            case 0: {
                this.clear();
                return;
            }
            case 1: {
                URL uRL;
                this.forward();
                Document document = this.getDocument();
                if (document == null) break;
                this.curDoc.documentURL = uRL = document.getURL();
                this.curDoc.documentString = uRL.toString();
                return;
            }
            case 2: {
                URL uRL;
                this.back();
                Document document = this.getDocument();
                if (document == null) break;
                this.curDoc.documentURL = uRL = document.getURL();
                this.curDoc.documentString = uRL.toString();
                return;
            }
        }
    }

    public synchronized void addBrowserHistoryListener(BrowserHistoryListener browserHistoryListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.cloneNecessary = true;
        this.listeners.addElement(browserHistoryListener);
    }

    public synchronized void removeBrowserHistoryListener(BrowserHistoryListener browserHistoryListener) {
        if (this.listeners == null) {
            return;
        }
        this.cloneNecessary = true;
        this.listeners.removeElement(browserHistoryListener);
    }

    protected void dispatchBrowserHistoryEvent(int n, Object object) {
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                Object var4_4 = null;
                return;
            }
            if (this.cloneNecessary) {
                this.targets = (Vector)this.listeners.clone();
                this.cloneNecessary = false;
            }
        }
        serializable = new BrowserHistoryEvent(this, n, object);
        int n2 = 0;
        while (n2 < this.targets.size()) {
            BrowserHistoryListener browserHistoryListener = (BrowserHistoryListener)this.targets.elementAt(n2);
            browserHistoryListener.executeHistoryCommand((BrowserHistoryEvent)serializable);
            ++n2;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.curDoc);
        Rectangle rectangle = this.getBounds();
        objectOutput.writeInt(rectangle.x);
        objectOutput.writeInt(rectangle.y);
        objectOutput.writeInt(rectangle.width);
        objectOutput.writeInt(rectangle.height);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == 1) {
            this.serializedDoc = (CurrentDocument)objectInput.readObject();
            int n2 = objectInput.readInt();
            int n3 = objectInput.readInt();
            int n4 = objectInput.readInt();
            int n5 = objectInput.readInt();
            this.setBounds(n2, n3, n4, n5);
            return;
        }
        throw new IOException("Unrecognized " + this.getClass().getName() + " version:  " + n);
    }
}

