/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.FontMetrics;
import java.awt.Graphics;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.TagItem;

public class BlockTagItem
extends TagItem {
    public boolean isBlock() {
        return true;
    }

    public String getText() {
        return "\n";
    }

    public boolean isPreformatted() {
        return this.isType("verbatim");
    }

    public int startOffset(Document document, int n) {
        if (this.isEnd()) {
            return -1;
        }
        if (this.index > 0 && document.items[this.index - 1].isBlock() && document.items[this.index - 1].isStart()) {
            return -1;
        }
        return 0;
    }

    protected boolean leaveSpace(Formatter formatter, FormatState formatState) {
        return this.offset != 1;
    }

    protected boolean beginState(Formatter formatter, FormatState formatState) {
        return formatState.state == 0;
    }

    public boolean formatStartTag(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (!this.beginState(formatter, formatState)) {
            return true;
        }
        formatState.style = formatState.style.push(this);
        formatState.maxWidth -= this.style.left + this.style.right;
        formatState.margin += (this.style.left << 16) + this.style.right;
        if (formatter.ds.tags) {
            formatState.ascent = Math.max(formatState.ascent, Math.max(this.style.above, 20));
            formatState.format = 0;
            formatState.pos += 65536;
            return true;
        }
        if (this.leaveSpace(formatter, formatState)) {
            formatState.above = Math.max(formatState.above, this.style.above);
            formatState.ascent = formatState.style.ascent;
            formatState.descent = formatState.style.descent;
        }
        formatState.format = formatState.style.format;
        formatState.pos += 65536;
        return false;
    }

    public boolean formatEndTag(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (formatter.ds.tags) {
            if (formatState.state != 0) {
                return true;
            }
            formatState.ascent = Math.max(formatState.ascent, 20);
            formatState.style = formatState.style.next;
            formatState.format = 0;
            formatState.pos += 65536;
            return true;
        }
        formatState.state = 2;
        if (this.offset != 1) {
            formatState.below = Math.max(formatState.below, this.style.below);
        }
        formatState.style = formatState.style.next;
        formatState.pos += 65536;
        return false;
    }

    public void modifyStyle(DocStyle docStyle) {
        this.style.apply(docStyle);
        FontMetrics fontMetrics = docStyle.getFontMetrics();
        docStyle.ascent = fontMetrics.getAscent();
        docStyle.descent = fontMetrics.getDescent();
        docStyle.left += this.style.left;
        docStyle.right += this.style.right;
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        if (formatter.ds.tags) {
            this.paintTag(graphics, TagItem.startBlockTagImg, n, n2 + docLine.height - 19, this.style.label, 17, 11, formatter);
        }
        formatter.displayPos += 65536;
        return 0;
    }

    public int paintEndTag(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        if (formatter.ds.tags) {
            this.paintTag(graphics, TagItem.endBlockTagImg, n, n2, this.style.label, 17, 15, formatter);
        }
        formatter.displayPos += 65536;
        return 0;
    }

    public int findStartTagX(DocLine docLine, DocStyle docStyle, int n, int n2, int n3, Formatter formatter) {
        if (docStyle.win.ds.tags && n3 - n >= 24) {
            return (n2 & 0x7FFF0000) + 65536;
        }
        return -1;
    }

    public int findEndTagX(DocLine docLine, DocStyle docStyle, int n, int n2, int n3, Formatter formatter) {
        return this.findStartTagX(docLine, docStyle, n, n2, n3, formatter);
    }

    public int getStartTagWidth(DocLine docLine, DocStyle docStyle, int n, int n2, int n3) {
        if (docStyle.win.ds.tags && n2 == 0 && n3 > 0) {
            return 24;
        }
        return 0;
    }

    public int getEndTagWidth(DocLine docLine, DocStyle docStyle, int n, int n2, int n3) {
        return this.getStartTagWidth(docLine, docStyle, n, n2, n3);
    }

    public boolean measureStartTag(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        measureState.style = measureState.style.push(this);
        measureState.pos += 65536;
        return true;
    }

    public boolean measureEndTag(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        measureState.style = measureState.style.next;
        measureState.pos += 65536;
        return false;
    }
}

