/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.awt.ScreenUpdater;
import sun.awt.UpdateClient;
import sunw.hotjava.misc.Globals;

public class DocumentBackground
implements ImageObserver,
UpdateClient {
    private Color col;
    private URL url;
    private Image tile;
    private Vector clients;
    private static Hashtable hash;
    private static final int MIN_WIDTH = 200;
    private static final int MIN_HEIGHT = 100;

    private DocumentBackground(URL uRL, Color color) {
        this.url = uRL;
        this.col = color;
    }

    public synchronized void addClient(Component component) {
        if (this.clients == null) {
            this.clients = new Vector();
        }
        if (this.clients.indexOf(component) < 0) {
            this.clients.addElement(component);
        }
    }

    public synchronized void removeClient(Component component) {
        if (this.clients != null) {
            this.clients.removeElement(component);
            if (this.clients.size() == 0) {
                this.clients = null;
            }
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.tile == null && (n & 3) != 0) {
            this.makeTile(image);
        }
        if ((n & 0x20) != 0) {
            ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)image);
        }
        return (n & 0xA0) == 0;
    }

    public void updateClient(Object object) {
        this.fillTile((Image)object);
    }

    private synchronized void makeTile(Image image) {
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        if (n <= 0 || n2 <= 0) {
            return;
        }
        int n3 = n < 200 ? n * (200 / n + 1) : n;
        int n4 = n2 < 100 ? n2 * (100 / n2 + 1) : n2;
        this.tile = Globals.createImage(n3, n4);
        this.fillTile(image);
    }

    private synchronized void fillTile(Image image) {
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        if (n <= 0 || n2 <= 0 || this.tile == null) {
            return;
        }
        Graphics graphics = this.tile.getGraphics();
        try {
            int n3 = this.tile.getWidth(null);
            int n4 = this.tile.getHeight(null);
            graphics.setColor(this.col);
            graphics.fillRect(0, 0, n3, n4);
            int n5 = 0;
            while (n5 < n3) {
                int n6 = 0;
                while (n6 < n3) {
                    graphics.drawImage(image, n6, n5, this);
                    n6 += n;
                }
                n5 += n2;
            }
        }
        finally {
            Object var6_9 = null;
            graphics.dispose();
        }
        if (this.clients != null) {
            Enumeration enumeration = this.clients.elements();
            while (enumeration.hasMoreElements()) {
                ((Component)enumeration.nextElement()).repaint();
            }
        }
    }

    public synchronized void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (!Boolean.getBoolean("displayBackgroundImages")) {
            graphics.setColor(this.col);
            graphics.fillRect(n3, n4, n5, n6);
            return;
        }
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = graphics.getClipRect();
        if (rectangle != null) {
            graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        try {
            if (this.tile == null) {
                graphics.setColor(this.col);
                graphics.fillRect(n3, n4, n5, n6);
                this.makeTile(Globals.getImage(this.url));
                Object var11_10 = null;
                graphics2.dispose();
                return;
            }
            int n7 = this.tile.getWidth(null);
            int n8 = this.tile.getHeight(null);
            graphics2.clipRect(n3, n4, n5, n6);
            int n9 = n4 - (n4 - n2) % n8;
            while (n9 < n4 + n6) {
                int n10 = n3 - (n3 - n) % n7;
                while (n10 < n3 + n5) {
                    graphics2.drawImage(this.tile, n10, n9, n7, n8, null);
                    n10 += n7;
                }
                n9 += n8;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            graphics2.dispose();
            throw throwable;
        }
        Object var11_11 = null;
        graphics2.dispose();
    }

    public int hashCode() {
        return this.url.hashCode() ^ this.col.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DocumentBackground) {
            DocumentBackground documentBackground = (DocumentBackground)object;
            return this.url.equals(documentBackground.url) && this.col.equals(this.col);
        }
        return false;
    }

    public static synchronized DocumentBackground getDocumentBackground(URL uRL, Color color) {
        DocumentBackground documentBackground;
        DocumentBackground documentBackground2 = new DocumentBackground(uRL, color);
        DocumentBackground documentBackground3 = documentBackground = hash != null ? (DocumentBackground)hash.get(documentBackground2) : null;
        if (documentBackground != null) {
            return documentBackground;
        }
        if (hash == null) {
            hash = new Hashtable();
        }
        hash.put(documentBackground2, documentBackground2);
        return documentBackground2;
    }

    public static synchronized void flushCache() {
        hash = null;
    }
}

