/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Container;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.PreservedState;

class DocumentFormatterRef {
    private DocumentFormatter formatter;
    private PreservedState preservedState;
    private int refCount;

    DocumentFormatterRef(Container container, Document document, DocFont docFont) {
        this.formatter = new DocumentFormatter(container, document, docFont);
    }

    DocumentFormatter getFormatter() {
        if (this.formatter == null) {
            this.reconstitute();
        }
        return this.formatter;
    }

    DocumentFormatter getFormatterIfNotRemoved() {
        return this.formatter;
    }

    Document getDocument() {
        DocumentFormatter documentFormatter = this.getFormatter();
        return documentFormatter.getDocument();
    }

    boolean isDocument(Document document) {
        return this.formatter != null && this.formatter.getDocument() == document;
    }

    void setDocFont(DocFont docFont) {
        if (this.formatter != null) {
            this.formatter.setDocFont(docFont);
            return;
        }
        this.preservedState.setDocFont(docFont);
    }

    void addClient() {
        ++this.refCount;
    }

    void removeClient() {
        if (this.refCount > 0) {
            --this.refCount;
            if (this.refCount == 0) {
                this.flush();
            }
        }
    }

    private void flush() {
        this.preservedState = new PreservedState(this.formatter);
        this.formatter.stop();
        this.formatter.destroy();
        this.formatter = null;
    }

    private void reconstitute() {
        this.formatter = this.preservedState.reconstituteFormatter();
        this.preservedState = null;
    }
}

