/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import sun.misc.VM;
import sunw.hotjava.applet.AppletEvent;
import sunw.hotjava.applet.AppletListener;
import sunw.hotjava.doc.DocBusyException;
import sunw.hotjava.doc.DocConstants;
import sunw.hotjava.doc.DocException;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentEventMulticaster;
import sunw.hotjava.doc.DocumentEventSource;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentFormatterPanel;
import sunw.hotjava.doc.DocumentFormatterPresentation;
import sunw.hotjava.doc.DocumentFormatterRef;
import sunw.hotjava.doc.DocumentListener;
import sunw.hotjava.doc.MasterDocumentPanel;
import sunw.hotjava.doc.NamedLink;
import sunw.hotjava.doc.Range;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.Hax;
import sunw.hotjava.tags.FramePanel;
import sunw.hotjava.tags.FrameSetPanel;
import sunw.hotjava.tags.TagAppletPanel;

public class DocumentPanel
extends ScrollPane
implements DocPanel,
DocConstants,
DocumentEventSource {
    private static final int MaxWindowSize = Short.MAX_VALUE;
    String name;
    DocumentFormatterPanel panel;
    int index = -1;
    DocumentEventMulticaster listeners = new DocumentEventMulticaster();
    DocumentFormatter current;
    private Vector docStack = new Vector();
    DocFont font;
    int marginWidth = 20;
    int marginHeight = 10;
    private int oldWidth = -1;
    private int oldHeight = -1;
    private int oldHorizontalInset = -1;
    static Vector panels = new Vector();
    int appletLoadingCount;
    DocListener docListener = new DocListener();

    public DocumentPanel(DocFont docFont) {
        this(docFont, 0);
        this.setSize(5, 5);
    }

    public DocumentPanel() {
        super(0);
        this.panel = new DocumentFormatterPanel();
        this.add(this.panel);
        this.panel.setDocumentPanel(this);
        this.setBackground(Globals.getColor("html.background", null));
        panels.addElement(this);
    }

    public DocumentPanel(DocFont docFont, int n) {
        super(n);
        Adjustable adjustable;
        this.setSize(5, 5);
        this.font = docFont;
        this.panel = new DocumentFormatterPanel();
        this.add(this.panel);
        this.panel.setDocumentPanel(this);
        this.setBackground(Globals.getColor("hotjava.background", null));
        panels.addElement(this);
        int n2 = Globals.getFontMetrics(docFont).getAscent();
        Adjustable adjustable2 = this.getHAdjustable();
        if (adjustable2 != null) {
            adjustable2.setUnitIncrement(n2);
        }
        if ((adjustable = this.getVAdjustable()) != null) {
            adjustable.setUnitIncrement(n2);
        }
        1 var6_6 = new 1();
        this.addKeyListener(var6_6);
        this.addDocumentListener(this.docListener);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listeners.add(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listeners.remove(documentListener);
    }

    public void dispatchDocumentEvent(int n, Object object) {
        DocumentEvent documentEvent = new DocumentEvent(this, n, object);
        this.listeners.documentChanged(documentEvent);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = string;
        if (string != null) {
            string = string.toLowerCase();
        }
        this.name = string;
        if (string2 != null) {
            this.dispatchDocumentEvent(1030, string2);
        }
        this.dispatchDocumentEvent(1029, string);
    }

    public Document getDocument() {
        if (this.current != null) {
            return this.current.getDocument();
        }
        return null;
    }

    public void gotoLabel(String string) {
        if (this.current != null) {
            this.current.gotoLabel(string);
        }
    }

    public DocFont getDocFont() {
        return this.font;
    }

    public void setDocFont(DocFont docFont) {
        if (this.font != docFont) {
            this.font = docFont;
            Enumeration enumeration = this.docStack.elements();
            while (enumeration.hasMoreElements()) {
                DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)enumeration.nextElement();
                documentFormatterPresentation.setDocFont(docFont);
            }
        }
    }

    public static void setAllDocFonts(DocFont docFont) {
        Enumeration enumeration = panels.elements();
        while (enumeration.hasMoreElements()) {
            ((DocumentPanel)enumeration.nextElement()).setDocFont(docFont);
        }
    }

    public void setMargins(int n, int n2) {
        if (this.marginWidth != n || this.marginHeight != n2) {
            this.marginWidth = n;
            this.marginHeight = n2;
            if (this.current != null) {
                this.current.setMargins(n, n2);
            }
        }
    }

    public void reloadDocument() {
        Document document = this.getDocument();
        if (document != null && document.getURL() != null) {
            this.tryToEnableAppletReload();
            try {
                this.current.top();
                document.reload();
                return;
            }
            catch (DocException docException) {
                docException.printStackTrace();
                return;
            }
        }
    }

    protected void tryToEnableAppletReload() {
    }

    public boolean hasFrameSetPanel(DocumentFormatter documentFormatter) {
        return documentFormatter.hasFrameSetPanel();
    }

    public void reload() {
        DocumentFormatter documentFormatter;
        Object object;
        Vector vector = this.docStack;
        synchronized (vector) {
            if (this.docStack.size() == 0) {
                Object var3_3 = null;
                return;
            }
            object = (DocumentFormatterPresentation)this.docStack.elementAt(this.index);
            documentFormatter = ((DocumentFormatterPresentation)object).getFormatterRef().getFormatter();
        }
        if (this.hasFrameSetPanel(documentFormatter)) {
            int n = documentFormatter.countPanels();
            int n2 = 0;
            while (n2 < n) {
                object = documentFormatter.getPanel(n2);
                if (object instanceof FrameSetPanel) {
                    ((FrameSetPanel)object).reload();
                }
                ++n2;
            }
            return;
        }
        this.reloadDocument();
    }

    public boolean showingTags() {
        return this.current.showingTags();
    }

    public void setShowingTags(boolean bl) {
        Vector vector = this.docStack;
        synchronized (vector) {
            DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(this.index);
            DocumentFormatter documentFormatter = documentFormatterPresentation.getFormatterRef().getFormatter();
            documentFormatter.setShowingTags(bl);
            documentFormatter.reformat();
            return;
        }
    }

    public void activateItemComponents() {
        if (this.current != null) {
            this.current.activateItemComponents();
        }
    }

    public void activateSubItems() {
        if (this.current != null) {
            this.current.activateSubItems();
        }
    }

    public void start() {
        if (this.current != null) {
            this.current.initializeParent();
            this.current.start();
        }
    }

    public void stop() {
        if (this.current != null) {
            this.current.stop();
        }
    }

    public void interruptLoading() {
        if (this.current != null) {
            this.current.interruptLoading();
        }
    }

    public void setDocStackSize(int n) {
        int n2 = this.docStack.size();
        while (n2-- > n) {
            DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(n2);
            this.docStack.setSize(n2);
            documentFormatterPresentation.flush();
        }
    }

    public void destroy() {
        String string = this.getName();
        this.dispatchDocumentEvent(1030, string);
        Vector vector = this.docStack;
        synchronized (vector) {
            this.setDocStackSize(0);
            this.index = -1;
        }
        this.setFormatter(null);
        if (this.docListener != null) {
            this.removeDocumentListener(this.docListener);
            this.docListener = null;
        }
        panels.removeElement(this);
    }

    public void notify(Document document, int n, int n2, int n3) {
    }

    public void reformat() {
    }

    public int findYFor(int n) {
        return 0;
    }

    public void print(PrintJob printJob, MasterDocumentPanel masterDocumentPanel) throws DocBusyException {
        Vector vector = this.docStack;
        synchronized (vector) {
            DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(this.index);
            DocumentFormatter documentFormatter = documentFormatterPresentation.getFormatterRef().getFormatter();
            if (documentFormatter.hasFrameSetPanel()) {
                int n = documentFormatter.countPanels();
                int n2 = 0;
                while (n2 < n) {
                    Component component = documentFormatter.getPanel(n2);
                    if (component instanceof FrameSetPanel) {
                        ((FrameSetPanel)component).print(printJob, masterDocumentPanel);
                    }
                    ++n2;
                }
            } else {
                int n = Integer.getInteger("hotjava.printfontsize", 0);
                DocFont docFont = DocFont.findFont(true, 0, 5 + n);
                new DocumentFormatter(this.current, docFont).print(printJob, masterDocumentPanel);
            }
            return;
        }
    }

    public boolean find(String string) {
        return this.find(string, true);
    }

    public boolean find(String string, boolean bl) {
        return this.find(string, bl, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean find(String string, boolean bl, boolean bl2) {
        Document document = this.getDocument();
        Range range = null;
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document2 = document;
            synchronized (document2) {
                int n = this.current.ds.selEnd;
                if (n < 0) {
                    range = document.find(string, 0, bl);
                } else {
                    range = document.find(string, n, bl);
                    if (range == null) {
                        range = document.find(string, 0, bl);
                    }
                }
                if (range == null) {
                    return false;
                }
                try {
                    int n2 = this.current.findYFor(range.minVal);
                    int n3 = this.current.getDocumentY();
                    if (n2 < n3 || n2 > n3 + this.current.height) {
                        this.current.scrollTo(0, n2);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                this.current.showSelection(false);
                this.current.select(range.minVal, range.maxVal);
                this.current.showSelection(true);
                return true;
            }
        }
    }

    int getVerticalInset(boolean bl) {
        Insets insets = this.insets();
        int n = this.getHScrollbarHeight();
        int n2 = insets.top + insets.bottom;
        if (bl && n2 > n) {
            n2 -= n;
        }
        return n2;
    }

    int getHorizontalInset(boolean bl) {
        Insets insets = this.insets();
        int n = this.getVScrollbarWidth();
        int n2 = insets.left + insets.right;
        if (bl && n2 > n) {
            n2 -= n;
        }
        return n2;
    }

    private void setFormatterSize(Dimension dimension, DocumentFormatter documentFormatter) {
        int n = dimension.width;
        int n2 = dimension.height;
        if (documentFormatter.hasFrameSetPanel()) {
            int n3 = this.getHorizontalInset(true);
            int n4 = this.getVerticalInset(true);
            documentFormatter.setSize(n - n3, n2 - n4, 0);
            return;
        }
        int n5 = this.getHorizontalInset(false);
        int n6 = this.getVerticalInset(true);
        int n7 = n5 - this.getHorizontalInset(true);
        documentFormatter.setSize(n -= n5, n2 -= n6, n7);
    }

    void fitPanelToDocument() {
        Dimension dimension = this.getSize();
        int n = this.getVScrollbarWidth();
        int n2 = this.getHScrollbarHeight();
        Insets insets = this.getInsets();
        boolean bl = insets.left + insets.right >= n;
        boolean bl2 = insets.top + insets.bottom >= n2;
        int n3 = dimension.width - (insets.left + insets.right) - (bl ? 0 : n);
        int n4 = dimension.height - (insets.top + insets.bottom) - (bl2 ? 0 : n2);
        int n5 = this.panel.getSize().width;
        int n6 = this.panel.getSize().height;
        int n7 = this.current.docWidth;
        int n8 = this.current.docHeight;
        int n9 = n5;
        int n10 = n6;
        if (n7 <= n3) {
            n9 = n8 > n4 ? n3 : n3 + n;
        }
        if (n8 <= n4) {
            n10 = n7 > n3 ? n4 : n4 + n2;
        }
        if (n7 > n3) {
            n9 = n7;
        }
        if (n8 > n4) {
            n10 = n8;
        }
        if (n9 > Short.MAX_VALUE) {
            n9 = Short.MAX_VALUE;
        }
        if (n10 > Short.MAX_VALUE) {
            n10 = Short.MAX_VALUE;
        }
        if (n9 != n5 || n10 != n6) {
            Document document = this.getDocument();
            if (document != null) {
                Object object = Globals.getAwtLock();
                synchronized (object) {
                    Document document2 = document;
                    synchronized (document2) {
                        this.panel.setSize(n9, n10);
                        this.validate();
                    }
                    return;
                }
            }
            this.panel.setSize(n9, n10);
            this.validate();
        }
    }

    void dumpFPs(String string) {
        System.out.println(string);
        int n = 0;
        while (n < this.docStack.size()) {
            System.out.println(String.valueOf(this.index == n ? "  @ " : "    ") + n + ". " + this.docStack.elementAt(n));
            ++n;
        }
    }

    private void setFormatter(DocumentFormatter documentFormatter) {
        if (this.current != null) {
            this.dispatchDocumentEvent(1018, this.current);
            this.current.getDocument().removeDocumentListener(this.docListener);
            this.current.removeDocumentListener(this.docListener);
            this.current.removeListeners();
        }
        this.current = documentFormatter;
        if (documentFormatter == null) {
            return;
        }
        this.current.getDocument().addDocumentListener(this.docListener);
        this.current.addDocumentListener(this.docListener);
        this.current.addListeners();
        this.dispatchDocumentEvent(1017, this.current);
    }

    public DocumentFormatter getFormatter() {
        return this.current;
    }

    protected Frame getContainingFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private DocumentPanel getContainingDocumentPanel() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof DocumentPanel) {
                return (DocumentPanel)container;
            }
            container = container.getParent();
        }
        return null;
    }

    protected void addActionListenerOnPopup(PopupMenu popupMenu) {
        MasterDocumentPanel masterDocumentPanel = this.getContainingMasterDocumentPanel();
        ActionListener actionListener = masterDocumentPanel.getTopActionEventsListener();
        int n = popupMenu.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = popupMenu.getItem(n2);
            menuItem.addActionListener(actionListener);
            ++n2;
        }
    }

    protected MasterDocumentPanel getContainingMasterDocumentPanel() {
        return MasterDocumentPanel.getContainingMasterDocumentPanel(this);
    }

    private void show(int n) {
        DocumentFormatterPresentation documentFormatterPresentation;
        if (this.current != null) {
            this.recordScrollPosition();
            this.current.stop();
        }
        Hax.debugln("hotjava.debug.newpagedelimiter", "\n\n\n\n\n -- new document --");
        if (this.index > -1 && VM.getState() != 1) {
            try {
                documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(this.index);
                documentFormatterPresentation.flush();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        this.index = n;
        documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(this.index);
        this.setFormatter(documentFormatterPresentation.getFormatterRef().getFormatter());
        this.setFormatterSize(this.getSize(), this.current);
        this.setMargins(this.marginWidth, this.marginHeight);
        this.current.initializeParent();
        this.current.start();
        this.fitPanelToDocument();
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.restoreScrollPosition();
        this.dispatchDocumentEvent(1006, this.getDocument());
    }

    public void showDocument(Document document) {
        this.showDocument(document, false);
    }

    public void showDocument(Document document, boolean bl) {
        DocumentFormatterRef documentFormatterRef = this.getDocumentFormatterRef(document);
        if (documentFormatterRef == null) {
            documentFormatterRef = new DocumentFormatterRef(this.panel, document, this.font);
        }
        Vector vector = this.docStack;
        synchronized (vector) {
            if (bl) {
                DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(this.index);
                documentFormatterPresentation.flush();
                documentFormatterPresentation = new DocumentFormatterPresentation(documentFormatterRef);
                this.docStack.setElementAt(documentFormatterPresentation, this.index);
                this.show(this.index);
            } else {
                this.docStack.insertElementAt(new DocumentFormatterPresentation(documentFormatterRef), this.index + 1);
                this.show(this.index + 1);
                this.setDocStackSize(this.index + 1);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DocumentFormatterRef getDocumentFormatterRef(Document document) {
        Vector vector = this.docStack;
        synchronized (vector) {
            Document document2 = document;
            synchronized (document2) {
                int n = this.docStack.size();
                while (n-- > 0) {
                    DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(n);
                    if (!documentFormatterPresentation.isDocument(document)) continue;
                    return documentFormatterPresentation.getFormatterRef();
                }
                return null;
            }
        }
    }

    public void recordScrollPosition() {
        Vector vector = this.docStack;
        synchronized (vector) {
            DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(this.index);
            this.recordScrollPosition(documentFormatterPresentation);
            return;
        }
    }

    protected void recordScrollPosition(DocumentFormatterPresentation documentFormatterPresentation) {
        documentFormatterPresentation.setScrollPosition(this.getScrollPosition());
        this.setScrollPosition(0, 0);
        DocumentFormatter documentFormatter = documentFormatterPresentation.getFormatterRef().getFormatter();
        if (documentFormatter.hasFrameSetPanel()) {
            int n = documentFormatter.countPanels();
            int n2 = 0;
            while (n2 < n) {
                Component component = documentFormatter.getPanel(n2);
                if (component instanceof FrameSetPanel) {
                    ((FrameSetPanel)component).recordScrollPosition();
                }
                ++n2;
            }
        }
    }

    public void restoreScrollPosition() {
        Vector vector = this.docStack;
        synchronized (vector) {
            DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(this.index);
            this.restoreScrollPosition(documentFormatterPresentation);
            return;
        }
    }

    protected void restoreScrollPosition(DocumentFormatterPresentation documentFormatterPresentation) {
        DocumentFormatter documentFormatter = documentFormatterPresentation.getFormatterRef().getFormatter();
        Point point = documentFormatterPresentation.getScrollPosition();
        if (documentFormatter.hasFrameSetPanel()) {
            int n = documentFormatter.countPanels();
            int n2 = 0;
            while (n2 < n) {
                Component component = documentFormatter.getPanel(n2);
                if (component instanceof FrameSetPanel) {
                    ((FrameSetPanel)component).restoreScrollPosition();
                }
                ++n2;
            }
        }
        try {
            documentFormatter.scrollTo(point);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void updateDocStack() {
        DocumentFormatterRef documentFormatterRef = this.getDocumentFormatterRef(this.getDocument());
        if (documentFormatterRef == null) {
            return;
        }
        Vector vector = this.docStack;
        synchronized (vector) {
            this.recordScrollPosition();
            DocumentFormatterPresentation documentFormatterPresentation = new DocumentFormatterPresentation(documentFormatterRef);
            this.docStack.insertElementAt(documentFormatterPresentation, ++this.index);
            this.setDocStackSize(this.index + 1);
            return;
        }
    }

    void nextDocument() {
        Vector vector = this.docStack;
        synchronized (vector) {
            if (this.index + 1 < this.docStack.size()) {
                this.show(this.index + 1);
            }
            return;
        }
    }

    Document getNextDocument() {
        Vector vector = this.docStack;
        synchronized (vector) {
            Document document = this.index + 1 < this.docStack.size() ? ((DocumentFormatterPresentation)this.docStack.elementAt(this.index + 1)).getDocument() : null;
            Object var3_3 = null;
            return document;
        }
    }

    void previousDocument() {
        Vector vector = this.docStack;
        synchronized (vector) {
            if (this.index > 0) {
                this.show(this.index - 1);
            }
            return;
        }
    }

    Document getPreviousDocument() {
        Vector vector = this.docStack;
        synchronized (vector) {
            Document document = this.index > 0 ? ((DocumentFormatterPresentation)this.docStack.elementAt(this.index - 1)).getDocument() : null;
            Object var3_3 = null;
            return document;
        }
    }

    Document getRelativeDocument(int n) {
        Vector vector = this.docStack;
        synchronized (vector) {
            DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(this.docStack.size() + n - 1);
            Document document = documentFormatterPresentation.getDocument();
            Object var4_5 = null;
            return document;
        }
    }

    DocumentFormatter getRelativeFormatter(int n, boolean bl) {
        DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(this.docStack.size() + n - 1);
        if (bl) {
            return documentFormatterPresentation.getFormatterRef().getFormatter();
        }
        return documentFormatterPresentation.getFormatterRef().getFormatterIfNotRemoved();
    }

    void flushRelativeDocument(int n) {
        Vector vector = this.docStack;
        synchronized (vector) {
            DocumentFormatterPresentation documentFormatterPresentation = (DocumentFormatterPresentation)this.docStack.elementAt(this.docStack.size() + n - 1);
            documentFormatterPresentation.flush();
            return;
        }
    }

    public void doLayout() {
        super.doLayout();
        Dimension dimension = this.getSize();
        int n = this.getHorizontalInset(false);
        if (this.oldWidth != dimension.width || this.oldHeight != dimension.height || this.oldHorizontalInset != n) {
            this.oldWidth = dimension.width;
            this.oldHeight = dimension.height;
            this.oldHorizontalInset = n;
            if (this.current != null) {
                this.setFormatterSize(dimension, this.current);
                this.current.layout();
            }
        }
    }

    protected void requestTimedRefresh(Document document) {
        String string = (String)document.getProperty("refresh");
        if (string == null) {
            return;
        }
        this.dispatchDocumentEvent(1002, new NamedLink("_refresh " + string, document.getURL()));
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        switch (documentEvent.getID()) {
            case 1002: {
                DocumentPanel documentPanel;
                if (!(this.getParent() instanceof FramePanel) || (documentPanel = this.getContainingDocumentPanel()) == null) break;
                documentPanel.processDocumentEvent(documentEvent);
                return;
            }
            case 1019: {
                TagAppletPanel tagAppletPanel = (TagAppletPanel)documentEvent.getArgument();
                tagAppletPanel.addAppletListener(new AppletEventListener());
                return;
            }
            case 1004: {
                String string = (String)documentEvent.getArgument();
                if (!string.equals("refresh")) break;
                this.requestTimedRefresh((Document)documentEvent.getSource());
                return;
            }
            case 1003: {
                this.fitPanelToDocument();
                return;
            }
        }
    }

    protected boolean setsBaseURL() {
        return false;
    }

    protected void processPanelKeyEvent(KeyEvent keyEvent) {
    }

    public void processKeyActionEvent(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        switch (keyEvent.getKeyCode()) {
            case 36: {
                if (object instanceof TextComponent) break;
                this.current.top();
                return;
            }
            case 34: {
                this.current.scrollBy(0, this.current.height);
                return;
            }
            case 33: {
                this.current.scrollBy(0, -this.current.height);
                return;
            }
            case 35: {
                if (object instanceof TextComponent) break;
                this.current.scrollTo(0, this.current.docHeight - this.current.height);
                return;
            }
            case 38: {
                if (object instanceof TextArea) break;
                Adjustable adjustable = this.getVAdjustable();
                this.current.scrollBy(0, -adjustable.getUnitIncrement());
                return;
            }
            case 40: {
                if (object instanceof TextArea) break;
                Adjustable adjustable = this.getVAdjustable();
                this.current.scrollBy(0, adjustable.getUnitIncrement());
                return;
            }
            case 37: {
                if (object instanceof TextComponent) break;
                Adjustable adjustable = this.getHAdjustable();
                this.current.scrollBy(-adjustable.getUnitIncrement(), 0);
                return;
            }
            case 39: {
                if (object instanceof TextComponent) break;
                Adjustable adjustable = this.getHAdjustable();
                this.current.scrollBy(adjustable.getUnitIncrement(), 0);
                return;
            }
        }
    }

    protected class DocListener
    implements DocumentListener,
    Serializable {
        public void documentChanged(DocumentEvent documentEvent) {
            if (DocumentPanel.this.current != null) {
                DocumentPanel.this.processDocumentEvent(documentEvent);
            }
        }

        DocListener() {
            DocumentPanel.this = DocumentPanel.this;
        }
    }

    private final class AppletEventListener
    implements AppletListener {
        public void appletStateChanged(AppletEvent appletEvent) {
            switch (appletEvent.getID()) {
                case 51235: {
                    ++DocumentPanel.this.appletLoadingCount;
                    return;
                }
                case 51236: {
                    --DocumentPanel.this.appletLoadingCount;
                    return;
                }
            }
        }

        AppletEventListener() {
            DocumentPanel.this = DocumentPanel.this;
        }
    }

    private final class 1
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isActionKey()) {
                DocumentPanel.this.processKeyActionEvent(keyEvent);
                return;
            }
            DocumentPanel.this.processPanelKeyEvent(keyEvent);
        }

        /* synthetic */ 1() {
        }
    }
}

