/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.PrintJob;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import sunw.hotjava.doc.ClientPuller;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentCache;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentEventSource;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentListener;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.DocumentPanelStack;
import sunw.hotjava.doc.NamedLink;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.Hax;
import sunw.hotjava.tags.TagAppletPanel;

public class MasterDocumentPanel
extends DocumentPanel
implements Runnable {
    private URL currentURL;
    protected DocumentPanelStack docPanelStack = new DocumentPanelStack();
    private DocumentListener topDocEventsListener;
    private ActionListener topActionEventsListener;

    public MasterDocumentPanel(DocFont docFont) {
        super(docFont);
    }

    public MasterDocumentPanel(MasterDocumentPanel masterDocumentPanel) {
        this.addDocumentListener(new DocumentPanel.DocListener());
    }

    public MasterDocumentPanel() {
        this.addDocumentListener(new DocumentPanel.DocListener());
    }

    public boolean canForward() {
        return this.docPanelStack.canForward();
    }

    public void forward() {
        DocumentPanelStack documentPanelStack = this.docPanelStack;
        synchronized (documentPanelStack) {
            DocumentPanel documentPanel = this.docPanelStack.forward();
            if (documentPanel != null) {
                documentPanel.nextDocument();
            }
            return;
        }
    }

    public Document getForwardDocument() {
        DocumentPanelStack documentPanelStack = this.docPanelStack;
        synchronized (documentPanelStack) {
            DocumentPanel documentPanel = this.docPanelStack.getNext();
            if (documentPanel != null) {
                Document document = documentPanel.getNextDocument();
                Object var3_4 = null;
                return document;
            }
        }
        return null;
    }

    public boolean canBack() {
        return this.docPanelStack.canBack();
    }

    public void back() {
        DocumentPanelStack documentPanelStack = this.docPanelStack;
        synchronized (documentPanelStack) {
            DocumentPanel documentPanel = this.docPanelStack.back();
            if (documentPanel != null) {
                documentPanel.previousDocument();
            }
            return;
        }
    }

    public Document getBackDocument() {
        DocumentPanelStack documentPanelStack = this.docPanelStack;
        synchronized (documentPanelStack) {
            DocumentPanel documentPanel = this.docPanelStack.getPrevious();
            if (documentPanel != null) {
                Document document = documentPanel.getPreviousDocument();
                Object var3_4 = null;
                return document;
            }
        }
        return null;
    }

    public void replaceCurrentDocument(DocumentPanel documentPanel, URL uRL) {
        URL uRL2 = null;
        this.replaceCurrentDocument(documentPanel, uRL, uRL2);
    }

    public void replaceCurrentDocument(DocumentPanel documentPanel, URL uRL, URL uRL2) {
        documentPanel.showDocument(DocumentCache.getDocument(uRL, uRL2), true);
    }

    public void replaceCurrentDocument(DocumentPanel documentPanel, URL uRL, Properties properties) {
        this.replaceCurrentDocument(documentPanel, uRL, null, properties);
    }

    public void replaceCurrentDocument(DocumentPanel documentPanel, URL uRL, URL uRL2, Properties properties) {
        Document document = new Document(uRL, uRL2);
        if (properties != null) {
            document.setParserProperties(properties);
        }
        documentPanel.showDocument(document, true);
    }

    public DocumentPanel findPanel(Container container, String string) {
        int n = container.countComponents();
        int n2 = 0;
        while (n2 < n) {
            DocumentPanel documentPanel;
            Component component = container.getComponent(n2);
            if (component instanceof DocumentPanel && string.equals((documentPanel = (DocumentPanel)component).getName())) {
                return documentPanel;
            }
            if (component instanceof Container && (documentPanel = this.findPanel((Container)component, string)) != null) {
                return documentPanel;
            }
            ++n2;
        }
        return null;
    }

    public void push(DocumentPanel documentPanel, URL uRL) {
        this.push(documentPanel, uRL, null);
    }

    public void push(DocumentPanel documentPanel, URL uRL, URL uRL2) {
        if (this.isSetCurrentDocumentAllowed(uRL, null, false)) {
            this._push(documentPanel, uRL, uRL2);
        }
    }

    protected void _push(DocumentPanel documentPanel, URL uRL, URL uRL2) {
        this.push(documentPanel, DocumentCache.getDocument(uRL, uRL2));
        documentPanel.gotoLabel(uRL.getRef());
    }

    protected void _push(DocumentPanel documentPanel, Document document, URL uRL) {
        this.push(documentPanel, document);
        documentPanel.gotoLabel(document.getURL().getRef());
    }

    public void push(DocumentPanel documentPanel, Document document) {
        documentPanel.showDocument(document);
    }

    public void updateDocPanelStack(DocumentPanel documentPanel) {
        documentPanel.updateDocStack();
    }

    public void push(Document document) {
        this.push((DocumentPanel)this, document);
    }

    public void push(URL uRL) {
        this.push(this, uRL, null);
    }

    public void push(URL uRL, URL uRL2) {
        this.push(this, uRL, uRL2);
    }

    public void push(Component component, String string, Document document) {
        this.push(component, string, document.getURL(), null, document);
    }

    public void push(Component component, String string, URL uRL) {
        this.push(component, string, uRL, null, null);
    }

    protected boolean isSetCurrentDocumentAllowed(URL uRL, String string, boolean bl) {
        return true;
    }

    protected void setCurrentDocument(URL uRL, String string, boolean bl) {
        this._push((DocumentPanel)this, uRL, null);
    }

    public void push(Component component, String string, URL uRL, URL uRL2) {
        this.push(component, string, uRL, uRL2, null);
    }

    public void push(Component component, String string, URL uRL, URL uRL2, Document document) {
        boolean bl;
        if (string == null || string.equals("")) {
            string = "_self";
        }
        if (string.equals("_blank")) {
            if (this.isSetCurrentDocumentAllowed(uRL, string, true)) {
                if (document == null) {
                    this.setCurrentDocument(uRL, string, true);
                    return;
                }
                this._push((DocumentPanel)this, document, null);
            }
            return;
        }
        string = string.toLowerCase();
        DocumentPanel documentPanel = null;
        boolean bl2 = bl = documentPanel == null;
        if (string.startsWith("_")) {
            bl = false;
            documentPanel = this;
        } else {
            documentPanel = this.findPanel(this, string);
        }
        boolean bl3 = this.isSetCurrentDocumentAllowed(uRL, string, bl);
        if (string.equals("_top")) {
            if (document == null) {
                this._push((DocumentPanel)this, uRL, uRL2);
                return;
            }
            this._push((DocumentPanel)this, document, uRL2);
            return;
        }
        if (component != null) {
            if (string.equals("_parent")) {
                Container container = component.getParent();
                while (container != null) {
                    if (container instanceof DocumentPanel) {
                        DocumentPanel documentPanel2 = (DocumentPanel)container;
                        if (document == null) {
                            this._push(documentPanel2, uRL, uRL2);
                            return;
                        }
                        this._push(documentPanel2, document, uRL2);
                        return;
                    }
                    container = container.getParent();
                }
            } else if (string.equals("_self")) {
                if (component instanceof DocumentPanel) {
                    if (document == null) {
                        this._push((DocumentPanel)component, uRL, uRL2);
                        return;
                    }
                    this._push((DocumentPanel)component, document, uRL2);
                    return;
                }
                Container container = component.getParent();
                while (container != null) {
                    if (container instanceof DocumentPanel) {
                        if (document == null) {
                            this._push((DocumentPanel)this, uRL, uRL2);
                            return;
                        }
                        this._push((DocumentPanel)this, document, uRL2);
                        return;
                    }
                    container = container.getParent();
                }
            } else if (string.equals("_replace")) {
                Container container = (Container)component;
                while (container != null) {
                    if (container instanceof DocumentPanel) {
                        this.replaceCurrentDocument((DocumentPanel)container, uRL, uRL2);
                        return;
                    }
                    container = container.getParent();
                }
            } else if (string.startsWith("_refresh")) {
                if (!(component instanceof DocumentPanel)) {
                    return;
                }
                this.setupClientPull(string, uRL, (DocumentPanel)component);
                return;
            }
        }
        if (string.startsWith("_")) {
            if (document == null) {
                this._push((DocumentPanel)this, uRL, uRL2);
                return;
            }
            this._push((DocumentPanel)this, document, uRL2);
            return;
        }
        if (bl3 && documentPanel != null) {
            if (document == null) {
                this._push(documentPanel, uRL, uRL2);
                return;
            }
            this._push(documentPanel, document, uRL2);
            return;
        }
        if (bl3) {
            if (this.pushInNamedPanel(uRL, uRL2, string)) {
                return;
            }
            this.setCurrentDocument(uRL, string, true);
        }
    }

    protected boolean pushInNamedPanel(URL uRL, URL uRL2, String string) {
        return false;
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        switch (documentEvent.getID()) {
            case 1002: {
                if (documentEvent.isShiftDown()) break;
                NamedLink namedLink = (NamedLink)documentEvent.getArgument();
                this.push((DocumentPanel)documentEvent.getSource(), namedLink.name, namedLink.url, namedLink.referer, documentEvent.getDocument());
                String string = System.getProperty("dopplegangerProg");
                if (string != null) {
                    try {
                        Runtime runtime = Runtime.getRuntime();
                        runtime.exec(String.valueOf(string) + " " + namedLink.url + " " + namedLink.name);
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                return;
            }
            case 1019: {
                super.processDocumentEvent(documentEvent);
                return;
            }
            case 1004: {
                Document document = this.getDocument();
                if (documentEvent.getSource() != document) break;
                String string = (String)documentEvent.getArgument();
                if (string.equals("url")) {
                    URL uRL = document.getURL();
                    this.gotoLabel(uRL.getRef());
                    return;
                }
                if (!string.equals("refresh")) break;
                this.requestTimedRefresh(document);
                return;
            }
            case 1010: {
                DocumentPanel documentPanel = (DocumentPanel)documentEvent.arg;
                this.updateDocPanelStack(documentPanel);
                return;
            }
            case 1003: {
                this.fitPanelToDocument();
                return;
            }
            default: {
                super.processDocumentEvent(documentEvent);
            }
        }
    }

    protected void processPanelKeyEvent(KeyEvent keyEvent) {
        Hax.debugln("hotjava.debug.MasterDocPanelEvents", "MasterDocumentPanel.processKeyEvent(" + keyEvent + ")");
        switch (keyEvent.getKeyCode()) {
            case 23: {
                this.list();
                return;
            }
        }
    }

    public boolean canReload() {
        Document document = this.getDocument();
        return document != null && document.getURL() != null;
    }

    protected boolean containsCodebase(DocumentFormatter documentFormatter, Vector vector) {
        Vector vector2 = new Vector();
        documentFormatter.getAppletPanels(vector2, true);
        int n = 0;
        while (n < vector2.size()) {
            URL uRL = ((TagAppletPanel)vector2.elementAt(n)).getCodeBase();
            if (vector.contains(uRL)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean canStopLoading() {
        Document document = this.getDocument();
        return document != null && (document.getState() == 11 || document.getState() == 12 || this.appletLoadingCount > 0);
    }

    public void stopLoading() {
        Document document = this.getDocument();
        if (document != null) {
            document.interruptOwnerWaitCompletion();
        }
    }

    public boolean showingTags() {
        return this.current != null && this.current.ds.tags;
    }

    public void flipTags() {
        if (this.current != null) {
            this.current.setShowingTags(!this.current.ds.tags);
            this.current.reformat();
        }
    }

    public DocStyle getStyle() {
        return new DocStyle();
    }

    public void print() {
        new Thread((Runnable)this, "Document Printer").start();
    }

    public void run() {
        Frame frame = this.getContainingFrame();
        PrintJob printJob = this.getToolkit().getPrintJob(frame, this.getDocument().getTitle(), Globals.props);
        if (printJob != null) {
            int n = frame.getCursorType();
            try {
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
                try {
                    this.print(printJob, this);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    printJob.end();
                    String string = Globals.localProps.handleGetString("printjob.err.msg");
                    this.setErrorMessage(string);
                    Object var5_6 = null;
                    frame.setCursor(n);
                    return;
                }
                printJob.end();
            }
            finally {
                Object var5_7 = null;
                frame.setCursor(n);
            }
            this.setErrorMessage(Globals.localProps.handleGetString("printjob.done.msg"));
            return;
        }
        this.setErrorMessage(Globals.localProps.handleGetString("printjob.cancelled.msg"));
    }

    public void setTopEventListeners(DocumentListener documentListener, ActionListener actionListener) {
        this.topDocEventsListener = documentListener;
        this.topActionEventsListener = actionListener;
    }

    public void addTopDocListenerToSource(DocumentEventSource documentEventSource) {
        documentEventSource.addDocumentListener(this.topDocEventsListener);
    }

    public void removeTopDocListenerFromSource(DocumentEventSource documentEventSource) {
        documentEventSource.removeDocumentListener(this.topDocEventsListener);
    }

    public void setMessage(String string) {
        if (this.topDocEventsListener != null) {
            this.topDocEventsListener.documentChanged(new DocumentEvent(this, 1024, string));
        }
    }

    public void internalGoto(DocPanel docPanel, URL uRL, URL uRL2, boolean bl) {
        if (this.topDocEventsListener != null) {
            NamedLink namedLink = new NamedLink("_top", uRL, uRL2);
            this.topDocEventsListener.documentChanged(new DocumentEvent(docPanel, 1025, bl, namedLink));
        }
    }

    public void internalGoto(DocPanel docPanel, Document document, boolean bl) {
        if (this.topDocEventsListener != null) {
            this.topDocEventsListener.documentChanged(new DocumentEvent(docPanel, 1025, bl, document));
        }
    }

    public void internalGoto(DocPanel docPanel, String string, URL uRL, boolean bl) {
        if (this.topDocEventsListener != null) {
            NamedLink namedLink = new NamedLink(string, uRL);
            this.topDocEventsListener.documentChanged(new DocumentEvent(docPanel, 1025, bl, namedLink));
        }
    }

    public void internalGoto(DocPanel docPanel, String string, Document document, boolean bl) {
        if (this.topDocEventsListener != null) {
            NamedLink namedLink = new NamedLink(string, document.getURL());
            DocumentEvent documentEvent = new DocumentEvent(docPanel, 1025, bl, namedLink);
            documentEvent.setDocument(document);
            this.topDocEventsListener.documentChanged(documentEvent);
        }
    }

    ActionListener getTopActionEventsListener() {
        return this.topActionEventsListener;
    }

    public static MasterDocumentPanel getContainingMasterDocumentPanel(Container container) {
        while (container != null) {
            if (container instanceof MasterDocumentPanel) {
                return (MasterDocumentPanel)container;
            }
            container = container.getParent();
        }
        return null;
    }

    protected void setErrorMessage(String string) {
    }

    private void setupClientPull(String string, URL uRL, DocumentPanel documentPanel) {
        Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "Client-pull:\n... spec '" + string + "', source '" + uRL + "'");
        int n = string.indexOf(32);
        if (n < 0) {
            System.err.println("Client-pull: bad refresh spec, " + string);
            return;
        }
        try {
            String string2;
            int n2;
            String string3 = string.substring(n).trim();
            StringTokenizer stringTokenizer = string3.indexOf(59) > 0 ? new StringTokenizer(string3, ";") : (string3.indexOf(44) > 0 ? new StringTokenizer(string3, ",") : new StringTokenizer(string3));
            int n3 = stringTokenizer.countTokens();
            switch (n3) {
                case 1: {
                    String string4 = stringTokenizer.nextToken().trim();
                    try {
                        n2 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Client-pull: bad refresh spec, " + string);
                        return;
                    }
                    string2 = uRL.toExternalForm();
                    Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "... refresh original, delay = " + n2);
                    break;
                }
                case 2: {
                    String string5 = stringTokenizer.nextToken().trim();
                    try {
                        n2 = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Client-pull: bad refresh spec, " + string);
                        return;
                    }
                    string2 = stringTokenizer.nextToken().trim();
                    if (string2 != null && (string2.startsWith("URL") || string2.startsWith("url"))) {
                        n = string2.indexOf(61);
                        if (n == -1) {
                            System.err.println("Client-pull: bad refresh doc spec, " + string2);
                            return;
                        }
                        string2 = string2.substring(n + 1);
                    }
                    Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "... refresh with '" + string2 + "', delay = " + n2);
                    break;
                }
                default: {
                    System.err.println("Client-pull: bad spec, " + n3 + " tokens in spec, " + string3);
                    return;
                }
            }
            ClientPuller clientPuller = new ClientPuller(this, documentPanel, uRL, string2, n2);
            Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "... start puller thread");
            clientPuller.start();
            return;
        }
        catch (Exception exception) {
            Hax.debugln("hotjava.debug.MasterDocumentPanel.ClientPull", "... exception occurred!");
            exception.printStackTrace();
            return;
        }
    }
}

