/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sun.misc.BASE64Encoder;
import sun.misc.CharacterEncoder;

public class Base64HeaderEncoder
extends CharacterEncoder {
    String header;
    String charset;

    public Base64HeaderEncoder(String string, String string2) {
        this.header = string;
        this.charset = string2;
    }

    protected void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        super.encodeBufferPrefix(outputStream);
        this.pStream.print(String.valueOf(this.header) + ":");
    }

    protected void encodeLinePrefix(OutputStream outputStream, int n) throws IOException {
        this.pStream.print(" =?" + this.charset + "?b?");
    }

    protected void encodeLineSuffix(OutputStream outputStream) throws IOException {
        this.pStream.println("?=");
    }

    protected int bytesPerAtom() {
        return 4;
    }

    protected int bytesPerLine() {
        int n = 76 - this.charset.length() - " =??b??=".length();
        return n - n % 4;
    }

    protected void encodeAtom(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        if (n2 != 4) {
            throw new IOException("Base64HeaderEncoder: bad chunk size");
        }
        outputStream.write(byArray[n]);
        outputStream.write(byArray[n + 1]);
        outputStream.write(byArray[n + 2]);
        outputStream.write(byArray[n + 3]);
    }

    protected int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            int n2 = inputStream.read();
            if (n2 == -1) {
                return n;
            }
            if (n2 == 13 || n2 == 10) {
                --n;
            } else {
                byArray[n] = (byte)n2;
            }
            ++n;
        }
        return byArray.length;
    }

    public void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bASE64Encoder.encodeBuffer(inputStream, (OutputStream)byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        super.encodeBuffer((InputStream)byteArrayInputStream, outputStream);
    }

    public void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bASE64Encoder.encode(inputStream, (OutputStream)byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        super.encode((InputStream)byteArrayInputStream, outputStream);
    }

    public static void main(String[] stringArray) {
        String string = "Usage: Base64HeaderEncoder <header> <charset> <content>";
        if (stringArray.length != 3) {
            System.out.println(string);
            System.exit(1);
        }
        Base64HeaderEncoder base64HeaderEncoder = new Base64HeaderEncoder(stringArray[0], stringArray[1]);
        try {
            base64HeaderEncoder.encodeBuffer(stringArray[2].getBytes(), System.out);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }
}

