/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import sunw.hotjava.misc.BrowserProperties;
import sunw.hotjava.misc.Globals;

public class PersistentProperties
extends Properties
implements BrowserProperties,
Serializable {
    private String filename;
    private boolean hadError = false;
    private boolean firstLoad = true;
    private boolean changed = false;

    public PersistentProperties(String string, InputStream inputStream) throws IOException {
        this.filename = string;
        if (inputStream != null) {
            this.load(inputStream);
        }
        this.firstLoad = false;
    }

    public boolean load() {
        try {
            if (!Globals.isBean) {
                File file = new File(this.filename);
                if (file.canRead()) {
                    this.load(new BufferedInputStream(new FileInputStream(file.getPath())));
                    return true;
                }
            } else {
                this.load(this.getClass().getResourceAsStream(this.filename));
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public boolean save() {
        if (this.changed) {
            try {
                File file = new File(String.valueOf(this.filename) + ".new");
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                this.save(bufferedOutputStream, null);
                ((OutputStream)bufferedOutputStream).flush();
                ((OutputStream)bufferedOutputStream).close();
                File file2 = new File(this.filename);
                if (file.renameTo(file2)) {
                    return true;
                }
                File file3 = new File(String.valueOf(this.filename) + ".old");
                file3.delete();
                if (file2.renameTo(file3) && file.renameTo(file2)) {
                    file3.delete();
                    return true;
                }
                System.out.println("ERROR:Rename properties, subatomic Failed!!");
                return false;
            }
            catch (IOException iOException) {
                System.out.println("Error on saving properties <" + this.filename + "> :" + iOException);
                this.hadError = true;
                return false;
            }
        }
        return false;
    }

    public Object put(Object object, Object object2) {
        this.changed = true;
        return super.put(object, object2);
    }

    public String getSaveErrorMessage() {
        if (this.hadError) {
            this.hadError = false;
            return this.filename;
        }
        return null;
    }

    public Object remove(Object object) {
        this.changed = true;
        return super.remove(object);
    }

    public boolean isChanged() {
        return this.changed;
    }
}

