/*
 * Decompiled with CFR 0.152.
 */
package oracle.network.security;

import java.io.InputStream;
import java.io.OutputStream;
import oracle.network.security.CryptoException;
import oracle.network.security.DeEnvelopeInputStream;
import oracle.network.security.DecryptInputStream;
import oracle.network.security.DetachSignOutputStream;
import oracle.network.security.DetachVerifyInputStream;
import oracle.network.security.EncryptOutputStream;
import oracle.network.security.EnvelopeOutputStream;
import oracle.network.security.HashInputStream;
import oracle.network.security.HashOutputStream;
import oracle.network.security.Identity;
import oracle.network.security.SignOutputStream;
import oracle.network.security.ValidateException;
import oracle.network.security.VerifyException;
import oracle.network.security.VerifyInputStream;

public interface Cryptographer {
    public byte[] sign(byte[] var1) throws CryptoException;

    public SignOutputStream sign(OutputStream var1) throws CryptoException;

    public byte[] signDetached(byte[] var1) throws CryptoException;

    public DetachSignOutputStream signDetached(OutputStream var1) throws CryptoException;

    public boolean verify(byte[] var1, Identity var2) throws CryptoException;

    public VerifyInputStream verify(InputStream var1, Identity var2) throws CryptoException;

    public boolean verifyDetached(byte[] var1, byte[] var2, Identity var3) throws CryptoException;

    public DetachVerifyInputStream verifyDetached(InputStream var1, byte[] var2, Identity var3) throws CryptoException;

    public boolean validate(Identity var1) throws CryptoException;

    public byte[] pkEncrypt(byte[] var1, Identity[] var2) throws CryptoException;

    public EncryptOutputStream pkEncrypt(OutputStream var1, Identity[] var2) throws CryptoException;

    public byte[] pkDecrypt(byte[] var1) throws CryptoException;

    public DecryptInputStream pkDecrypt(InputStream var1) throws CryptoException;

    public byte[] envelope(byte[] var1, Identity[] var2) throws CryptoException;

    public EnvelopeOutputStream envelope(OutputStream var1, Identity[] var2) throws CryptoException;

    public byte[] deEnvelope(byte[] var1) throws CryptoException, ValidateException, VerifyException;

    public DeEnvelopeInputStream deEnvelope(InputStream var1) throws CryptoException;

    public byte[] hash(byte[] var1) throws CryptoException;

    public HashOutputStream hash(OutputStream var1) throws CryptoException;

    public HashInputStream hash(InputStream var1) throws CryptoException;

    public byte[] keyedHash(byte[] var1, byte[] var2) throws CryptoException;

    public HashOutputStream keyedHash(OutputStream var1, byte[] var2) throws CryptoException;

    public HashInputStream keyedHash(InputStream var1, byte[] var2) throws CryptoException;

    public byte[] encrypt(byte[] var1) throws CryptoException;

    public EncryptOutputStream encrypt(OutputStream var1) throws CryptoException;

    public byte[] decrypt(byte[] var1) throws CryptoException;

    public DecryptInputStream decrypt(InputStream var1) throws CryptoException;

    public void seedRandom(byte[] var1) throws CryptoException;

    public byte[] randomBytes(int var1) throws CryptoException;

    public int randomNumber() throws CryptoException;
}

