/*
 * Decompiled with CFR 0.152.
 */
package oracle.network.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.network.security.CryptoException;
import oracle.network.security.Cryptographer;
import oracle.network.security.DeEnvelopeInputStream;
import oracle.network.security.DecryptInputStream;
import oracle.network.security.DetachSignOutputStream;
import oracle.network.security.DetachVerifyInputStream;
import oracle.network.security.EncryptOutputStream;
import oracle.network.security.EnvelopeOutputStream;
import oracle.network.security.HashInputStream;
import oracle.network.security.HashOutputStream;
import oracle.network.security.Identity;
import oracle.network.security.PersonaManagementException;
import oracle.network.security.ProtectionException;
import oracle.network.security.SelfIdentity;
import oracle.network.security.SignOutputStream;
import oracle.network.security.TrustedIdentity;
import oracle.network.security.ValidateException;
import oracle.network.security.VerifyException;
import oracle.network.security.VerifyInputStream;
import oracle.network.security.javalib.JavaPersona;
import oracle.network.security.javalib.JavaSelfIdent;

public abstract class Persona
implements Cryptographer,
Serializable,
Cloneable {
    private String _desc;
    private String _prot;
    private SelfIdentity _selfident;
    private Vector _trustedidents;

    public Object clone() throws CloneNotSupportedException {
        Persona persona = (Persona)super.clone();
        persona._desc = this._desc == null ? null : new String(this._desc);
        persona._prot = this._prot == null ? null : new String(this._prot);
        persona._selfident = this._selfident == null ? null : (SelfIdentity)this._selfident.clone();
        Enumeration enumeration = this._trustedidents.elements();
        this._trustedidents = new Vector();
        while (enumeration.hasMoreElements()) {
            TrustedIdentity trustedIdentity = (TrustedIdentity)enumeration.nextElement();
            this._trustedidents.addElement((TrustedIdentity)trustedIdentity.clone());
        }
        return persona;
    }

    public Persona() {
        this._trustedidents = new Vector();
    }

    public Persona(SelfIdentity selfIdentity) throws PersonaManagementException {
        this.setSelfIdent(selfIdentity);
        this._trustedidents = new Vector();
    }

    public void setDesc(String string) throws PersonaManagementException {
        this._desc = string;
    }

    public String getDesc() {
        return this._desc;
    }

    public void setProtection(String string) throws ProtectionException {
        this._prot = string;
    }

    public String getProtection() {
        return this._prot;
    }

    public void setSelfIdent(SelfIdentity selfIdentity) throws PersonaManagementException {
        this._selfident = selfIdentity;
    }

    public SelfIdentity getSelfIdent() {
        return this._selfident;
    }

    public void addTrustedIdent(TrustedIdentity trustedIdentity) throws PersonaManagementException {
        this._trustedidents.addElement(trustedIdentity);
    }

    public String[] listTrustedIdents() throws PersonaManagementException {
        int n = this._trustedidents.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            TrustedIdentity trustedIdentity = (TrustedIdentity)this._trustedidents.elementAt(n2);
            stringArray[n2] = trustedIdentity.getDesc();
            ++n2;
        }
        return stringArray;
    }

    public TrustedIdentity getTrustedIdent(String string) throws PersonaManagementException {
        int n = 0;
        while (n < this._trustedidents.size()) {
            TrustedIdentity trustedIdentity = (TrustedIdentity)this._trustedidents.elementAt(n);
            if (trustedIdentity.getDesc().equals(string)) {
                return trustedIdentity;
            }
            ++n;
        }
        return null;
    }

    public TrustedIdentity removeTrustedIdent(String string) throws PersonaManagementException {
        int n = 0;
        while (n < this._trustedidents.size()) {
            TrustedIdentity trustedIdentity = (TrustedIdentity)this._trustedidents.elementAt(n);
            if (trustedIdentity.getDesc().equals(string)) {
                this._trustedidents.removeElement(trustedIdentity);
                return trustedIdentity;
            }
            ++n;
        }
        throw new PersonaManagementException("Couldn't find identity in Persona");
    }

    public static Persona createPersona(SelfIdentity selfIdentity) throws PersonaManagementException {
        JavaPersona javaPersona = null;
        if (selfIdentity instanceof JavaSelfIdent) {
            javaPersona = new JavaPersona(selfIdentity);
        }
        return javaPersona;
    }

    public abstract byte[] sign(byte[] var1) throws CryptoException;

    public abstract SignOutputStream sign(OutputStream var1) throws CryptoException;

    public abstract byte[] signDetached(byte[] var1) throws CryptoException;

    public abstract DetachSignOutputStream signDetached(OutputStream var1) throws CryptoException;

    public abstract boolean verify(byte[] var1, Identity var2) throws CryptoException;

    public abstract VerifyInputStream verify(InputStream var1, Identity var2) throws CryptoException;

    public abstract boolean verifyDetached(byte[] var1, byte[] var2, Identity var3) throws CryptoException;

    public abstract DetachVerifyInputStream verifyDetached(InputStream var1, byte[] var2, Identity var3) throws CryptoException;

    public abstract boolean validate(Identity var1) throws CryptoException;

    public abstract byte[] pkEncrypt(byte[] var1, Identity[] var2) throws CryptoException;

    public abstract EncryptOutputStream pkEncrypt(OutputStream var1, Identity[] var2) throws CryptoException;

    public abstract byte[] pkDecrypt(byte[] var1) throws CryptoException;

    public abstract DecryptInputStream pkDecrypt(InputStream var1) throws CryptoException;

    public abstract byte[] envelope(byte[] var1, Identity[] var2) throws CryptoException;

    public abstract EnvelopeOutputStream envelope(OutputStream var1, Identity[] var2) throws CryptoException;

    public abstract byte[] deEnvelope(byte[] var1) throws CryptoException, ValidateException, VerifyException;

    public abstract DeEnvelopeInputStream deEnvelope(InputStream var1) throws CryptoException;

    public abstract byte[] hash(byte[] var1) throws CryptoException;

    public abstract HashOutputStream hash(OutputStream var1) throws CryptoException;

    public abstract HashInputStream hash(InputStream var1) throws CryptoException;

    public abstract byte[] keyedHash(byte[] var1, byte[] var2) throws CryptoException;

    public abstract HashOutputStream keyedHash(OutputStream var1, byte[] var2) throws CryptoException;

    public abstract HashInputStream keyedHash(InputStream var1, byte[] var2) throws CryptoException;

    public abstract byte[] encrypt(byte[] var1) throws CryptoException;

    public abstract EncryptOutputStream encrypt(OutputStream var1) throws CryptoException;

    public abstract byte[] decrypt(byte[] var1) throws CryptoException;

    public abstract DecryptInputStream decrypt(InputStream var1) throws CryptoException;

    public abstract void seedRandom(byte[] var1) throws CryptoException;

    public abstract byte[] randomBytes(int var1) throws CryptoException;

    public abstract int randomNumber() throws CryptoException;
}

