/*
 * Decompiled with CFR 0.152.
 */
package oracle.network.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import oracle.network.security.CryptoException;
import oracle.network.security.Cryptographer;
import oracle.network.security.DeEnvelopeInputStream;
import oracle.network.security.DecryptInputStream;
import oracle.network.security.DetachSignOutputStream;
import oracle.network.security.DetachVerifyInputStream;
import oracle.network.security.EncryptOutputStream;
import oracle.network.security.EnvelopeOutputStream;
import oracle.network.security.HashInputStream;
import oracle.network.security.HashOutputStream;
import oracle.network.security.Identity;
import oracle.network.security.SignOutputStream;
import oracle.network.security.ValidateException;
import oracle.network.security.VerifyException;
import oracle.network.security.VerifyInputStream;

public abstract class PersonaByte
implements Cryptographer,
Serializable {
    public byte[] sign(byte[] byArray) throws CryptoException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SignOutputStream signOutputStream = this.sign(byteArrayOutputStream);
        try {
            signOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] signDetached(byte[] byArray) throws CryptoException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DetachSignOutputStream detachSignOutputStream = this.signDetached(byteArrayOutputStream);
        try {
            detachSignOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        if (!detachSignOutputStream.isComplete()) {
            throw new CryptoException("Array was not fully processed");
        }
        return detachSignOutputStream.getSig();
    }

    public boolean verify(byte[] byArray, Identity identity) throws CryptoException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        VerifyInputStream verifyInputStream = this.verify(byteArrayInputStream, identity);
        try {
            while (verifyInputStream.read() != -1) {
            }
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        if (!verifyInputStream.isComplete()) {
            throw new CryptoException("Array was not fully processed");
        }
        return verifyInputStream.isVerified();
    }

    public boolean verifyDetached(byte[] byArray, byte[] byArray2, Identity identity) throws CryptoException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DetachVerifyInputStream detachVerifyInputStream = this.verifyDetached(byteArrayInputStream, byArray2, identity);
        try {
            while (detachVerifyInputStream.read() != -1) {
            }
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        if (!detachVerifyInputStream.isComplete()) {
            throw new CryptoException("Array was not fully processed");
        }
        return detachVerifyInputStream.isVerified();
    }

    public boolean validate(Identity identity) throws CryptoException {
        return false;
    }

    public byte[] pkEncrypt(byte[] byArray, Identity[] identityArray) throws CryptoException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EncryptOutputStream encryptOutputStream = this.pkEncrypt(byteArrayOutputStream, identityArray);
        try {
            encryptOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] pkDecrypt(byte[] byArray) throws CryptoException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DecryptInputStream decryptInputStream = this.pkDecrypt(byteArrayInputStream);
        byte[] byArray2 = null;
        try {
            byArray2 = new byte[decryptInputStream.available()];
            decryptInputStream.read(byArray2, 0, byArray2.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        return byArray2;
    }

    public byte[] envelope(byte[] byArray, Identity[] identityArray) throws CryptoException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EnvelopeOutputStream envelopeOutputStream = this.envelope(byteArrayOutputStream, identityArray);
        try {
            envelopeOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] deEnvelope(byte[] byArray) throws CryptoException, ValidateException, VerifyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DeEnvelopeInputStream deEnvelopeInputStream = this.deEnvelope(byteArrayInputStream);
        byte[] byArray2 = null;
        try {
            byArray2 = new byte[deEnvelopeInputStream.available()];
            deEnvelopeInputStream.read(byArray2, 0, byArray2.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        if (!deEnvelopeInputStream.isComplete()) {
            throw new CryptoException("Array was not fully processed");
        }
        if (!deEnvelopeInputStream.isVerified()) {
            throw new VerifyException();
        }
        if (!deEnvelopeInputStream.isValidated()) {
            throw new ValidateException();
        }
        return byArray2;
    }

    public byte[] hash(byte[] byArray) throws CryptoException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HashOutputStream hashOutputStream = this.hash(byteArrayOutputStream);
        try {
            hashOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] keyedHash(byte[] byArray, byte[] byArray2) throws CryptoException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HashOutputStream hashOutputStream = this.keyedHash(byteArrayOutputStream, byArray2);
        try {
            hashOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] encrypt(byte[] byArray) throws CryptoException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EncryptOutputStream encryptOutputStream = this.encrypt(byteArrayOutputStream);
        try {
            encryptOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] decrypt(byte[] byArray) throws CryptoException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DecryptInputStream decryptInputStream = this.decrypt(byteArrayInputStream);
        byte[] byArray2 = null;
        try {
            byArray2 = new byte[decryptInputStream.available()];
            decryptInputStream.read(byArray2, 0, byArray2.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("IO Error");
        }
        return byArray2;
    }

    public void seedRandom(byte[] byArray) throws CryptoException {
    }

    public byte[] randomBytes(int n) throws CryptoException {
        return null;
    }

    public int randomNumber() {
        return 0;
    }

    public abstract SignOutputStream sign(OutputStream var1) throws CryptoException;

    public abstract DetachSignOutputStream signDetached(OutputStream var1) throws CryptoException;

    public abstract VerifyInputStream verify(InputStream var1, Identity var2) throws CryptoException;

    public abstract DetachVerifyInputStream verifyDetached(InputStream var1, byte[] var2, Identity var3) throws CryptoException;

    public abstract EncryptOutputStream pkEncrypt(OutputStream var1, Identity[] var2) throws CryptoException;

    public abstract DecryptInputStream pkDecrypt(InputStream var1) throws CryptoException;

    public abstract EnvelopeOutputStream envelope(OutputStream var1, Identity[] var2) throws CryptoException;

    public abstract DeEnvelopeInputStream deEnvelope(InputStream var1) throws CryptoException;

    public abstract HashOutputStream hash(OutputStream var1) throws CryptoException;

    public abstract HashInputStream hash(InputStream var1) throws CryptoException;

    public abstract HashOutputStream keyedHash(OutputStream var1, byte[] var2) throws CryptoException;

    public abstract HashInputStream keyedHash(InputStream var1, byte[] var2) throws CryptoException;

    public abstract EncryptOutputStream encrypt(OutputStream var1) throws CryptoException;

    public abstract DecryptInputStream decrypt(InputStream var1) throws CryptoException;
}

