/*
 * Decompiled with CFR 0.152.
 */
package oracle.network.security;

import java.io.Serializable;
import java.security.Certificate;
import java.security.PrivateKey;
import oracle.network.security.Identity;
import oracle.network.security.IdentityManagementException;
import oracle.network.security.javalib.JavaSelfIdent;
import sun.security.x509.X509Cert;

public abstract class SelfIdentity
extends Identity
implements Serializable {
    private byte[] _key = null;

    public Object clone() throws CloneNotSupportedException {
        SelfIdentity selfIdentity = (SelfIdentity)super.clone();
        selfIdentity._key = (byte[])(this._key == null ? null : (byte[])this._key.clone());
        return selfIdentity;
    }

    public void setKey(byte[] byArray) throws IdentityManagementException {
        this._key = byArray;
    }

    public byte[] getKey() {
        return this._key;
    }

    public static SelfIdentity createSelfIdentity(Certificate certificate, PrivateKey privateKey) throws IdentityManagementException {
        JavaSelfIdent javaSelfIdent = null;
        if (certificate instanceof X509Cert) {
            JavaSelfIdent javaSelfIdent2 = new JavaSelfIdent();
            javaSelfIdent2.setJavaCert(certificate);
            javaSelfIdent2.setJavaKey(privateKey);
            try {
                javaSelfIdent2.verifyCertKey();
            }
            catch (Exception exception) {
                throw new IdentityManagementException("Private Key and Certificate don't match");
            }
            javaSelfIdent = javaSelfIdent2;
        }
        return javaSelfIdent;
    }
}

