/*
 * Decompiled with CFR 0.152.
 */
package oracle.network.security;

import java.io.File;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.network.security.BadPasswordException;
import oracle.network.security.Persona;
import oracle.network.security.PersonaListElement;
import oracle.network.security.WRLException;
import oracle.network.security.WalletManagementException;
import oracle.network.security.javalib.JavaWallet;

public abstract class Wallet
implements Serializable {
    private String _wrl;
    private transient String _passwd;
    private Vector _personas = new Vector();

    public void storePersona(Persona persona) throws WalletManagementException {
        try {
            Persona persona2 = (Persona)persona.clone();
            this._personas.addElement(persona2);
            return;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new WalletManagementException("Couldn't clone Persona");
        }
    }

    public Persona removePersona(PersonaListElement personaListElement) throws WalletManagementException {
        int n = 0;
        while (n < this._personas.size()) {
            Persona persona = (Persona)this._personas.elementAt(n);
            if (persona.hashCode() == personaListElement.getHash()) {
                this._personas.removeElement(persona);
                return persona;
            }
            ++n;
        }
        throw new WalletManagementException("Persona not found in wallet");
    }

    public PersonaListElement[] listPersonas() throws WalletManagementException {
        int n = this._personas.size();
        PersonaListElement[] personaListElementArray = new PersonaListElement[n];
        int n2 = 0;
        while (n2 < n) {
            Persona persona = (Persona)this._personas.elementAt(n2);
            personaListElementArray[n2] = new PersonaListElement(persona.getDesc(), persona.hashCode());
            ++n2;
        }
        return personaListElementArray;
    }

    public Persona retrievePersona(PersonaListElement personaListElement) throws WalletManagementException {
        int n = 0;
        while (n < this._personas.size()) {
            Persona persona = (Persona)this._personas.elementAt(n);
            if (persona.hashCode() == personaListElement.getHash()) {
                try {
                    return (Persona)persona.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new WalletManagementException("Couldn't clone persona");
                }
            }
            ++n;
        }
        throw new WalletManagementException("Persona not found in wallet");
    }

    public static Wallet openWallet(String string, String string2) throws WalletManagementException, WRLException, BadPasswordException {
        Wallet wallet = null;
        wallet = JavaWallet.open(string, string2);
        if (wallet == null) {
            throw new WRLException("Opened null wallet at : " + string);
        }
        wallet.setPasswd(string2);
        return wallet;
    }

    public static Wallet createWallet(String string, String string2) throws WalletManagementException, WRLException {
        JavaWallet javaWallet = new JavaWallet();
        javaWallet.create(string);
        javaWallet.setWRL(string);
        javaWallet.setPasswd(string2);
        return javaWallet;
    }

    public static void closeWallet(Wallet wallet) throws WalletManagementException {
        if (wallet instanceof JavaWallet) {
            JavaWallet javaWallet = (JavaWallet)wallet;
            javaWallet.close(javaWallet);
            return;
        }
        throw new WalletManagementException("Don't know how to deal with a wallet of this type");
    }

    public static void deleteWallet(String string, String string2) throws WalletManagementException, WRLException {
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        string3 = stringTokenizer.nextToken();
        string4 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            throw new WRLException("Excess WRL arguments");
        }
        if (string3.equals("java")) {
            File file = new File(string4);
            file.delete();
        }
        throw new WRLException("Don't know how to deal with WRL: " + string);
    }

    public void setWRL(String string) {
        this._wrl = string;
    }

    public String getWRL() {
        return this._wrl;
    }

    public void setPasswd(String string) {
        this._passwd = string;
    }

    public String getPasswd() {
        return this._passwd;
    }
}

