/*
 * Decompiled with CFR 0.152.
 */
package oracle.network.security.javalib;

import java.io.Serializable;
import java.security.Certificate;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import oracle.network.security.CryptoException;
import oracle.network.security.IdentityManagementException;
import oracle.network.security.SelfIdentity;

public class JavaSelfIdent
extends SelfIdentity
implements Serializable {
    private Certificate _cert = null;
    private PrivateKey _key = null;
    private String _certRequest;
    private boolean _isRequested = false;

    public boolean isReadOnly() {
        return false;
    }

    public void setJavaCert(Certificate certificate) {
        this._cert = certificate;
    }

    public Certificate getJavaCert() {
        return this._cert;
    }

    public void setJavaKey(PrivateKey privateKey) {
        this._key = privateKey;
    }

    public PrivateKey getJavaKey() {
        return this._key;
    }

    public void setRequested(boolean bl) {
        this._isRequested = bl;
    }

    public void setCertificateRequest(String string) {
        this._certRequest = string;
    }

    public String getCertificateRequest() {
        return this._certRequest;
    }

    public boolean getRequested() {
        return this._isRequested;
    }

    public void verifyCertKey() throws IdentityManagementException, CryptoException {
        Signature signature = null;
        String string = new String("Verify Certificate and Key 0123 456 %^&");
        byte[] byArray = null;
        if (this._cert == null || this._key == null) {
            throw new IdentityManagementException();
        }
        try {
            signature = Signature.getInstance("RSA");
            signature.initSign(this.getJavaKey());
            signature.update(string.getBytes());
            byArray = signature.sign();
            signature.initVerify(this.getJavaCert().getPublicKey());
            signature.update(string.getBytes());
            if (!signature.verify(byArray)) {
                throw new IdentityManagementException("Certificate and Key don't match");
            }
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchAlgorithmException) {
                throw new CryptoException("No such algorithm");
            }
            if (exception instanceof InvalidKeyException) {
                throw new CryptoException("Invalid private key");
            }
            if (exception instanceof SignatureException) {
                throw new CryptoException("Signature exception");
            }
            throw new IdentityManagementException("Certificate and Private Key do not match");
        }
    }
}

