/*
 * Decompiled with CFR 0.152.
 */
package oracle.network.security.javalib;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.PrivateKey;
import java.util.Vector;
import oracle.network.security.Persona;
import oracle.network.security.PersonaListElement;
import oracle.network.security.Wallet;
import oracle.network.security.WalletManagementException;
import oracle.network.security.javalib.JavaSelfIdent;
import oracle.network.security.javalib.JavaTrustedIdent;
import oracle.network.security.nativelib.NZNative;
import oracle.network.security.streams.WalletDecrypt;
import sun.security.x509.X509Cert;

public class JavaWallet
extends Wallet
implements Serializable {
    private String _file;
    private static transient NZNative nzclass = null;
    private static transient boolean initnz;
    private transient String _exportpath;

    private static final void initNZ() {
        if (!initnz) {
            nzclass = new NZNative();
            try {
                nzclass.init();
                initnz = true;
                return;
            }
            catch (Exception exception) {
                System.out.println("Caught exception: " + exception.toString());
                return;
            }
        }
    }

    public JavaWallet() {
        JavaWallet.initNZ();
    }

    public void RetrieveLDAP(String string) throws WalletManagementException {
        if (!nzclass.LDAPRetrieveWallet(this._exportpath, string)) {
            throw new WalletManagementException("Failed to Store to LDAP");
        }
    }

    public void StoreLDAP() throws WalletManagementException {
        PersonaListElement[] personaListElementArray = this.listPersonas();
        int n = 0;
        while (n < personaListElementArray.length) {
            String[] stringArray;
            Persona persona = this.retrievePersona(personaListElementArray[n]);
            JavaSelfIdent javaSelfIdent = (JavaSelfIdent)persona.getSelfIdent();
            X509Cert x509Cert = (X509Cert)javaSelfIdent.getJavaCert();
            Vector<byte[]> vector = new Vector<byte[]>();
            try {
                stringArray = persona.listTrustedIdents();
            }
            catch (Exception exception) {
                throw new WalletManagementException("Failed to list trusted identity");
            }
            if (stringArray.length > 0) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    JavaTrustedIdent javaTrustedIdent;
                    try {
                        javaTrustedIdent = (JavaTrustedIdent)persona.getTrustedIdent(stringArray[n3]);
                    }
                    catch (Exception exception) {
                        throw new WalletManagementException("Failed to get Trusted Identity");
                    }
                    if (javaTrustedIdent.isAccepted()) {
                        X509Cert x509Cert2 = (X509Cert)javaTrustedIdent.getJavaCert();
                        byte[] byArray = x509Cert2.getSignedCert();
                        vector.addElement(byArray);
                        ++n2;
                    }
                    ++n3;
                }
            }
            PrivateKey privateKey = javaSelfIdent.getJavaKey();
            boolean bl = nzclass.LDAPStoreWallet(x509Cert.getSignedCert(), vector, privateKey.getEncoded(), super.getPasswd(), x509Cert.getSubjectName().toString(), this._exportpath);
            if (!bl) {
                throw new WalletManagementException("Failed to Store to LDAP");
            }
            ++n;
        }
    }

    public static Wallet open(String string, String string2) throws WalletManagementException {
        Wallet wallet;
        String string3;
        block3: {
            string3 = "/";
            wallet = null;
            try {
                WalletDecrypt walletDecrypt = new WalletDecrypt(new FileInputStream(String.valueOf(string) + string3 + "wallet.wlt"), string2);
                byte[] byArray = walletDecrypt.decrypt();
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                wallet = (Wallet)objectInputStream.readObject();
                objectInputStream.close();
                initnz = false;
                JavaWallet cfr_ignored_0 = (JavaWallet)wallet;
                JavaWallet.initNZ();
            }
            catch (Exception exception) {
                if (exception instanceof StreamCorruptedException || exception instanceof OptionalDataException) {
                    throw new WalletManagementException("Corrupted wallet file");
                }
                if (!(exception instanceof IOException)) break block3;
                throw new WalletManagementException("IO Error reading wallet");
            }
        }
        ((JavaWallet)wallet)._file = String.valueOf(string) + string3 + "wallet.wlt";
        ((JavaWallet)wallet)._exportpath = "file:" + string;
        return wallet;
    }

    public void create(String string) throws WalletManagementException {
        String string2 = File.separator;
        this._exportpath = "file:" + string;
        this._file = String.valueOf(string) + string2 + "wallet.wlt";
    }

    public void SetWRL(String string) {
        String string2 = File.separator;
        this._exportpath = "file:" + string;
        this._file = String.valueOf(string) + string2 + "wallet.wlt";
    }

    public void close(JavaWallet javaWallet) throws WalletManagementException {
        ObjectOutputStream objectOutputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(javaWallet);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            String string = javaWallet.getPasswd();
            byte[] byArray2 = nzclass.pbe(byArray, string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this._file));
            int n = 0;
            while (byArray2.length - n >= 512) {
                bufferedOutputStream.write(byArray2, n, 512);
                n += 512;
            }
            bufferedOutputStream.write(byArray2, n, byArray2.length - n);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw new WalletManagementException("IO Error writing wallet");
            }
            return;
        }
    }

    public void exportkey(String string) throws WalletManagementException {
        PersonaListElement[] personaListElementArray = this.listPersonas();
        int n = 0;
        while (n < personaListElementArray.length) {
            Persona persona = this.retrievePersona(personaListElementArray[n]);
            JavaSelfIdent javaSelfIdent = (JavaSelfIdent)persona.getSelfIdent();
            PrivateKey privateKey = javaSelfIdent.getJavaKey();
            boolean bl = nzclass.exportPrivateKey(privateKey.getEncoded(), super.getPasswd(), string, this._exportpath);
            if (!bl) {
                throw new WalletManagementException("Failed to export private key");
            }
            ++n;
        }
    }

    public void exporttp(boolean bl) throws WalletManagementException {
        PersonaListElement[] personaListElementArray = this.listPersonas();
        int n = 0;
        while (n < personaListElementArray.length) {
            String[] stringArray;
            Persona persona = this.retrievePersona(personaListElementArray[n]);
            Vector<byte[]> vector = new Vector<byte[]>();
            try {
                stringArray = persona.listTrustedIdents();
            }
            catch (Exception exception) {
                throw new WalletManagementException("Failed to list trusted identity");
            }
            if (stringArray.length > 0) {
                boolean bl2;
                int n2 = 0;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    JavaTrustedIdent javaTrustedIdent;
                    try {
                        javaTrustedIdent = (JavaTrustedIdent)persona.getTrustedIdent(stringArray[n3]);
                    }
                    catch (Exception exception) {
                        throw new WalletManagementException("Failed to get Trusted Identity");
                    }
                    if (javaTrustedIdent.isAccepted()) {
                        X509Cert x509Cert = (X509Cert)javaTrustedIdent.getJavaCert();
                        byte[] byArray = x509Cert.getSignedCert();
                        vector.addElement(byArray);
                        ++n2;
                    }
                    ++n3;
                }
                if (n2 > 0 && !(bl2 = nzclass.exportTrustpoints(vector, this._exportpath, bl, super.getPasswd()))) {
                    throw new WalletManagementException("Failed to export Trustpoints");
                }
            }
            ++n;
        }
    }

    public void export(boolean bl) throws WalletManagementException {
        this.debug("ENTER: export");
        this.export_for_type(bl, true);
    }

    private void export_for_type(boolean bl, boolean bl2) throws WalletManagementException {
        PersonaListElement[] personaListElementArray = this.listPersonas();
        int n = 0;
        while (n < personaListElementArray.length) {
            String[] stringArray;
            boolean bl3;
            Persona persona = this.retrievePersona(personaListElementArray[n]);
            JavaSelfIdent javaSelfIdent = (JavaSelfIdent)persona.getSelfIdent();
            X509Cert x509Cert = (X509Cert)javaSelfIdent.getJavaCert();
            if (!bl2 && !(bl3 = nzclass.exportCert(x509Cert.getSignedCert(), this._exportpath))) {
                throw new WalletManagementException("Failed to export certificate");
            }
            PrivateKey privateKey = javaSelfIdent.getJavaKey();
            if (!bl2 && !(bl3 = nzclass.exportPrivateKey(privateKey.getEncoded(), super.getPasswd(), x509Cert.getSubjectName().toString(), this._exportpath))) {
                throw new WalletManagementException("Failed to export private key");
            }
            Vector<byte[]> vector = new Vector<byte[]>();
            try {
                stringArray = persona.listTrustedIdents();
            }
            catch (Exception exception) {
                throw new WalletManagementException("Failed to list trusted identity");
            }
            if (stringArray.length > 0) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    JavaTrustedIdent javaTrustedIdent;
                    try {
                        javaTrustedIdent = (JavaTrustedIdent)persona.getTrustedIdent(stringArray[n3]);
                        this.debug(String.valueOf(javaTrustedIdent.getDesc()) + "  " + javaTrustedIdent.isAccepted());
                    }
                    catch (Exception exception) {
                        throw new WalletManagementException("Failed to get Trusted Identity");
                    }
                    if (javaTrustedIdent.isAccepted()) {
                        X509Cert x509Cert2 = (X509Cert)javaTrustedIdent.getJavaCert();
                        byte[] byArray = x509Cert2.getSignedCert();
                        vector.addElement(byArray);
                        ++n2;
                    }
                    ++n3;
                }
                if (n2 > 0 && !bl2 && !(bl3 = nzclass.exportTrustpoints(vector, this._exportpath, bl, super.getPasswd()))) {
                    throw new WalletManagementException("Failed to export Trustpoints");
                }
            }
            if (bl2) {
                byte[] byArray = x509Cert.getSignedCert();
                byte[] byArray2 = privateKey.getEncoded();
                String string = x509Cert.getSubjectName().toString();
                String string2 = super.getPasswd();
                this.debug("export_for_type: using nzclass to construct a wallet blob");
                if (byArray == null || byArray2 == null) {
                    throw new WalletManagementException("null key or cert for blob export");
                }
                this.debug("JavaWallet:export_for_type: Certificate=" + x509Cert.getSubjectName().toString());
                bl3 = nzclass.exportWallet(byArray, vector, byArray2, string2, string, this._exportpath);
            }
            ++n;
        }
    }

    private void debug(String string) {
    }

    public String NetGetDirectory() {
        return nzclass.NetGetDirectory();
    }
}

