/*
 * Decompiled with CFR 0.152.
 */
package oracle.network.security.nativelib;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Vector;
import oracle.network.security.nativelib.NZException;
import oracle.network.security.nativelib.NZIdentity;
import oracle.network.security.nativelib.NZPersona;
import oracle.security.rsa.RSAPrivateKey;
import oracle.security.rsa.RSAPublicKey;

public class NZNative {
    private byte[] oss_context;
    private static PrintStream os;

    public void init() throws NZException {
        this.nativeInitialize();
    }

    public void finalize() throws NZException {
    }

    public NZPersona getPersona() throws NZException {
        byte[] byArray = this.nativeGetPersona(this.oss_context);
        NZIdentity nZIdentity = this.getIdentity(this.nativeGetMyIdentPointer(byArray));
        int n = this.nativeGetPersonaCET(byArray);
        byte[] byArray2 = this.nativeGetPersonaPrivate(byArray);
        String string = this.nativeGetPersonaPRL(byArray);
        NZPersona nZPersona = new NZPersona(nZIdentity, null, n, byArray2, string);
        return nZPersona;
    }

    public KeyPair GenerateKeyPair(int n, SecureRandom secureRandom) {
        KeyPair keyPair;
        byte[] byArray = null;
        byte[] byArray2 = new byte[500];
        secureRandom.nextBytes(byArray2);
        byArray = this.nativeGenerateKeyPair(this.oss_context, n, byArray2);
        if (byArray != null) {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(this.nativeGetPublicKey(this.oss_context, byArray));
            RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(this.nativeGetPrivateKey(this.oss_context, byArray));
            keyPair = new KeyPair(rSAPublicKey, rSAPrivateKey);
        } else {
            keyPair = null;
        }
        return keyPair;
    }

    public byte[] signInit(PrivateKey privateKey, String string) {
        byte[] byArray = this.nativeSignInit(this.oss_context, privateKey.getEncoded(), string);
        return byArray;
    }

    public byte[] verifyInit(PublicKey publicKey, String string) {
        byte[] byArray = this.nativeVerifyInit(this.oss_context, publicKey.getEncoded(), string);
        return byArray;
    }

    public byte[] signFinal(byte[] byArray) {
        byte[] byArray2 = this.nativeSignFinal(this.oss_context, byArray);
        return byArray2;
    }

    public boolean verifyFinal(byte[] byArray, byte[] byArray2) {
        boolean bl = this.nativeVerifyFinal(this.oss_context, byArray, byArray2);
        return bl;
    }

    public void signUpdate(byte[] byArray, byte by) {
        byte[] byArray2 = new byte[]{by};
        this.nativeSignUpdate(this.oss_context, byArray, byArray2, 0, 1);
    }

    public void signUpdate(byte[] byArray, byte[] byArray2, int n, int n2) {
        this.nativeSignUpdate(this.oss_context, byArray, byArray2, n, n2);
    }

    public void verifyUpdate(byte[] byArray, byte by) {
        byte[] byArray2 = new byte[]{by};
        this.nativeVerifyUpdate(this.oss_context, byArray, byArray2, 0, 1);
    }

    public void verifyUpdate(byte[] byArray, byte[] byArray2, int n, int n2) {
        this.nativeVerifyUpdate(this.oss_context, byArray, byArray2, n, n2);
    }

    public byte[] pbe(byte[] byArray, String string) {
        int n = byArray.length;
        byte[] byArray2 = this.nativePbe(this.oss_context, byArray, n, string);
        return byArray2;
    }

    public byte[] pbd(byte[] byArray, String string) {
        int n = byArray.length;
        byte[] byArray2 = this.nativePbd(this.oss_context, byArray, n, string);
        return byArray2;
    }

    public boolean LDAPRetrieveWallet(String string, String string2) {
        boolean bl = this.nativeLDAPRetrieveWallet(this.oss_context, string, string2);
        return bl;
    }

    public boolean LDAPStoreWallet(byte[] byArray, Vector vector, byte[] byArray2, String string, String string2, String string3) {
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = vector.size();
        int[] nArray = new int[n3];
        Enumeration enumeration = vector.elements();
        int n4 = 0;
        byte[] byArray3 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while (enumeration.hasMoreElements()) {
                byArray3 = (byte[])enumeration.nextElement();
                byteArrayOutputStream.write(byArray3);
                nArray[n4] = byArray3.length;
                ++n4;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            return false;
        }
        boolean bl = this.nativeLDAPStoreWallet(this.oss_context, byArray, n, n3, nArray, byteArrayOutputStream.toByteArray(), byArray2, n2, string, string2, string3);
        return bl;
    }

    public boolean exportCert(byte[] byArray, String string) {
        int n = byArray.length;
        boolean bl = this.nativeExportCert(this.oss_context, byArray, n, string);
        return bl;
    }

    public boolean exportTrustpoints(Vector vector, String string, boolean bl, String string2) {
        int n = vector.size();
        int[] nArray = new int[n];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while (enumeration.hasMoreElements()) {
                byArray = (byte[])enumeration.nextElement();
                byteArrayOutputStream.write(byArray);
                nArray[n2] = byArray.length;
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            return false;
        }
        boolean bl2 = this.nativeExportTrustpoints(this.oss_context, n, nArray, byteArrayOutputStream.toByteArray(), string, bl, string2);
        return bl2;
    }

    public boolean exportPrivateKey(byte[] byArray, String string, String string2, String string3) {
        int n = byArray.length;
        boolean bl = this.nativeExportPrivateKey(this.oss_context, byArray, n, string, string2, string3);
        return bl;
    }

    public boolean exportWallet(byte[] byArray, Vector vector, byte[] byArray2, String string, String string2, String string3) {
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = vector.size();
        int[] nArray = new int[n3];
        Enumeration enumeration = vector.elements();
        int n4 = 0;
        byte[] byArray3 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.debug("ENTER: oracle.network.security.nativelib.exportWallet");
        try {
            while (enumeration.hasMoreElements()) {
                byArray3 = (byte[])enumeration.nextElement();
                byteArrayOutputStream.write(byArray3);
                nArray[n4] = byArray3.length;
                ++n4;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            return false;
        }
        boolean bl = this.nativeExportWallet(this.oss_context, byArray, n, n3, nArray, byteArrayOutputStream.toByteArray(), byArray2, n2, string, string2, string3);
        return bl;
    }

    public byte[] initCert(byte[] byArray) throws NZException {
        byte[] byArray2 = this.nativeInitCert(this.oss_context, byArray);
        if (byArray2 == null) {
            throw new NZException("null certctx");
        }
        return byArray2;
    }

    public byte[] getCertIssuerNameEncode(byte[] byArray) {
        byte[] byArray2 = this.nativeGetCertIssuerNameEncode(this.oss_context, byArray);
        return byArray2;
    }

    public byte[] getCertSubjectNameEncode(byte[] byArray) {
        byte[] byArray2 = this.nativeGetCertSubjectNameEncode(this.oss_context, byArray);
        return byArray2;
    }

    private NZIdentity getIdentity(byte[] byArray) throws NZException {
        String string = this.nativeGetIdentityAlias(byArray);
        String string2 = this.nativeGetIdentityComment(byArray);
        int n = this.nativeGetIdentityIType(byArray);
        int n2 = this.nativeGetIdentityCType(byArray);
        int n3 = this.nativeGetIdentityState(byArray);
        byte[] byArray2 = this.nativeGetIdentityLast(byArray);
        String string3 = this.nativeGetIdentityTrustQual(byArray);
        byte[] byArray3 = this.nativeGetIdentity(byArray);
        NZIdentity nZIdentity = new NZIdentity(string, string2, n, n2, n3, byArray2, string3, byArray3);
        return nZIdentity;
    }

    public byte[] getExtensionsInfo(byte[] byArray) {
        return this.nativeGetExtensionsInfo(this.oss_context, byArray);
    }

    public byte[] get_ExpDate(byte[] byArray) {
        return this.nativeGetExpDateComment(this.oss_context, byArray);
    }

    public boolean dercert_to_B64(byte[] byArray, String string) {
        String string2 = "file:" + string;
        boolean bl = this.nativedercertToB64(this.oss_context, byArray, string2);
        return bl;
    }

    public String NetGetDirectory() {
        String string = this.getNativeDirectory();
        return string;
    }

    private void debug(String string) {
    }

    private native void nativeInitialize();

    private native byte[] nativeGetPersona(byte[] var1) throws NZException;

    private native byte[] nativeGetMyIdentPointer(byte[] var1) throws NZException;

    private native int nativeGetNumIdents(byte[] var1) throws NZException;

    private native byte[] nativeGetIdentPointer(byte[] var1, int var2) throws NZException;

    private native String nativeGetIdentityAlias(byte[] var1) throws NZException;

    private native String nativeGetIdentityComment(byte[] var1) throws NZException;

    private native int nativeGetIdentityIType(byte[] var1) throws NZException;

    private native int nativeGetIdentityCType(byte[] var1) throws NZException;

    private native int nativeGetIdentityState(byte[] var1) throws NZException;

    private native byte[] nativeGetIdentityLast(byte[] var1) throws NZException;

    private native String nativeGetIdentityTrustQual(byte[] var1) throws NZException;

    private native byte[] nativeGetIdentity(byte[] var1) throws NZException;

    private native int nativeGetPersonaCET(byte[] var1) throws NZException;

    private native byte[] nativeGetPersonaPrivate(byte[] var1) throws NZException;

    private native String nativeGetPersonaPRL(byte[] var1) throws NZException;

    private native byte[] nativeGenerateKeyPair(byte[] var1, int var2, byte[] var3);

    private native byte[] nativeGetPublicKey(byte[] var1, byte[] var2);

    private native byte[] nativeGetPrivateKey(byte[] var1, byte[] var2);

    private native byte[] nativeSignInit(byte[] var1, byte[] var2, String var3);

    private native byte[] nativeSignFinal(byte[] var1, byte[] var2);

    private native void nativeSignUpdate(byte[] var1, byte[] var2, byte[] var3, int var4, int var5);

    private native void nativeVerifyUpdate(byte[] var1, byte[] var2, byte[] var3, int var4, int var5);

    private native byte[] nativeVerifyInit(byte[] var1, byte[] var2, String var3);

    private native boolean nativeVerifyFinal(byte[] var1, byte[] var2, byte[] var3);

    private native String getNativeDirectory();

    private native byte[] nativePbe(byte[] var1, byte[] var2, int var3, String var4);

    private native byte[] nativePbd(byte[] var1, byte[] var2, int var3, String var4);

    private native boolean nativeLDAPRetrieveWallet(byte[] var1, String var2, String var3);

    private native boolean nativeLDAPStoreWallet(byte[] var1, byte[] var2, int var3, int var4, int[] var5, byte[] var6, byte[] var7, int var8, String var9, String var10, String var11);

    private native boolean nativeExportCert(byte[] var1, byte[] var2, int var3, String var4);

    private native boolean nativeExportTrustpoints(byte[] var1, int var2, int[] var3, byte[] var4, String var5, boolean var6, String var7);

    private native boolean nativeExportPrivateKey(byte[] var1, byte[] var2, int var3, String var4, String var5, String var6);

    private native boolean nativeExportWallet(byte[] var1, byte[] var2, int var3, int var4, int[] var5, byte[] var6, byte[] var7, int var8, String var9, String var10, String var11);

    private native byte[] nativeInitCert(byte[] var1, byte[] var2);

    private native byte[] nativeGetCertIssuerNameEncode(byte[] var1, byte[] var2);

    private native byte[] nativeGetCertSubjectNameEncode(byte[] var1, byte[] var2);

    private native byte[] nativeGetExtensionsInfo(byte[] var1, byte[] var2);

    private native byte[] nativeGetExpDateComment(byte[] var1, byte[] var2);

    private native boolean nativedercertToB64(byte[] var1, byte[] var2, String var3);

    public static void main(String[] stringArray) {
        NZNative nZNative = new NZNative();
        NZPersona nZPersona = null;
        try {
            nZNative.init();
            nZPersona = nZNative.getPersona();
        }
        catch (Exception exception) {
            os.println("Caught exception: " + exception.toString());
        }
        System.exit(0);
    }

    static {
        System.loadLibrary("nzj");
        os = System.out;
    }
}

