/*
 * Decompiled with CFR 0.152.
 */
package oracle.network.security.streams;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.network.security.nativelib.NZNative;

public class WalletDecrypt {
    private InputStream myStream;
    private ByteArrayOutputStream myByteOutStream;
    private String myPasswd;
    private static boolean initnz;
    private static NZNative nzclass;

    private static final void initNZ() {
        if (!initnz) {
            nzclass = new NZNative();
            try {
                nzclass.init();
                initnz = true;
                return;
            }
            catch (Exception exception) {
                System.out.println("Caught exception: " + exception.toString());
                return;
            }
        }
    }

    public WalletDecrypt(InputStream inputStream, String string) {
        WalletDecrypt.initNZ();
        this.myStream = inputStream;
        this.myPasswd = string;
        this.myByteOutStream = new ByteArrayOutputStream();
    }

    public byte[] decrypt() throws IOException {
        int n = this.myStream.read();
        while (n != -1) {
            this.myByteOutStream.write(n);
            n = this.myStream.read();
        }
        this.myByteOutStream.flush();
        byte[] byArray = this.myByteOutStream.toByteArray();
        ((OutputStream)this.myByteOutStream).close();
        byte[] byArray2 = nzclass.pbd(byArray, this.myPasswd);
        return byArray2;
    }
}

