/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.rsa;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import oracle.network.security.nativelib.NZNative;

public class MD5RSASignature
extends Signature {
    private byte[] hash;
    private static NZNative nzclass;
    private byte[] algobj;

    public MD5RSASignature() {
        super(new String("MD5/RSA"));
        this.state = 0;
        nzclass = new NZNative();
        try {
            nzclass.init();
            return;
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception.toString());
            return;
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return new Object();
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.state = 2;
        this.algobj = nzclass.signInit(privateKey, new String("MD5/RSA"));
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.state = 3;
        this.algobj = nzclass.verifyInit(publicKey, new String("MD5/RSA"));
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        boolean bl = nzclass.verifyFinal(this.algobj, byArray);
        return bl;
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = nzclass.signFinal(this.algobj);
        return byArray;
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (this.state == 2) {
            nzclass.signUpdate(this.algobj, by);
            return;
        }
        if (this.state == 3) {
            nzclass.verifyUpdate(this.algobj, by);
            return;
        }
        throw new SignatureException("state is invalid");
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state == 2) {
            nzclass.signUpdate(this.algobj, byArray, n, n2);
            return;
        }
        if (this.state == 3) {
            nzclass.verifyUpdate(this.algobj, byArray, n, n2);
            return;
        }
        throw new SignatureException("state is invalid");
    }
}

