/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.rsa;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import oracle.network.security.nativelib.NZNative;

public class RSAKeyPairGenerator
extends KeyPairGenerator
implements oracle.security.interfaces.RSAKeyPairGenerator {
    int length;
    SecureRandom random;
    KeyPair pair;
    private NZNative nzclass;

    public RSAKeyPairGenerator() {
        super("RSA");
    }

    public void initialize(int n, BigInteger bigInteger, SecureRandom secureRandom) {
        this.length = n;
        this.random = secureRandom;
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.length = n;
        this.random = secureRandom;
    }

    public KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        this.nzclass = new NZNative();
        try {
            this.nzclass.init();
            keyPair = this.nzclass.GenerateKeyPair(this.length, this.random);
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception.toString());
        }
        return keyPair;
    }
}

