/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Certificate;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Date;
import oracle.network.security.nativelib.NZNative;
import sun.security.util.DerInputStream;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class X509Cert
extends sun.security.x509.X509Cert
implements Certificate,
Serializable {
    private String cert_desc;
    private int hash;
    private int version;
    private PublicKey pkey;
    private Date exp_time;
    private Date start_time;
    private AlgorithmId issuer_alg_id;
    private transient X500Name issuer_name;
    private transient X500Name subject_name;
    private BigInteger serial_number;
    private byte[] der_cert;
    private static NZNative nzclass;

    public X509Cert() {
        nzclass = new NZNative();
        try {
            nzclass.init();
            return;
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception.toString());
            return;
        }
    }

    public X509Cert(byte[] byArray, int n, int n2) throws IOException {
        this.der_cert = new byte[n2];
        int n3 = n;
        while (n3 < n2) {
            this.der_cert[n3] = byArray[n3];
            ++n3;
        }
        super.decode((InputStream)new ByteArrayInputStream(this.der_cert));
    }

    public void decode(InputStream inputStream) throws IOException {
        try {
            super.decode(inputStream);
            this.der_cert = super.getSignedCert();
            if (nzclass == null) {
                nzclass = new NZNative();
                try {
                    nzclass.init();
                }
                catch (Exception exception) {
                    System.out.println("Caught exception: " + exception.toString());
                }
            }
            this.parseCert();
            return;
        }
        catch (Exception exception) {
            System.out.println("Decode Exception caught " + exception.toString());
            exception.printStackTrace();
            throw new IOException("Decode failed");
        }
    }

    public String getFormat() {
        return new String("X.509");
    }

    public Principal getGuarantor() {
        return this.getIssuerName();
    }

    public Principal getPrincipal() {
        return this.getSubjectName();
    }

    public byte[] getSignedCert() {
        return (byte[])this.der_cert.clone();
    }

    public X500Name getSubjectName() {
        return this.subject_name;
    }

    public X500Name getIssuerName() {
        return this.issuer_name;
    }

    public String getExtensionsInfo() {
        byte[] byArray = nzclass.getExtensionsInfo(this.der_cert);
        return new String(byArray);
    }

    public String getExpDate() {
        byte[] byArray = nzclass.get_ExpDate(this.der_cert);
        return new String(byArray);
    }

    public boolean dercertToB64(String string) {
        boolean bl = nzclass.dercert_to_B64(this.der_cert, string);
        return bl;
    }

    private void parseCert() throws IOException {
        byte[] byArray = null;
        try {
            byArray = nzclass.initCert(this.der_cert);
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception.toString());
            throw new IOException("Initialize failed");
        }
        try {
            DerInputStream derInputStream = new DerInputStream(nzclass.getCertIssuerNameEncode(byArray));
            this.issuer_name = new X500Name(derInputStream);
            derInputStream = new DerInputStream(nzclass.getCertSubjectNameEncode(byArray));
            this.subject_name = new X500Name(derInputStream);
            return;
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception.toString());
            return;
        }
    }
}

