/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;
import sun.security.x509.RDN;
import sun.security.x509.X500Name;

public class X500NameImproved
extends X500Name {
    protected String DN;
    protected RDN[] nameAttrs;
    public static final String CN = "cn";
    public static final String OU = "ou";
    public static final String O = "o";
    public static final String L = "l";
    public static final String ST = "ST";
    public static final String C = "c";

    public X500NameImproved(String string, Properties properties) throws IOException {
        super("boo", "boo", "boo", "boo");
        if (string == null || string.trim().length() == 0) {
            throw new IOException("Missing common name attribute !");
        }
        int n = 0;
        n = properties != null ? ((Hashtable)properties).size() + 1 : 1;
        int n2 = n - 1;
        this.nameAttrs = new RDN[n];
        this.nameAttrs[n2] = new RDN(1);
        this.nameAttrs[n2].assertion[0] = new AVA(X500Name.commonName_oid, new DerValue(string));
        --n2;
        if (properties.getProperty(OU) != null) {
            this.nameAttrs[n2] = new RDN(1);
            this.nameAttrs[n2].assertion[0] = new AVA(X500Name.orgUnitName_oid, new DerValue(properties.getProperty(OU)));
            --n2;
        }
        if (properties.getProperty(O) != null) {
            this.nameAttrs[n2] = new RDN(1);
            this.nameAttrs[n2].assertion[0] = new AVA(X500Name.orgName_oid, new DerValue(properties.getProperty(O)));
            --n2;
        }
        if (properties.getProperty(L) != null) {
            this.nameAttrs[n2] = new RDN(1);
            this.nameAttrs[n2].assertion[0] = new AVA(X500Name.localityName_oid, new DerValue(properties.getProperty(L)));
            --n2;
        }
        if (properties.getProperty(ST) != null) {
            this.nameAttrs[n2] = new RDN(1);
            this.nameAttrs[n2].assertion[0] = new AVA(X500Name.stateName_oid, new DerValue(properties.getProperty(ST)));
            --n2;
        }
        if (properties.getProperty(C) != null) {
            this.nameAttrs[n2] = new RDN(1);
            this.nameAttrs[n2].assertion[0] = new AVA(X500Name.countryName_oid, new DerValue(properties.getProperty(C)));
            --n2;
        }
    }

    public X500NameImproved(DerValue derValue) throws IOException {
        this(derValue.toDerInputStream());
    }

    public X500NameImproved(DerInputStream derInputStream) throws IOException {
        super("boo", "boo", "boo", "boo");
        this.parseDER2(derInputStream);
    }

    public boolean equals(X500Name x500Name) {
        System.out.println("X500Name.equals being used !");
        if (this == x500Name) {
            return true;
        }
        if (this.DN == null) {
            this.generateDN2();
        }
        try {
            if (this.nameAttrs.length != ((X500NameImproved)x500Name).nameAttrs.length) {
                return false;
            }
            int n = 0;
            while (n < this.nameAttrs.length) {
                if (!this.nameAttrs[n].equals(((X500NameImproved)x500Name).nameAttrs[n])) {
                    return false;
                }
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            System.out.println(classCastException);
            return false;
        }
        return true;
    }

    private String getString2(DerValue derValue) throws IOException {
        String string = derValue.getAsString();
        if (string == null) {
            throw new IOException("not a DER string encoding, " + derValue.tag);
        }
        return string;
    }

    public String getCountry() throws IOException {
        DerValue derValue = this.findAttribute2(X500Name.countryName_oid);
        return this.getString2(derValue);
    }

    public String getOrganization() throws IOException {
        DerValue derValue = this.findAttribute2(X500Name.orgName_oid);
        return this.getString2(derValue);
    }

    public String getOrganizationalUnit() throws IOException {
        DerValue derValue = this.findAttribute2(X500Name.orgUnitName_oid);
        return this.getString2(derValue);
    }

    public String getCommonName() throws IOException {
        DerValue derValue = this.findAttribute2(X500Name.commonName_oid);
        return this.getString2(derValue);
    }

    public String getLocality() throws IOException {
        DerValue derValue = this.findAttribute2(X500Name.localityName_oid);
        return this.getString2(derValue);
    }

    public String getState() throws IOException {
        DerValue derValue = this.findAttribute2(X500Name.stateName_oid);
        return this.getString2(derValue);
    }

    public String toString() {
        if (this.DN == null) {
            this.generateDN2();
        }
        return this.DN;
    }

    public String getName() {
        return this.toString();
    }

    private DerValue findAttribute2(ObjectIdentifier objectIdentifier) {
        DerValue derValue = null;
        int n = 0;
        while (n < this.nameAttrs.length) {
            derValue = this.nameAttrs[n].findAttribute(objectIdentifier);
            if (derValue != null) break;
            ++n;
        }
        return derValue;
    }

    private void parseDER2(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSequence(5);
        this.nameAttrs = new RDN[derValueArray.length];
        int n = 0;
        while (n < derValueArray.length) {
            this.nameAttrs[n] = new RDN(derValueArray[n]);
            ++n;
        }
    }

    public void emit(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n = 0;
        while (n < this.nameAttrs.length) {
            this.nameAttrs[n].emit(derOutputStream2);
            ++n;
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    private void generateDN2() {
        String string = null;
        int n = this.nameAttrs.length - 1;
        while (n >= 0) {
            string = string == null ? this.nameAttrs[n].toString() : ", " + this.nameAttrs[n].toString();
            --n;
        }
        this.DN = string;
    }
}

