/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.io.Serializable;
import symantec.itools.awt.CompareFunc;
import symantec.itools.awt.CompareFuncCB;
import symantec.itools.awt.MatrixEnumeration;

public final class Matrix
implements Serializable {
    Matrix rowHead;
    Matrix nextRow;
    Matrix nextElt;
    int row;
    int col;
    Object o;

    public Matrix() {
        this.rowHead = this;
    }

    private Matrix(int r, int c, Object obj) {
        this(r, c, obj, null);
    }

    private Matrix(int r, int c, Object obj, Matrix rh, Matrix nr, Matrix ne) {
        this.rowHead = rh == null ? (c != 0 ? new Matrix(r, 0, null, null, nr, this) : this) : rh;
        this.row = r;
        this.col = c;
        this.o = obj;
        this.nextRow = nr;
        this.nextElt = ne;
    }

    private Matrix(int r, int c, Object obj, Matrix nr, Matrix ne) {
        this(r, c, obj, null, nr, ne);
    }

    private Matrix(int r, int c, Object obj, Matrix nr) {
        this(r, c, obj, null, nr, null);
    }

    public synchronized void addElement(int r, int c, Object o) throws IllegalArgumentException {
        Matrix m = this.nearest(r, c);
        if (m.row != r) {
            m.setNextRow(new Matrix((int)r, (int)c, (Object)o, (Matrix)m.nextRow).rowHead);
            return;
        }
        if (c == m.col && c == 0) {
            if (m.o != null) {
                throw new IllegalArgumentException("Element already in Matrix");
            }
            m.o = o;
            return;
        }
        m.nextElt = new Matrix(r, c, o, m.rowHead, m.nextRow, m.nextElt);
    }

    public synchronized void updateElement(int r, int c, Object obj) {
        Matrix m = this.nearest(r, c);
        try {
            if (m == null) {
                this.addElement(r, c, obj);
            } else if (m.row != r || m.col != c) {
                m.addElement(r, c, obj);
            } else {
                m.o = obj;
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
    }

    public synchronized void removeAllElements() {
        this.nextRow = null;
        this.nextElt = null;
        this.o = null;
    }

    public synchronized Object elementAt(int r, int c) throws ArrayIndexOutOfBoundsException {
        Matrix m = this.nearest(r, c);
        if (m == null || m.row != r || m.col != c || m.o == null) {
            throw new ArrayIndexOutOfBoundsException("Element row=" + r + " col=" + c + " is not in matrix");
        }
        return m.o;
    }

    public synchronized void removeElementAt(int r, int c) throws ArrayIndexOutOfBoundsException {
        Matrix m = this.nearest(r, c);
        if (m == null || m.row != r || m.col != c) {
            throw new ArrayIndexOutOfBoundsException("Element row=" + r + " col=" + c + " is not in matrix");
        }
        if (c == 0) {
            m.o = null;
            return;
        }
        Matrix prev = m = m.rowHead;
        while (m.col != c) {
            prev = m;
            m = m.nextElt;
        }
        prev.nextElt = m.nextElt;
    }

    public synchronized void removeRow(int r) {
        block7: {
            block6: {
                if (r != 0) break block6;
                this.o = null;
                this.nextElt = null;
                if (this.nextRow == null) break block7;
                Matrix newZeroElem = this.nextRow;
                this.nextRow = newZeroElem.nextRow;
                this.nextElt = newZeroElem.nextElt;
                this.row = newZeroElem.row;
                this.col = newZeroElem.col;
                this.o = newZeroElem.o;
                Matrix elemMatrix = this.nextElt;
                while (elemMatrix != null) {
                    elemMatrix.rowHead = this;
                    elemMatrix = elemMatrix.nextElt;
                }
                Matrix stepMatrix = this;
                while (stepMatrix != null) {
                    stepMatrix.updateRowNum(stepMatrix.row - 1);
                    stepMatrix = stepMatrix.nextRow;
                }
                break block7;
            }
            Matrix stepMatrix = this.nextRow;
            Matrix lastRow = this;
            while (stepMatrix != null && stepMatrix.row < r) {
                lastRow = stepMatrix;
                stepMatrix = stepMatrix.nextRow;
            }
            if (stepMatrix != null) {
                if (stepMatrix.row == r) {
                    lastRow.nextRow = stepMatrix.nextRow;
                    stepMatrix.o = null;
                    stepMatrix.nextElt = null;
                    stepMatrix = stepMatrix.nextRow;
                }
                while (stepMatrix != null) {
                    stepMatrix.updateRowNum(stepMatrix.row - 1);
                    stepMatrix = stepMatrix.nextRow;
                }
            }
        }
    }

    public synchronized void insertRow(int r) {
        Matrix m;
        if (r == 0) {
            m = new Matrix();
            m.setNextRow(this);
        } else {
            m = this.nearest(r - 1, 0);
            Matrix n = new Matrix(r, 0, null, m.nextRow);
            m.setNextRow(n);
            m = n;
        }
        if (m.nextRow.row == r) {
            m = m.nextRow;
            while (m != null) {
                m.updateRowNum(++r);
                m = m.nextRow;
                if (m == null || m.row == r) continue;
                return;
            }
        }
    }

    public synchronized void sort(CompareFunc f, int c) {
        boolean first = true;
        Matrix m = this;
        Matrix n = null;
        while (m != null) {
            n = this.findLeast(f, m, c, first);
            if (n != null) {
                if (m.row == 0 && first) {
                    first = false;
                    if (f instanceof CompareFuncCB) {
                        ((CompareFuncCB)f).callBackSwap(m, n.nextRow);
                    }
                    this.swapRows(n);
                    m = this;
                    continue;
                }
                if (f instanceof CompareFuncCB) {
                    ((CompareFuncCB)f).callBackSwap(m.nextRow, n.nextRow);
                }
                this.swapRows(m, n);
            }
            if (first) {
                first = false;
                continue;
            }
            m = m.nextRow;
        }
    }

    public synchronized void printRow(int r) {
        Matrix m = this.nearest(r, 0);
        if (m.row != r) {
            m = m.nextRow;
            if (m.row != r) {
                System.out.println("Row " + r + " is not in the matrix");
                return;
            }
        }
        System.out.println("-------- Printing row " + r + " ----------");
        while (m != null) {
            System.out.println("Row=" + m.row + "  Col=" + m.col + "  value=" + m.o);
            m = m.nextElt;
        }
    }

    public synchronized int rows() {
        Matrix m = this;
        while (m.nextRow != null) {
            m = m.nextRow;
        }
        return m.nextElt == null && m.o == null ? m.row : m.row + 1;
    }

    private synchronized void updateRowNum(int r) {
        Matrix m = this;
        while (m != null) {
            m.row = r;
            m = m.nextElt;
        }
    }

    public synchronized MatrixEnumeration elements() {
        return new MatrixEnumeration(this);
    }

    public synchronized String toString() {
        return "Matrix: row=" + this.row + " col=" + this.col + " o=" + this.o;
    }

    private synchronized Matrix nearest(int r, int c) {
        Matrix m = this;
        while (r > m.row) {
            if (m.nextRow != null && m.nextRow.row <= r) {
                m = m.nextRow;
                continue;
            }
            return m;
        }
        while (m.nextElt != null && c >= m.nextElt.col) {
            m = m.nextElt;
        }
        return m;
    }

    private synchronized void setRowHead() {
        Matrix m = this.nextElt;
        Matrix h = this;
        while (m != null) {
            m.rowHead = h;
            m = m.nextElt;
        }
    }

    private synchronized void setNextRow(Matrix nr) {
        Matrix m = this;
        while (m != null) {
            m.nextRow = nr;
            m = m.nextElt;
        }
    }

    private synchronized void swapRows(Matrix p1, Matrix p2) {
        Matrix t1 = p1.nextRow;
        Matrix t1NextRow = t1.nextRow;
        Matrix t2 = p2.nextRow;
        Matrix t2NextRow = t2.nextRow;
        p1.setNextRow(t2);
        p2.setNextRow(t1);
        if (p2 == t1) {
            t2.setNextRow(t1);
        } else {
            t2.setNextRow(t1NextRow);
        }
        t1.setNextRow(t2NextRow);
        int t1Row = t1.row;
        t1.updateRowNum(t2.row);
        t2.updateRowNum(t1Row);
    }

    private synchronized void swapRows(Matrix m2) {
        Matrix t2 = m2.nextRow;
        Matrix t1 = new Matrix(-1, t2.col, this.o, null, this.nextElt);
        m2.rowHead.setNextRow(t1);
        t1.setNextRow(t2.nextRow);
        t1.updateRowNum(t2.row);
        t1.setRowHead();
        this.nextElt = t2.nextElt;
        this.o = t2.o;
        this.setNextRow(this.nextRow);
        this.updateRowNum(0);
        this.setRowHead();
    }

    private synchronized Matrix findLeast(CompareFunc f, Matrix m, int c, boolean first) {
        if (!first) {
            m = m.nextRow;
        }
        if (m == null || m.nextRow == null) {
            return null;
        }
        Matrix n = m.nextRow.rowHead;
        Matrix prevToN = m.rowHead;
        Matrix prevToLeast = null;
        m = m.nearest(m.row, c);
        while (n != null) {
            n = n.nearest(n.row, c);
            if (n.col != c) {
                prevToN = n.rowHead;
                n = n.nextRow;
                continue;
            }
            if (m.col != c) {
                m = n;
                prevToLeast = prevToN;
                continue;
            }
            if (f.lessThan(n.o, m.o)) {
                m = n;
                prevToLeast = prevToN;
            }
            prevToN = n.rowHead;
            n = n.nextRow;
        }
        return prevToLeast;
    }
}

