/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import oracle.help.Book;
import oracle.help.search.QueryObject;
import oracle.help.util.OhtParser;
import oracle.help.util.SitemapParser;
import oracle.help.util.TOCParser;
import oracle.help.util.TreeRoot;

public class HelpBook
implements Book {
    private String _baseURL;
    private String _baseName;
    private String _title;
    private Object _hhcTree;
    private Object _hhkTree;
    private Object _queryObject;
    private Object _ohtHashtable;
    private boolean _visible = false;
    private Boolean _hhcFlag;
    private Boolean _hhkFlag;
    private Boolean _ohtFlag;
    private boolean _containsToc;
    private boolean _containsIndex;
    private boolean _containsSearch;
    private static Vector _books = null;

    public static HelpBook getBook(URL uRL, String string, String string2) {
        return HelpBook.getBook(uRL.toString(), string, string2);
    }

    public static HelpBook getBook(String string, String string2, String string3) {
        InputStream inputStream;
        URL uRL;
        HelpBook helpBook;
        int n;
        if (_books == null) {
            _books = new Vector(1);
        }
        if ((n = _books.indexOf(helpBook = new HelpBook(string, string2, string3))) == -1) {
            _books.addElement(helpBook);
        } else {
            helpBook = (HelpBook)_books.elementAt(n);
        }
        try {
            uRL = new URL(String.valueOf(string) + string2 + ".toc");
            inputStream = uRL.openStream();
            inputStream.close();
            helpBook._containsToc = true;
        }
        catch (Exception exception) {
            try {
                uRL = new URL(String.valueOf(string) + string2 + ".hhc");
                inputStream = uRL.openStream();
                inputStream.close();
                helpBook._containsToc = true;
            }
            catch (Exception exception2) {
                helpBook._containsToc = false;
            }
        }
        try {
            uRL = new URL(String.valueOf(string) + string2 + ".tok");
            inputStream = uRL.openStream();
            inputStream.close();
            helpBook._containsIndex = true;
        }
        catch (Exception exception) {
            try {
                uRL = new URL(String.valueOf(string) + string2 + ".hhk");
                inputStream = uRL.openStream();
                inputStream.close();
                helpBook._containsIndex = true;
            }
            catch (Exception exception3) {
                helpBook._containsIndex = false;
            }
        }
        try {
            uRL = new URL(String.valueOf(string) + string2 + ".idx");
            inputStream = uRL.openStream();
            inputStream.close();
            helpBook._containsSearch = true;
        }
        catch (Exception exception) {
            helpBook._containsSearch = false;
        }
        return helpBook;
    }

    public static synchronized void removeBook(HelpBook helpBook) {
        _books.removeElement(helpBook);
    }

    public boolean containsToc() {
        return this._containsToc;
    }

    public boolean containsIndex() {
        return this._containsIndex;
    }

    public boolean containsSearch() {
        return this._containsSearch;
    }

    public static synchronized void removeAllBooks() {
        _books.removeAllElements();
    }

    public Object getHhcTree() {
        if (!this._containsToc) {
            return null;
        }
        if (this._hhcTree != null) {
            return this._hhcTree;
        }
        Boolean bl = this._hhcFlag;
        synchronized (bl) {
            if (this._hhcTree != null) {
                Object object = this._hhcTree;
                Object var3_4 = null;
                return object;
            }
            TOCParser tOCParser = new TOCParser();
            try {
                this._hhcTree = tOCParser.parseTOC(this._baseURL, String.valueOf(this._baseName) + ".toc", true);
            }
            catch (Exception exception) {
                SitemapParser sitemapParser = new SitemapParser();
                try {
                    this._hhcTree = sitemapParser.parseHhc(this._baseURL, String.valueOf(this._baseName) + ".hhc", true);
                }
                catch (Exception exception2) {
                    this._hhcTree = null;
                    Object var1_3 = null;
                    Object var3_5 = null;
                    return var1_3;
                }
            }
            ((TreeRoot)this._hhcTree).setBook(this);
            ((TreeRoot)this._hhcTree).setLabel(this._title);
        }
        return this._hhcTree;
    }

    public Object getHhkTree() {
        if (!this._containsIndex) {
            return null;
        }
        if (this._hhkTree != null) {
            return this._hhkTree;
        }
        Boolean bl = this._hhkFlag;
        synchronized (bl) {
            if (this._hhkTree != null) {
                Object object = this._hhkTree;
                Object var3_4 = null;
                return object;
            }
            TOCParser tOCParser = new TOCParser();
            try {
                this._hhkTree = tOCParser.parseTOK(this._baseURL, String.valueOf(this._baseName) + ".tok");
            }
            catch (Exception exception) {
                SitemapParser sitemapParser = new SitemapParser();
                try {
                    this._hhkTree = sitemapParser.parseHhk(this._baseURL, String.valueOf(this._baseName) + ".hhk");
                }
                catch (Exception exception2) {
                    this._hhkTree = null;
                    Object var1_3 = null;
                    Object var3_5 = null;
                    return var1_3;
                }
            }
            ((TreeRoot)this._hhkTree).setBook(this);
        }
        return this._hhkTree;
    }

    public synchronized Object getQueryObject() {
        if (!this._containsSearch) {
            return null;
        }
        if (this._queryObject != null) {
            return this._queryObject;
        }
        String string = String.valueOf(this._baseURL.toString()) + this._baseName + ".idx";
        try {
            this._queryObject = QueryObject.getQueryObject(new URL(string));
        }
        catch (Exception exception) {}
        return this._queryObject;
    }

    public Object getTopicsHashtable() {
        if (this._ohtHashtable != null) {
            return this._ohtHashtable;
        }
        Boolean bl = this._ohtFlag;
        synchronized (bl) {
            if (this._ohtHashtable != null) {
                Object object = this._ohtHashtable;
                Object var3_3 = null;
                return object;
            }
            String string = String.valueOf(this._baseURL.toString()) + this._baseName + ".oht";
            try {
                this._ohtHashtable = OhtParser.getTopicsHashtable(new URL(string));
            }
            catch (Exception exception) {}
        }
        return this._ohtHashtable;
    }

    public void setVisible(boolean bl) {
        this._visible = bl;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public boolean isInitialized() {
        return this._ohtHashtable != null && this._hhcTree != null && this._hhkTree != null;
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.getHhcTree();
        this.getHhkTree();
        this.getTopicsHashtable();
    }

    protected HelpBook(String string, String string2, String string3) {
        this._baseURL = string;
        this._baseName = string2;
        this._title = string3;
        this._hhcFlag = new Boolean(false);
        this._hhkFlag = new Boolean(false);
        this._ohtFlag = new Boolean(false);
    }

    public String getBaseURL() {
        return this._baseURL;
    }

    public String getBaseName() {
        return this._baseName;
    }

    public String getTitle() {
        return this._title;
    }

    public boolean equals(Object object) {
        HelpBook helpBook = (HelpBook)object;
        return helpBook._baseURL.equals(this._baseURL) && helpBook._baseName.equals(this._baseName) && helpBook._title.equals(this._title);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("HelpBook baseUrlString baseName");
            System.exit(0);
        }
        try {
            URL uRL = new URL(stringArray[0]);
            HelpBook helpBook = HelpBook.getBook(uRL.toString(), stringArray[1], "Hello");
            System.out.println("getting the hhc tree");
            helpBook.getHhcTree();
            System.out.println("getting the hhk tree");
            helpBook.getHhkTree();
            System.out.println("getting the QueryObject");
            helpBook.getQueryObject();
            System.out.println("getting the Oht object");
            helpBook.getTopicsHashtable();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

