/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.navigator.SearchDialog;
import oracle.help.topicWindow.DocumentStack;
import oracle.help.topicWindow.DocumentStackEvent;
import oracle.help.topicWindow.DocumentStackListener;
import oracle.help.util.MenuDefs;

public final class QuickTourWindow
extends Frame {
    HTMLBrowser _htmlBrowser;
    DocumentStack _stack;
    SearchDialog _searchDialog;
    URL _frontpage;
    String _indexFile;
    URL _baseUrl;
    MenuBar _menubar;
    MenuItem _printMenuItem;
    MenuItem _closeMenuItem;
    MenuItem _backMenuItem;
    MenuItem _forwardMenuItem;
    MenuItem _searchMenuItem;
    private static final int DEFAULT_WIDTH = 675;
    private static final int DEFAULT_HEIGHT = 530;
    static String[] FILE_LABELS = new String[]{"File", "PrintTopic", "-", "Close"};
    static final int FILE_PRINT_INDEX = 0;
    static final int FILE_CLOSE_INDEX = 2;
    static String[] GO_LABELS = new String[]{"Go", "Back", "Forward"};
    static final int GO_BACK_INDEX = 0;
    static final int GO_FORWARD_INDEX = 1;
    static String[] TOOLS_LABELS = new String[]{"Tools", "Search"};
    static final int TOOLS_SEARCH_INDEX = 0;

    public QuickTourWindow() {
        try {
            this._initQuickTourWindow(Class.forName("oracle.help.htmlBrowser.HotJavaBrowser"));
            return;
        }
        catch (Exception exception) {
            System.out.println("failed to initialize HotJavaBrowser");
            return;
        }
    }

    public QuickTourWindow(Class clazz) {
        this._initQuickTourWindow(clazz);
    }

    public void setFrontpage(URL uRL) {
        this._frontpage = uRL;
        try {
            int n = this._frontpage.toString().lastIndexOf("/");
            if (n == -1) {
                n = this._frontpage.toString().lastIndexOf("\\");
            }
            if (n != -1) {
                this._baseUrl = new URL(this._frontpage.toString().substring(0, n + 1));
                return;
            }
        }
        catch (Exception exception) {
            this._baseUrl = null;
        }
    }

    public final void setFrontpage(Class clazz, String string) {
        try {
            this.setFrontpage(clazz.getResource(string));
            return;
        }
        catch (Exception exception) {
            this._frontpage = null;
            System.err.println("QuickTourWindow : failed in setFrontpage()");
            return;
        }
    }

    public URL getFrontpage() {
        return this._frontpage;
    }

    public void setIndexFile(String string) {
        this._indexFile = string;
    }

    public String getIndexFile() {
        return this._indexFile;
    }

    public void show() {
        if (this._frontpage != null) {
            this._stack.setURL(null, this._frontpage);
        }
        super.show();
    }

    public void showSearchDialog() {
        if (this._searchDialog == null) {
            this._searchDialog = new SearchDialog(this._htmlBrowser, this._baseUrl, this._indexFile);
        }
        ((Component)((Object)this._searchDialog)).setLocation(this.getLocation().x + 100, this.getLocation().y + 100);
        this._searchDialog.setVisible(true);
    }

    public void dispose() {
        if (this._searchDialog != null) {
            ((Window)((Object)this._searchDialog)).dispose();
        }
        this._searchDialog = null;
        super.dispose();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            ((Component)this).setVisible(false);
        } else if (windowEvent.getID() == 200) {
            if (this._indexFile != null) {
                this._searchMenuItem.setEnabled(true);
            } else {
                this._searchMenuItem.setEnabled(false);
            }
        }
        super.processWindowEvent(windowEvent);
    }

    private void _initQuickTourWindow(Class clazz) {
        int n;
        try {
            this._htmlBrowser = (HTMLBrowser)clazz.newInstance();
        }
        catch (Exception exception) {
            System.out.println("failed when creating htmlBrowser " + exception);
            return;
        }
        this.add((Component)((Object)this._htmlBrowser), "Center");
        this._stack = new DocumentStack(this._htmlBrowser);
        this._createMenubar();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n2 = 675;
        if (n2 > dimension.width) {
            n2 = dimension.width;
        }
        if ((n = 530) > dimension.height) {
            n = dimension.height;
        }
        ((Component)this).setSize(n2, n);
        int n3 = 1;
        if (dimension.width > n2) {
            n3 = (dimension.width - n2) / 2;
        }
        int n4 = 1;
        if (dimension.height > n) {
            n4 = (dimension.height - n) / 2;
        }
        ((Component)this).setLocation(n3, n4);
        this._stack.addStackListener(new _stackListener());
        this.enableEvents(64L);
        this._backMenuItem.setEnabled(false);
        this._forwardMenuItem.setEnabled(false);
        this._searchMenuItem.setEnabled(false);
    }

    private void _createMenubar() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.MenuLabels", Locale.getDefault());
        _actionListener _actionListener2 = new _actionListener();
        Menu menu = MenuDefs.createMenu(_actionListener2, FILE_LABELS, resourceBundle);
        Menu menu2 = MenuDefs.createMenu(_actionListener2, GO_LABELS, resourceBundle);
        Menu menu3 = MenuDefs.createMenu(_actionListener2, TOOLS_LABELS, resourceBundle);
        this._printMenuItem = menu.getItem(0);
        this._closeMenuItem = menu.getItem(2);
        this._backMenuItem = menu2.getItem(0);
        this._forwardMenuItem = menu2.getItem(1);
        this._searchMenuItem = menu3.getItem(0);
        this._menubar = new MenuBar();
        this._menubar.add(menu);
        this._menubar.add(menu2);
        this._menubar.add(menu3);
        this.setMenuBar(this._menubar);
    }

    private class _actionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getActionCommand();
            if (string.equals("PrintTopic")) {
                QuickTourWindow.this._htmlBrowser.print();
                return;
            }
            if (string.equals("Close")) {
                ((Component)QuickTourWindow.this).setVisible(false);
                return;
            }
            if (string.equals("Back")) {
                QuickTourWindow.this._stack.goBack();
                return;
            }
            if (string.equals("Forward")) {
                QuickTourWindow.this._stack.goForward();
                return;
            }
            if (string.equals("Search")) {
                QuickTourWindow.this.showSearchDialog();
            }
        }

        _actionListener() {
            QuickTourWindow.this = QuickTourWindow.this;
        }
    }

    private class _stackListener
    implements DocumentStackListener {
        public void documentStackChanged(DocumentStackEvent documentStackEvent) {
            QuickTourWindow.this._backMenuItem.setEnabled(QuickTourWindow.this._stack.canGoBack());
            QuickTourWindow.this._forwardMenuItem.setEnabled(QuickTourWindow.this._stack.canGoForward());
        }

        _stackListener() {
            QuickTourWindow.this = QuickTourWindow.this;
        }
    }
}

