/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser;

import ice.htmlbrowser.Browser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.PrintJob;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWContainer;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.PopupEvent;
import oracle.help.htmlBrowser.PopupListener;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;

public class ICEBrowser
extends LWContainer
implements HTMLBrowser,
PropertyChangeListener {
    private ListenerManager _urlListeners;
    private ListenerManager _popupListeners;
    private Browser _browser;

    public ICEBrowser() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this._browser = new Browser();
        ((Container)((Object)this)).add((Component)this._browser, "Center");
        this._browser.addMouseListener(new _mouseAdapter());
        this._browser.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void setURL(URL uRL) {
        this._browser.gotoLocation(uRL);
    }

    public URL getURL() {
        try {
            return new URL(this._browser.getCurrentLocation());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void reloadURL() {
        this._browser.reload();
    }

    public void print() {
        Frame frame = this._getFrame();
        if (frame == null) {
            return;
        }
        PrintJob printJob = ((Component)((Object)this)).getToolkit().getPrintJob(frame, "Help Topic", null);
        if (printJob != null) {
            this._browser.printDoc(printJob);
            printJob.end();
        }
    }

    public void printURL(URL uRL) {
    }

    public boolean isPrintingSupported() {
        return true;
    }

    public void addURLListener(URLListener uRLListener) {
        if (this._urlListeners == null) {
            this._urlListeners = new ListenerManager();
        }
        this._urlListeners.addListener((EventListener)uRLListener);
    }

    public void removeURLListener(URLListener uRLListener) {
        if (this._urlListeners != null) {
            this._urlListeners.addListener((EventListener)uRLListener);
        }
    }

    public void addPopupListener(PopupListener popupListener) {
        if (this._popupListeners == null) {
            this._popupListeners = new ListenerManager();
        }
        this._popupListeners.addListener((EventListener)popupListener);
    }

    public void removePopupListener(PopupListener popupListener) {
        this._popupListeners.removeListener((EventListener)popupListener);
    }

    public String getCharset() {
        return null;
    }

    public void setCharset(String string) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("currentLocation")) {
            URLEvent uRLEvent = new URLEvent(this.getURL());
            this._dispatchURLEvent(uRLEvent);
        }
    }

    private Frame _getFrame() {
        Container container = ((Component)((Object)this)).getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private void _dispatchURLEvent(URLEvent uRLEvent) {
        Enumeration enumeration;
        if (this._urlListeners != null && (enumeration = this._urlListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                URLListener uRLListener = (URLListener)enumeration.nextElement();
                uRLListener.urlChanged(uRLEvent);
            }
        }
    }

    private void _dispatchPopupEvent(PopupEvent popupEvent) {
        Enumeration enumeration;
        if (this._popupListeners != null && (enumeration = this._popupListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                PopupListener popupListener = (PopupListener)enumeration.nextElement();
                popupListener.showPopup(popupEvent);
            }
        }
    }

    static /* synthetic */ void access$0(ICEBrowser iCEBrowser, PopupEvent popupEvent) {
        iCEBrowser._dispatchPopupEvent(popupEvent);
    }

    private class _mouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                ICEBrowser iCEBrowser = ICEBrowser.this;
                PopupEvent popupEvent = new PopupEvent((Component)mouseEvent.getSource(), mouseEvent);
                iCEBrowser._dispatchPopupEvent(popupEvent);
            }
        }

        _mouseAdapter() {
            ICEBrowser.this = ICEBrowser.this;
        }
    }
}

