/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.Component;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;
import oracle.help.HelpBook;
import oracle.help.navigator.IndexPanel;
import oracle.help.util.Library;
import oracle.help.util.LibraryEvent;
import oracle.help.util.LibraryListener;
import oracle.help.util.TreeNode;
import oracle.help.util.TreeRoot;

public class IndexDataSource
implements OneDDataSource,
LibraryListener,
Task {
    private Library _library;
    private Vector _books;
    private Vector _items;
    private int _lastItem;
    private int _itemCount;
    private ListenerManager _manager;
    private Vector _pending;
    private IndexPanel _panel;
    private boolean _abort;
    private int _waiting;
    private TaskScheduler _scheduler;
    private boolean _running;

    public IndexDataSource(IndexPanel indexPanel, Library library) {
        this._library = library;
        this._panel = indexPanel;
        this._scheduler = new TaskScheduler();
        this._scheduler.setDaemon(true);
        this._scheduler.setName("IndexDataSource background process");
        library.addLibraryListener(this);
        this._itemCount = 0;
        this._lastItem = -1;
        this._books = new Vector(10, 10);
        Enumeration enumeration = library.getBooks();
        while (enumeration.hasMoreElements()) {
            HelpBook helpBook = (HelpBook)enumeration.nextElement();
            this.addBook(helpBook);
        }
        if (this._running) {
            this._abort = true;
        }
        this._scheduler.schedule((Task)this, 0);
    }

    public int getItemCount() {
        return this._itemCount;
    }

    public Object getData(int n) {
        TreeNode treeNode = this.getNode(n);
        if (treeNode == null) {
            return null;
        }
        return treeNode.getLabel();
    }

    public void setData(int n, Object object) {
    }

    public void addDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener((EventListener)oneDDataSourceListener);
    }

    public void removeDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this._manager != null) {
            this._manager.removeListener((EventListener)oneDDataSourceListener);
        }
    }

    public void libraryChanged(LibraryEvent libraryEvent) {
        if (((Component)((Object)this._panel)).isVisible()) {
            this._abort = true;
            if (libraryEvent.getID() == 2001) {
                this.addBook(libraryEvent.getBook());
                return;
            }
            this.removeBook(libraryEvent.getBook());
            return;
        }
        if (this._pending == null) {
            this._pending = new Vector(20);
        }
        this._pending.addElement(libraryEvent);
    }

    public void runTask(TaskEvent taskEvent) {
        if (this._abort) {
            this._abort = false;
            return;
        }
        this._running = true;
        this._items = new Vector(this._itemCount);
        this._items.setSize(this._itemCount);
        Vector vector = (Vector)this._books.clone();
        Vector vector2 = this._items;
        TreeRoot[] treeRootArray = new TreeRoot[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            treeRootArray[n] = (TreeRoot)((HelpBook)vector.elementAt(n)).getHhkTree();
            ++n;
        }
        int[] nArray = new int[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            nArray[n2] = 0;
            ++n2;
        }
        this._totalItems();
        this._lastItem = -1;
        int n3 = 0;
        while (n3 < this._itemCount) {
            Object object;
            TreeNode treeNode = null;
            int n4 = 0;
            int n5 = 0;
            while (n5 < vector.size()) {
                object = treeRootArray[n5];
                if (nArray[n5] < ((TreeNode)object).numChildren()) {
                    TreeNode treeNode2 = ((TreeNode)object).getChild(nArray[n5]);
                    if (treeNode == null) {
                        treeNode = treeNode2;
                        n4 = n5;
                    } else if (treeNode.getLabel().toLowerCase().compareTo(treeNode2.getLabel().toLowerCase()) > 0) {
                        treeNode = treeNode2;
                        n4 = n5;
                    }
                    if (this._abort) {
                        this._abort = false;
                        this._running = false;
                        return;
                    }
                }
                ++n5;
            }
            vector2.setElementAt(treeNode, n3);
            int n6 = n4;
            nArray[n6] = nArray[n6] + 1;
            ++this._lastItem;
            if (this._waiting > 0) {
                object = this;
                synchronized (object) {
                    this.notifyAll();
                }
            }
            ++n3;
        }
        this._abort = false;
        this._running = false;
    }

    public void addBook(HelpBook helpBook) {
        Enumeration enumeration;
        if (!helpBook.containsIndex()) {
            return;
        }
        if (this._books.contains(helpBook)) {
            return;
        }
        this._books.addElement(helpBook);
        this._items = null;
        this._lastItem = -1;
        int n = this._itemCount;
        this._totalItems();
        if (this._running) {
            this._abort = true;
        }
        this._scheduler.schedule((Task)this, 0);
        if (this._manager != null && (enumeration = this._manager.getListeners()) != null) {
            OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent((Object)this, 2003, 0, n);
            OneDDataSourceEvent oneDDataSourceEvent2 = new OneDDataSourceEvent((Object)this, 2001, n, this._itemCount - n);
            while (enumeration.hasMoreElements()) {
                OneDDataSourceListener oneDDataSourceListener = (OneDDataSourceListener)enumeration.nextElement();
                oneDDataSourceListener.itemsAdded(oneDDataSourceEvent2);
                oneDDataSourceListener.invalidateItems(oneDDataSourceEvent);
            }
        }
    }

    public void removeBook(HelpBook helpBook) {
        if (!helpBook.containsIndex()) {
            return;
        }
        if (this._books.removeElement(helpBook)) {
            this._items = null;
            this._lastItem = -1;
            int n = this._itemCount;
            this._totalItems();
            if (this._running) {
                this._abort = true;
            }
            this._scheduler.schedule((Task)this, 0);
            if (this._manager == null) {
                return;
            }
            Enumeration enumeration = this._manager.getListeners();
            if (enumeration == null) {
                return;
            }
            OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent((Object)this, 2003, 0, n);
            OneDDataSourceEvent oneDDataSourceEvent2 = new OneDDataSourceEvent((Object)this, 2002, this._itemCount, this._itemCount - n);
            while (enumeration.hasMoreElements()) {
                OneDDataSourceListener oneDDataSourceListener = (OneDDataSourceListener)enumeration.nextElement();
                oneDDataSourceListener.itemsRemoved(oneDDataSourceEvent2);
                oneDDataSourceListener.invalidateItems(oneDDataSourceEvent);
            }
        }
    }

    public TreeNode getNode(int n) {
        Object object;
        if (this._books.size() == 1) {
            TreeRoot treeRoot = (TreeRoot)((HelpBook)this._books.elementAt(0)).getHhkTree();
            return treeRoot.getChild(n);
        }
        if (this._books.size() == 0) {
            return null;
        }
        ++this._waiting;
        while (this._lastItem < n) {
            if (!this._running) {
                if (this._running) {
                    this._abort = true;
                }
                this._scheduler.schedule((Task)this, 0);
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        --this._waiting;
        object = (TreeNode)this._items.elementAt(n);
        return object;
    }

    public void refresh() {
        if (this._pending == null) {
            return;
        }
        Enumeration enumeration = this._pending.elements();
        while (enumeration.hasMoreElements()) {
            LibraryEvent libraryEvent = (LibraryEvent)enumeration.nextElement();
            HelpBook helpBook = libraryEvent.getBook();
            if (libraryEvent.getID() == 2001) {
                this.addBook(helpBook);
                continue;
            }
            this.removeBook(helpBook);
        }
        this._pending = null;
        if (this._running) {
            this._abort = true;
        }
        this._scheduler.schedule((Task)this, 0);
    }

    /*
     * Unable to fully structure code
     */
    private void _totalItems() {
        this._itemCount = 0;
        if (this._books == null) {
            return;
        }
        var1_1 = this._books.elements();
        if (var1_1 != null) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (HelpBook)var1_1.nextElement();
            this._itemCount += ((TreeRoot)var2_2.getHhkTree()).numChildren();
lbl9:
            // 2 sources

            ** while (var1_1.hasMoreElements())
        }
lbl10:
        // 1 sources

    }

    private void _runThread() {
        if (this._running) {
            this._abort = true;
        }
        this._scheduler.schedule((Task)this, 0);
    }

    private void _stopThread() {
        this._abort = true;
    }
}

