/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.ewt.EwtComponent;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWDataSourceList;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.timer.Timer;
import oracle.help.HelpBook;
import oracle.help.navigator.IndexDataSource;
import oracle.help.navigator.NavigatorItemEvent;
import oracle.help.navigator.NavigatorItemListener;
import oracle.help.navigator.NavigatorMenuBar;
import oracle.help.navigator.NavigatorWindow;
import oracle.help.navigator.SubtopicDataSource;
import oracle.help.util.Library;
import oracle.help.util.LibraryEvent;
import oracle.help.util.LibraryListener;
import oracle.help.util.TreeNode;
import oracle.help.util.TreeRoot;

public class IndexPanel
extends EwtComponent
implements ActionListener,
ItemListener,
Runnable,
TextListener,
LibraryListener {
    private boolean _inSelection;
    private static final int TIMER_DELAY = 250;
    private LWTextField _typeField;
    private LWDataSourceList _topicList;
    private LWDataSourceList _subtopicList;
    private LWButton _openButton;
    private Vector _trees;
    private IndexDataSource _dataSource;
    private SubtopicDataSource _subtopicSource;
    private Timer _timer;
    private NavigatorWindow _window;
    private Library _library;
    private NavigatorItemListener _listener;
    private NavigatorItemEvent _itemEvent = new NavigatorItemEvent(true);

    public IndexPanel(NavigatorWindow navigatorWindow, Library library) {
        EwtContainer ewtContainer = new EwtContainer();
        ewtContainer.setLayout(new BorderLayout(0, 8));
        ewtContainer.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)ewtContainer, "Center");
        this._window = navigatorWindow;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Generic", Locale.getDefault());
        LWContainer lWContainer = new LWContainer();
        ewtContainer.add((Component)lWContainer, "North");
        lWContainer.setLayout(new GridLayout(0, 1, 0, 4));
        lWContainer.add((Component)new LWLabel(resourceBundle.getString("navigator.indexpage.toplabel")));
        this._typeField = new LWTextField();
        this._typeField.addTextListener((TextListener)this);
        lWContainer.add((Component)this._typeField);
        this._dataSource = new IndexDataSource(this, library);
        this._topicList = new LWDataSourceList((OneDDataSource)this._dataSource);
        this._topicList.addItemListener((ItemListener)this);
        this._topicList.addActionListener((ActionListener)this);
        ewtContainer.add((Component)this._topicList, "Center");
        LWContainer lWContainer2 = new LWContainer();
        ewtContainer.add((Component)lWContainer2, "South");
        lWContainer2.setLayout(new BorderLayout(0, 10));
        lWContainer2.add((Component)new LWLabel(resourceBundle.getString("navigator.indexpage.select")), "North");
        this._subtopicList = new LWDataSourceList(4);
        this._subtopicList.addActionListener((ActionListener)this);
        lWContainer2.add((Component)this._subtopicList, "Center");
        LWContainer lWContainer3 = new LWContainer();
        lWContainer3.setLayout(new BorderLayout());
        lWContainer2.add((Component)lWContainer3, "South");
        this._openButton = new LWButton(resourceBundle.getString("navigator.indexpage.open"));
        this._openButton.addActionListener((ActionListener)this);
        this._openButton.setEnabled(false);
        this._openButton.setBackground(Color.lightGray);
        lWContainer3.add((Component)this._openButton, "East");
        lWContainer3.add((Component)new LWLabel(""), "Center");
        ((Container)((Object)this)).validate();
        this._timer = new Timer((Runnable)this);
        this._inSelection = false;
        this._trees = new Vector(10, 10);
        this._library = library;
        library.addLibraryListener(this);
    }

    public void setNavigatorItemListener(NavigatorItemListener navigatorItemListener) {
        this._listener = navigatorItemListener;
    }

    public void addBook(HelpBook helpBook) {
        this._dataSource.addBook(helpBook);
    }

    public void removeBook(HelpBook helpBook) {
        this._dataSource.removeBook(helpBook);
    }

    public TreeNode getActiveNode() {
        int n;
        if (this._subtopicList != null && (n = this._subtopicList.getSelectedIndex()) != -1) {
            return this._subtopicSource.getNode(n);
        }
        if (this._topicList != null && (n = this._topicList.getSelectedIndex()) != -1) {
            return this._dataSource.getNode(this._topicList.getSelectedIndex());
        }
        return null;
    }

    public void syncMenus() {
        NavigatorMenuBar navigatorMenuBar = this._window.getMenubar();
        boolean bl = !this._typeField.getText().equals("") || this._topicList.getSelectedIndex() != -1;
        navigatorMenuBar.setDisplayEnabled(bl);
        this._listener.selectionChanged(this._itemEvent);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getID() == 900) {
            this.syncMenus();
        }
        if (this._dataSource.getItemCount() == 0) {
            return;
        }
        if (this._inSelection) {
            this._inSelection = false;
            return;
        }
        int n = this._binarySearch(this._typeField.getText());
        this._topicList.select(n);
        this._topicList.makeVisible(n);
        this._timer.schedule(250L);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this._dataSource.getItemCount() == 0) {
            return;
        }
        if (itemEvent.getStateChange() == 1) {
            this._inSelection = true;
            this._typeField.setText(this._topicList.getSelectedItem());
        }
        this._timer.schedule(250L);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._dataSource.getItemCount() == 0) {
            return;
        }
        if (actionEvent.getSource() == this._topicList) {
            this._timer.cancel();
            this._updateSubtopics();
            if (this._dataSource.getNode(this._topicList.getSelectedIndex()).numChildren() == 0) {
                this._sendItem(this._dataSource.getNode(this._topicList.getSelectedIndex()));
                return;
            }
        } else {
            if (this._subtopicSource != null) {
                this._sendItem(this._subtopicSource.getNode(this._subtopicList.getSelectedIndex()));
                return;
            }
            this._sendItem(this._dataSource.getNode(this._topicList.getSelectedIndex()));
        }
    }

    public void libraryChanged(LibraryEvent libraryEvent) {
        this._typeField.setText("");
        this._updateSubtopics();
    }

    public void run() {
        if (this._dataSource.getItemCount() == 0) {
            return;
        }
        this._updateSubtopics();
    }

    private void _updateSubtopics() {
        Object[] objectArray;
        if (this._topicList.getSelectedIndex() == -1) {
            this._openButton.setEnabled(false);
            this._subtopicList.setDataSource(null);
            return;
        }
        TreeNode treeNode = this._dataSource.getNode(this._topicList.getSelectedIndex());
        if (treeNode == null) {
            this._openButton.setEnabled(false);
            this._subtopicList.setDataSource(null);
            return;
        }
        int n = treeNode.numChildren();
        if (n > 0) {
            objectArray = new TreeNode[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = treeNode.getChild(n2);
                ++n2;
            }
        } else {
            objectArray = new TreeNode[]{treeNode};
        }
        this._subtopicSource = new SubtopicDataSource(objectArray);
        this._subtopicList.setDataSource((OneDDataSource)this._subtopicSource);
        this._subtopicList.select(0);
        this._openButton.setEnabled(true);
        this.syncMenus();
    }

    public void refreshBooks() {
        this._dataSource.refresh();
    }

    /*
     * Unable to fully structure code
     */
    private int _binarySearch(String var1_1) {
        var2_2 = 0;
        var3_3 = this._dataSource.getItemCount();
        var1_1 = var1_1.toLowerCase();
        while (var2_2 < var3_3) {
            var4_4 = var2_2 + (var3_3 - var2_2) / 2;
            var6_6 = ((String)this._dataSource.getData(var4_4)).toLowerCase();
            var7_7 = var4_4;
            while (var6_6.charAt(0) == ' ') {
                var6_6 = ((String)this._dataSource.getData(--var7_7)).toLowerCase();
            }
            var5_5 = var1_1.compareTo(var6_6);
            if (var5_5 < 0) {
                var3_3 = var4_4;
                continue;
            }
            if (var5_5 > 0) {
                var2_2 = var4_4 + 1;
                continue;
            }
            var6_6 = (String)this._dataSource.getData(var4_4);
            while (var6_6.charAt(0) == ' ') {
                var6_6 = (String)this._dataSource.getData(--var4_4);
            }
            return var4_4;
        }
        var6_6 = ((String)this._dataSource.getData(var3_3)).toLowerCase();
        if (!var1_1.regionMatches(0, var6_6, 0, var1_1.length())) ** GOTO lbl27
        return var3_3;
lbl-1000:
        // 1 sources

        {
            var6_6 = ((String)this._dataSource.getData(--var3_3)).toLowerCase();
lbl27:
            // 2 sources

            ** while (var6_6.charAt((int)0) == ' ')
        }
lbl28:
        // 1 sources

        var5_5 = var1_1.compareTo(var6_6);
        if (var5_5 < 0 && var3_3 > 0) {
            var7_7 = var3_3 - 1;
            var6_6 = (String)this._dataSource.getData(var7_7);
            while (var6_6.charAt(0) == ' ') {
                var6_6 = (String)this._dataSource.getData(--var7_7);
            }
            return var7_7;
        }
        return var3_3;
    }

    private void _sendItem(TreeNode treeNode) {
        TreeRoot treeRoot = treeNode.getRoot();
        String string = treeRoot.getBaseURL();
        try {
            URL uRL = new URL(String.valueOf(string) + treeNode.getUrl());
            this._window.displayUrl(treeRoot.getBook(), uRL, false);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    boolean _isVisible() {
        return this._window.isIndexVisible();
    }
}

