/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyEvent;
import oracle.ewt.dTree.DTreeDeferredParent;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.help.navigator.NavigatorItem;
import oracle.help.navigator.NavigatorItemFactory;
import oracle.help.util.ImageLoader;
import oracle.help.util.TreeNode;

public class NavigatorBranchItem
extends DTreeDeferredParent
implements NavigatorItem {
    private static Image _sExpandedImg;
    private static Image _sCollapsedImg;

    public NavigatorBranchItem(OneDDataSource oneDDataSource) {
        super(oneDDataSource);
    }

    public TreeNode getNode() {
        DTreeDeferringParent dTreeDeferringParent = this.getDeferringParent();
        return (TreeNode)dTreeDeferringParent.getChildData(this.getIndex());
    }

    public DTreeItemFactory getItemFactory() {
        return NavigatorItemFactory.getInstance();
    }

    public String getLabel() {
        DTreeDeferringParent dTreeDeferringParent = this.getDeferringParent();
        TreeNode treeNode = (TreeNode)dTreeDeferringParent.getChildData(this.getIndex());
        if (treeNode != null) {
            return treeNode.getLabel();
        }
        return null;
    }

    public Image getIcon() {
        if (this.isExpanded()) {
            return this.getExpandedIcon();
        }
        return this.getCollapsedIcon();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401) {
            if (this.isExpanded()) {
                this.setExpanded(false);
                return;
            }
            this.setExpanded(true);
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    protected Image getExpandedIcon() {
        if (_sExpandedImg == null) {
            _sExpandedImg = ImageLoader.loadImage((Component)this.getTree(), "images/openbook.gif", Color.white);
        }
        return _sExpandedImg;
    }

    protected Image getCollapsedIcon() {
        if (_sCollapsedImg == null) {
            _sCollapsedImg = ImageLoader.loadImage((Component)this.getTree(), "images/closedbook.gif", Color.white);
        }
        return _sCollapsedImg;
    }
}

