/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.help.navigator.NavigatorBranchItem;
import oracle.help.navigator.NavigatorDataSource;
import oracle.help.navigator.NavigatorItem;
import oracle.help.navigator.NavigatorLeafItem;
import oracle.help.util.TreeNode;

public class NavigatorItemFactory
implements DTreeItemFactory {
    private static NavigatorItemFactory _sFactory = null;

    private NavigatorItemFactory() {
    }

    public DTreeItem createItem(DTreeDeferringParent dTreeDeferringParent, int n) {
        OneDDataSource oneDDataSource = dTreeDeferringParent.getDataSource();
        TreeNode treeNode = (TreeNode)oneDDataSource.getData(n);
        if (treeNode == null) {
            return null;
        }
        if (treeNode.getClientData() != null) {
            return (DTreeItem)treeNode.getClientData();
        }
        NavigatorItem navigatorItem = treeNode.isBranch() ? new NavigatorBranchItem(new NavigatorDataSource(treeNode)) : new NavigatorLeafItem();
        treeNode.setClientData(navigatorItem);
        return navigatorItem;
    }

    public static NavigatorItemFactory getInstance() {
        if (_sFactory == null) {
            _sFactory = new NavigatorItemFactory();
        }
        return _sFactory;
    }
}

