/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.EwtComponent;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.border.SeparatorBorder;
import oracle.ewt.graphics.separator.InsetSeparatorPainter;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.tabBar.ChamferedTabStyle;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarButton;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarSeparator;
import oracle.ewt.toolBar.ToolBarToolTip;
import oracle.help.context.GlobalContext;
import oracle.help.navigator.IndexPanel;
import oracle.help.navigator.NavigatorItemEvent;
import oracle.help.navigator.NavigatorItemListener;
import oracle.help.navigator.NavigatorMenuBar;
import oracle.help.navigator.NavigatorTree;
import oracle.help.navigator.NavigatorWindow;
import oracle.help.util.ImageLoader;
import oracle.help.util.TreeNode;

public class NavigatorPanel
extends EwtComponent
implements TabPanelListener,
ToolBarActionListener,
NavigatorItemListener {
    private NavigatorWindow _window;
    private ToolBar _toolbar;
    private TabPanel _tabPanel;
    private EwtComponent _contentPanel;
    private IndexPanel _indexPanel;
    private NavigatorTree _tree;
    private ToolBarButton _displayButton;
    private ToolBarButton _displayNewButton;
    private ToolBarButton _searchButton;
    private GlobalContext _context;
    private static int DISPLAY;
    private static int DISPLAY_NEW;
    private static int SEARCH;

    public NavigatorPanel(NavigatorWindow navigatorWindow, GlobalContext globalContext) {
        this._window = navigatorWindow;
        this._context = globalContext;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Generic", Locale.getDefault());
        new MarginBorder(10, 10, 10, 10);
        this._toolbar = new ToolBar();
        this._toolbar.addItem((ToolBarItem)new ToolBarSeparator());
        Image image = ImageLoader.loadImage((Component)((Object)this), "images/display.gif");
        this._displayButton = new ToolBarButton(DISPLAY, image);
        this._toolbar.addItem((ToolBarItem)this._displayButton);
        this._displayButton.addToolBarActionListener((ToolBarActionListener)this);
        this._displayButton.setEnabled(false);
        image = ImageLoader.loadImage((Component)((Object)this), "images/diswin.gif");
        this._displayNewButton = new ToolBarButton(DISPLAY_NEW, image);
        this._toolbar.addItem((ToolBarItem)this._displayNewButton);
        this._displayNewButton.addToolBarActionListener((ToolBarActionListener)this);
        this._displayNewButton.setEnabled(false);
        this._toolbar.addItem((ToolBarItem)new ToolBarSeparator());
        image = ImageLoader.loadImage((Component)((Object)this), "images/search.gif");
        this._searchButton = new ToolBarButton(SEARCH, image);
        this._toolbar.addItem((ToolBarItem)this._searchButton);
        this._searchButton.addToolBarActionListener((ToolBarActionListener)this);
        this._toolbar.setBorder((Border)new SeparatorBorder(2, InsetSeparatorPainter.getSeparatorPainter(), 1));
        this._tabPanel = new TabPanel(ChamferedTabStyle.getTabStyle(), true);
        this._tabPanel.addTabPanelListener((TabPanelListener)this);
        this._contentPanel = new EwtComponent();
        this._contentPanel.setLayout(new BorderLayout());
        this._tabPanel.addPage(resourceBundle.getString("navigator.tabpage.contents"), (Component)this._contentPanel);
        this._tree = new NavigatorTree(this._window, this._context.getLibrary());
        this._tree.setBackground(Color.white);
        ScrollBox scrollBox = new ScrollBox((Component)((Object)this._tree));
        this._contentPanel.add((Component)scrollBox, "Center");
        this._indexPanel = new IndexPanel(navigatorWindow, this._context.getLibrary());
        ((Component)((Object)this._indexPanel)).setVisible(false);
        this._tabPanel.addPage(resourceBundle.getString("navigator.tabpage.index"), (Component)((Object)this._indexPanel));
        ((Container)((Object)this)).setLayout(new BorderLayout(1, 4));
        ((Container)((Object)this)).add((Component)this._toolbar, "North");
        ((Container)((Object)this)).add((Component)this._tabPanel, "Center");
        this._tree.addNavigatorItemListener(this);
        this._indexPanel.setNavigatorItemListener(this);
        this._toolbar.setToolTipValue((ToolTipClient)new ToolBarToolTip(this._toolbar));
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("oracle.help.resource.MenuLabels", Locale.getDefault());
        this._displayButton.setHelpText(resourceBundle2.getString("Display"));
        this._displayNewButton.setHelpText(resourceBundle2.getString("Display_New").substring(2));
        this._searchButton.setHelpText(resourceBundle2.getString("Search"));
    }

    public void tabPanelSelectionChanged(TabPanelEvent tabPanelEvent) {
        if (tabPanelEvent.getPage().getIndex() == 0) {
            this.setContentsPage();
            return;
        }
        if (tabPanelEvent.getPage().getIndex() == 1) {
            this.setIndexPage();
        }
    }

    public void tabPanelSelectionChanging(TabPanelEvent tabPanelEvent) {
    }

    public void setContentsPage() {
        if (!this._tabPanel.getPage(0).isEnabled()) {
            return;
        }
        this._window.getMenubar().setContentsState(true);
        this._window.getMenubar().setIndexState(false);
        this._tabPanel.getPage(0).setSelected(true);
        if (this._tree != null) {
            this._tree.refreshBooks();
        }
        this._window.refresh();
        this.syncMenus();
    }

    public void setContentsEnabled(boolean bl) {
        this._tabPanel.getPage(0).setEnabled(bl);
        this._window.getMenubar().setContentsEnabled(bl);
    }

    public void setIndexPage() {
        if (!this._tabPanel.getPage(1).isEnabled()) {
            return;
        }
        ((Component)this._window).setCursor(Cursor.getPredefinedCursor(3));
        this._tabPanel.getPage(1).setSelected(true);
        if (this._indexPanel != null) {
            this._indexPanel.refreshBooks();
        }
        this._window.getMenubar().setContentsState(false);
        this._window.getMenubar().setIndexState(true);
        ((Component)this._window).setCursor(Cursor.getPredefinedCursor(0));
        this.syncMenus();
    }

    public void setIndexEnabled(boolean bl) {
        this._tabPanel.getPage(1).setEnabled(bl);
        this._window.getMenubar().setIndexEnabled(bl);
    }

    public void setSearchEnabled(boolean bl) {
        this._searchButton.setEnabled(bl);
        this._window.getMenubar().setSearchEnabled(bl);
    }

    public void refreshBooks() {
        if (this._tabPanel.getIndexOf(this._tabPanel.getSelectedPage()) == 0) {
            this._tree.refreshBooks();
            return;
        }
        this._indexPanel.refreshBooks();
    }

    public boolean isIndexVisible() {
        if (!this._window.isShowing()) {
            return false;
        }
        return this._tabPanel.getIndexOf(this._tabPanel.getSelectedPage()) == 1;
    }

    public boolean isContentsVisible() {
        if (!this._window.isShowing()) {
            return false;
        }
        return this._tabPanel.getIndexOf(this._tabPanel.getSelectedPage()) == 0;
    }

    public TreeNode getActiveNode() {
        if (this._tabPanel.getIndexOf(this._tabPanel.getSelectedPage()) == 0) {
            return this._tree.getActiveNode();
        }
        return this._indexPanel.getActiveNode();
    }

    public void syncMenus() {
        NavigatorMenuBar navigatorMenuBar = this._window.getMenubar();
        if (this._tabPanel.getIndexOf(this._tabPanel.getSelectedPage()) == 0) {
            if (this._tree != null) {
                this._tree.refreshMenuItems();
            }
            navigatorMenuBar.setContentsState(true);
            navigatorMenuBar.setIndexState(false);
            return;
        }
        navigatorMenuBar.setExpandEnabled(false);
        navigatorMenuBar.setExpandAllEnabled(false);
        navigatorMenuBar.setCollapseEnabled(false);
        navigatorMenuBar.setCollapseAllEnabled(false);
        navigatorMenuBar.setContentsState(false);
        navigatorMenuBar.setIndexState(true);
        this._indexPanel.syncMenus();
    }

    public void setDisplayEnabled(boolean bl) {
        Thread.dumpStack();
        this._displayButton.setEnabled(bl);
        this._displayNewButton.setEnabled(bl);
    }

    public NavigatorTree getNavigatorTree() {
        return this._tree;
    }

    public IndexPanel getIndexPanel() {
        return this._indexPanel;
    }

    public void toolBarItemActionPerformed(ToolBarEvent toolBarEvent) {
        ToolBarButton toolBarButton = (ToolBarButton)toolBarEvent.getItem();
        if (toolBarButton == this._displayButton) {
            this._window.displayNode(this.getActiveNode(), false);
            return;
        }
        if (toolBarButton == this._searchButton) {
            this._window.search();
            return;
        }
        if (toolBarButton == this._displayNewButton) {
            this._window.displayNode(this.getActiveNode(), true);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setSearchEnabled(bl);
        if (bl && this.isContentsVisible() || !bl && this.isIndexVisible()) {
            this.setContentsEnabled(bl);
            this.setIndexEnabled(bl);
            return;
        }
        this.setIndexEnabled(bl);
        this.setContentsEnabled(bl);
    }

    public void selectionChanged(NavigatorItemEvent navigatorItemEvent) {
        this._displayButton.setEnabled(navigatorItemEvent.isBranch());
        this._displayNewButton.setEnabled(navigatorItemEvent.isBranch());
    }

    static {
        DISPLAY_NEW = 1;
        SEARCH = 2;
    }
}

