/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeDeferringRoot;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemEvent;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.event.ListenerManager;
import oracle.help.HelpBook;
import oracle.help.navigator.LibraryDataSource;
import oracle.help.navigator.NavigatorItem;
import oracle.help.navigator.NavigatorItemEvent;
import oracle.help.navigator.NavigatorItemFactory;
import oracle.help.navigator.NavigatorItemListener;
import oracle.help.navigator.NavigatorLeafItem;
import oracle.help.navigator.NavigatorMenuBar;
import oracle.help.navigator.NavigatorWindow;
import oracle.help.util.CancelDialog;
import oracle.help.util.Library;
import oracle.help.util.MenuDefs;
import oracle.help.util.TreeNode;
import oracle.help.util.TreeRoot;

public class NavigatorTree
extends DTree
implements Runnable {
    private NavigatorWindow _window;
    private Library _library;
    private boolean _expandAll = false;
    private boolean _collapseAll = true;
    private boolean _inPopUp;
    private ListenerManager _treeListeners;
    private Thread _printThread;
    private PrintJob _printJob;
    private CancelDialog _cancelDialog;
    private PopupMenu _popup;
    private MenuItem _displayNew;

    public NavigatorTree(NavigatorWindow navigatorWindow, Library library) {
        this._window = navigatorWindow;
        this._library = library;
        LibraryDataSource libraryDataSource = new LibraryDataSource(library);
        DTreeDeferringRoot dTreeDeferringRoot = new DTreeDeferringRoot(null, null, (OneDDataSource)libraryDataSource, (DTreeItemFactory)NavigatorItemFactory.getInstance());
        this.setRoot((DTreeRootItem)dTreeDeferringRoot);
    }

    public void refreshBooks() {
    }

    public void expandSelectedNode() {
        DTreeItem dTreeItem = this._getSelectedItem();
        dTreeItem.setExpanded(true);
        this._collapseAll = false;
        this.refreshMenuItems();
    }

    public TreeNode getActiveNode() {
        NavigatorItem navigatorItem = (NavigatorItem)this._getSelectedItem();
        if (navigatorItem == null) {
            return null;
        }
        return navigatorItem.getNode();
    }

    public void collapseSelectedNode() {
        DTreeItem dTreeItem = this._getSelectedItem();
        if (dTreeItem != null) {
            this._collapseNode(dTreeItem, false);
        }
        this._expandAll = false;
        this.refreshMenuItems();
    }

    public void collapseAll() {
        DTreeRootItem dTreeRootItem = this.getRoot();
        int n = 0;
        while (n < dTreeRootItem.getItemCount()) {
            DTreeItem dTreeItem = dTreeRootItem.getItem(n);
            if (dTreeItem.isExpanded()) {
                this._collapseNode(dTreeItem, true);
            }
            ++n;
        }
        this._expandAll = false;
        this._collapseAll = true;
        this.refreshMenuItems();
    }

    public void expandAll() {
        DTreeRootItem dTreeRootItem = this.getRoot();
        this.freezeLayouts();
        try {
            this._expandItem((DTreeItem)dTreeRootItem, true);
        }
        finally {
            Object var3_2 = null;
            this.unfreezeLayouts();
        }
        this._expandAll = true;
        this._collapseAll = false;
        this.refreshMenuItems();
    }

    public void deselectAll() {
        DTreeSelection dTreeSelection = this.getSelection();
        dTreeSelection.setSelectionRanges(null);
    }

    public void makeNodeVisible(URL uRL, HelpBook helpBook) {
        Object object;
        Object object2;
        if (helpBook == null) {
            this.deselectAll();
        }
        String string = uRL.toString();
        HelpBook[] helpBookArray = this._library.getVisibleBooks();
        TreeNode treeNode = null;
        int n = 0;
        while (n < helpBookArray.length) {
            if (helpBookArray[n] == helpBook) {
                object2 = string.substring(helpBook.getBaseURL().length());
                object = (TreeRoot)helpBookArray[n].getHhcTree();
                treeNode = ((TreeRoot)object).get((String)object2);
                break;
            }
            ++n;
        }
        if (treeNode == null) {
            this.deselectAll();
            return;
        }
        object2 = (DTreeItem)treeNode.getClientData();
        if (object2 == null) {
            this._expandBottomUp(treeNode.getParent());
            object2 = (DTreeItem)treeNode.getClientData();
        }
        if (object2 != null) {
            this.makeVisible((DTreeItem)object2);
            object = this.getSelection();
            object.selectItem(object2);
            return;
        }
        this.deselectAll();
    }

    public void refreshMenuItems() {
        NavigatorMenuBar navigatorMenuBar = this._window.getMenubar();
        if (!this._window.isContentsVisible()) {
            return;
        }
        if (this.getRoot().getItemCount() == 0) {
            navigatorMenuBar.setExpandEnabled(false);
            navigatorMenuBar.setCollapseEnabled(false);
            navigatorMenuBar.setExpandAllEnabled(false);
            navigatorMenuBar.setCollapseAllEnabled(false);
            navigatorMenuBar.setDisplayEnabled(false);
            return;
        }
        TreeNode treeNode = this.getActiveNode();
        navigatorMenuBar.setExpandAllEnabled(!this._expandAll);
        navigatorMenuBar.setCollapseAllEnabled(!this._collapseAll);
        if (treeNode == null) {
            navigatorMenuBar.setDisplayEnabled(false);
            navigatorMenuBar.setExpandEnabled(false);
            navigatorMenuBar.setCollapseEnabled(false);
            this._dispatchNavigatorItemEvent(new NavigatorItemEvent(false));
            return;
        }
        DTreeItem dTreeItem = (DTreeItem)treeNode.getClientData();
        if (treeNode.isBranch()) {
            navigatorMenuBar.setDisplayEnabled(false);
            this._dispatchNavigatorItemEvent(new NavigatorItemEvent(false));
            if (dTreeItem.isExpanded()) {
                navigatorMenuBar.setExpandEnabled(false);
                navigatorMenuBar.setCollapseEnabled(true);
                return;
            }
            navigatorMenuBar.setExpandEnabled(true);
            navigatorMenuBar.setCollapseEnabled(false);
            return;
        }
        navigatorMenuBar.setExpandEnabled(false);
        navigatorMenuBar.setCollapseEnabled(false);
        navigatorMenuBar.setDisplayEnabled(true);
        this._dispatchNavigatorItemEvent(new NavigatorItemEvent(true));
    }

    public void showPopupMenu(DTreeItem dTreeItem, int n, int n2) {
        Object object;
        if (this._popup == null) {
            this._popup = new PopupMenu();
            object = ResourceBundle.getBundle("oracle.help.resource.MenuLabels", Locale.getDefault());
            String string = ((ResourceBundle)object).getString("Display_New");
            this._displayNew = new MenuItem();
            MenuDefs.setMenuAttributes(this._displayNew, string);
            this._displayNew.setActionCommand("Display_New");
            this._displayNew.addActionListener(this._window);
            this._popup.add(this._displayNew);
            ((Component)((Object)this)).add(this._popup);
            this._popup.addNotify();
        }
        object = this.getCanvasBounds();
        this._inPopUp = true;
        this._popup.show((Component)((Object)this), n, n2 + ((Rectangle)object).y);
    }

    public void printTree() {
        this._printJob = ((Component)((Object)this)).getToolkit().getPrintJob(this._window, "JavaHelp Tree", null);
        if (this._printJob != null) {
            this._printThread = new Thread(this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Generic", Locale.getDefault());
            this._cancelDialog = new CancelDialog((Frame)this._window, resourceBundle.getString("navigator.printing.printing"), this._printThread, true);
            Point point = this._window.getLocation();
            ((Component)this._cancelDialog).setLocation(point.x + 20, point.y + 20);
            this._printThread.start();
            this._cancelDialog.show();
        }
    }

    public void run() {
        Graphics graphics = null;
        int n = this._printJob.getPageResolution() / 2;
        int n2 = this._printJob.getPageDimension().height - n * 2;
        int n3 = this._printJob.getPageDimension().width - n * 2;
        if (n * 2 > n3) {
            n = 36;
            n2 = this._printJob.getPageDimension().height - n * 2;
            n3 = this._printJob.getPageDimension().width - n * 2;
        }
        int n4 = 0;
        int n5 = this.getRoot().getSubTreeHeight();
        int n6 = n5 / n2 + 1;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Generic", Locale.getDefault());
        DTreeItem dTreeItem = this.getNextVisibleItem((DTreeItem)this.getRoot());
        while (dTreeItem != null) {
            int n7;
            int n8 = dTreeItem.getY();
            if (n8 + (n7 = dTreeItem.getHeight()) > n2 * n4) {
                String string;
                Object object;
                if (graphics != null) {
                    graphics.dispose();
                }
                ++n4;
                graphics = this._printJob.getGraphics();
                if (graphics.getFont() == null) {
                    object = this.getGraphics();
                    graphics.setFont(((Graphics)object).getFont());
                }
                object = graphics.getFont();
                graphics.setFont(new Font(((Font)object).getName(), ((Font)object).getStyle(), ((Font)object).getSize() - 4));
                String string2 = resourceBundle.getString("navigator.printing.header");
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n9 = fontMetrics.getHeight() - fontMetrics.getLeading();
                int n10 = fontMetrics.stringWidth(string2);
                graphics.drawString(string2, (n3 - n10) / 2 + n, (n - n9) / 2 + fontMetrics.getAscent());
                String string3 = resourceBundle.getString("navigator.printing.footer");
                int n11 = string3.indexOf("%s1");
                if (n11 >= 0) {
                    string = String.valueOf(string3.substring(0, n11)) + n4;
                    if (n11 < string3.length() - 3) {
                        string = string.concat(string3.substring(n11 + 3));
                    }
                    string3 = string;
                }
                if ((n11 = string3.indexOf("%s2")) >= 0) {
                    string = String.valueOf(string3.substring(0, n11)) + n6;
                    if (n11 < string3.length() - 3) {
                        string.concat(string3.substring(n11 + 3));
                    }
                    string3 = string;
                }
                n10 = fontMetrics.stringWidth(string3);
                graphics.drawString(string3, (n3 - n10) / 2 + n, (n - n9) / 2 + fontMetrics.getAscent() + n2 + n);
                graphics.setFont((Font)object);
                graphics.setClip(n, n, n3, n2);
                graphics.translate(n, n - n8);
                this._cancelDialog.setText(string3);
            }
            graphics.translate(dTreeItem.getX(), n8);
            dTreeItem.paint(graphics, false, false);
            graphics.translate(-dTreeItem.getX(), -n8);
            dTreeItem = this.getNextVisibleItem(dTreeItem);
        }
        graphics.dispose();
        this._printJob.end();
        this._cancelDialog.dispose();
    }

    protected void processSelectionEvent(DTreeSelectionEvent dTreeSelectionEvent) {
        super.processSelectionEvent(dTreeSelectionEvent);
        if (dTreeSelectionEvent.getID() == 2006) {
            this.refreshMenuItems();
        }
    }

    protected void processActivateEvent(DTreeItemEvent dTreeItemEvent) {
        super.processActivateEvent(dTreeItemEvent);
        NavigatorItem navigatorItem = (NavigatorItem)dTreeItemEvent.getItem();
        if (navigatorItem instanceof NavigatorLeafItem) {
            TreeNode treeNode = navigatorItem.getNode();
            this._window.displayNode(treeNode, false);
        }
    }

    protected void processExpansionEvent(DTreeItemEvent dTreeItemEvent) {
        super.processExpansionEvent(dTreeItemEvent);
        if (dTreeItemEvent.getID() == 2001) {
            this._collapseAll = false;
            this.refreshMenuItems();
            return;
        }
        if (dTreeItemEvent.getID() == 2003) {
            this._expandAll = false;
            this.refreshMenuItems();
        }
    }

    public void addNavigatorItemListener(NavigatorItemListener navigatorItemListener) {
        if (this._treeListeners == null) {
            this._treeListeners = new ListenerManager();
        }
        this._treeListeners.addListener((EventListener)navigatorItemListener);
    }

    public void removeNavigatorListener(NavigatorItemListener navigatorItemListener) {
        this._treeListeners.removeListener((EventListener)navigatorItemListener);
    }

    private void _dispatchNavigatorItemEvent(NavigatorItemEvent navigatorItemEvent) {
        Enumeration enumeration;
        if (this._treeListeners != null && (enumeration = this._treeListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                NavigatorItemListener navigatorItemListener = (NavigatorItemListener)enumeration.nextElement();
                navigatorItemListener.selectionChanged(navigatorItemEvent);
            }
        }
    }

    private DTreeItem _getSelectedItem() {
        DTreeRange dTreeRange;
        DTreeSelection dTreeSelection = this.getSelection();
        DTreeRangeSet dTreeRangeSet = dTreeSelection.getSelectionRanges();
        int n = dTreeRangeSet.getCount();
        if (n == 1 && (dTreeRange = dTreeRangeSet.getRange(0)).getCount() == 1) {
            return dTreeRange.getParent().getItem(dTreeRange.getStartIndex());
        }
        return null;
    }

    private void _collapseNode(DTreeItem dTreeItem, boolean bl) {
        if (dTreeItem.getItemCount() == 0) {
            return;
        }
        if (bl) {
            int n = 0;
            while (n < dTreeItem.getItemCount()) {
                DTreeItem dTreeItem2 = dTreeItem.getItem(n);
                if (dTreeItem2.isExpanded()) {
                    this._collapseNode(dTreeItem2, bl);
                }
                ++n;
            }
        }
        if (dTreeItem.isExpanded()) {
            dTreeItem.setExpanded(false);
        }
    }

    private void _expandItem(DTreeItem dTreeItem, boolean bl) {
        dTreeItem.setExpanded(true);
        if (bl) {
            int n = 0;
            while (n < dTreeItem.getItemCount()) {
                this._expandItem(dTreeItem.getItem(n), true);
                ++n;
            }
        }
    }

    private void _expandBottomUp(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        DTreeItem dTreeItem = (DTreeItem)treeNode.getClientData();
        if (dTreeItem == null) {
            this._expandBottomUp(treeNode.getParent());
        }
        if ((dTreeItem = (DTreeItem)treeNode.getClientData()) != null) {
            this._expandItem(dTreeItem, false);
            int n = 0;
            while (n < dTreeItem.getItemCount()) {
                dTreeItem.getItem(n);
                ++n;
            }
        }
    }
}

