/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.EwtComponent;
import oracle.ewt.border.Border;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.layout.EqualColumnLayout;
import oracle.ewt.layout.EqualRowLayout;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.help.navigator.CharsetEvent;
import oracle.help.navigator.CharsetListener;

public class OptionsDialog
extends BufferedDialog
implements ActionListener,
ItemListener {
    private LWButton _cancelButton;
    private LWButton _okButton;
    private LWCheckbox _defaultCheckbox;
    private LWChoice _regionChoice;
    private LWChoice _charsetChoice;
    private ListenerManager _charsetListeners;
    private int _oldSelection;
    private boolean _selectionChanged;
    private boolean _oldMkDefaultState;
    private String[][] _charsetNames;
    private String[] _regionNames;
    private static String[] _regions = new String[]{"WESTERN_EUROPEAN", "EASTERN_EUROPEAN", "CYRILLIC", "GREEK", "THAI", "TURKISH", "JAPANESE", "CHINESE", "KOREAN", "BALTIC", "ICELAND", "OTHER"};
    private static String[][] _charsets = new String[][]{{"8859_1", "MacRoman", "Cp1252", "Cp850"}, {"8859_2", "Cp1250", "Cp852"}, {"8859_5", "Cp12541", "MacCyrillic", "Cp855", "Cp866"}, {"8859_7", "Cp1253", "MacGreek", "Cp737", "Cp869"}, {"Cp874", "MacThai"}, {"8859_9", "Cp1254", "MacTurkish", "Cp857"}, {"JISAutoDetect", "EUCJIS", "JIS", "SJIS"}, {"Big5", "CNS11643", "GB2312"}, {"KSC5601"}, {"8859_4", "Cp1257", "Cp775"}, {"MacIceland", "Cp861"}, {"8859_3", "MacCroatian", "MacRomania", "MacUkraine", "Cp860", "Cp865", "MacCentralEurope", "UTF8"}};

    public OptionsDialog(Frame frame) {
        super(frame, true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults");
        String string = resourceBundle.getString("optionsdialog.title");
        ((Dialog)((Object)this)).setTitle(string);
        EwtComponent ewtComponent = this.createCharSetPicker();
        ((Container)((Object)this)).add((Component)ewtComponent, "Center");
        ((Window)((Object)this)).addWindowListener(new 2());
        ((Window)((Object)this)).pack();
        Dimension dimension = ((Component)((Object)this)).getSize();
        ((Component)((Object)this)).setSize(dimension.width, dimension.height + 1);
    }

    public void setCharset(String string) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        n = 0;
        while (n < _charsets.length) {
            n2 = 0;
            while (n2 < _charsets[n].length) {
                if (_charsets[n][n2].equals(string)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) break;
            ++n;
        }
        if (!bl) {
            return;
        }
        this._regionChoice.select(this._regionNames[n]);
        this._charsetChoice.removeAll();
        int n3 = 0;
        while (n3 < this._charsetNames[n].length) {
            this._charsetChoice.addItem(this._charsetNames[n][n3]);
            ++n3;
        }
        this._charsetChoice.select(this._charsetNames[n][n2]);
    }

    public void show() {
        this._oldMkDefaultState = this._defaultCheckbox.getState();
        this._oldSelection = this._charsetChoice.getSelectedIndex();
        this._selectionChanged = false;
        super.show();
    }

    public void setMakeDefault(boolean bl) {
        this._defaultCheckbox.setState(bl);
    }

    private EwtComponent createCharSetPicker() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults");
        EwtComponent ewtComponent = new EwtComponent();
        ewtComponent.setLayout((LayoutManager)new EqualColumnLayout(5));
        ewtComponent.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        LWLabel lWLabel = new LWLabel(resourceBundle.getString("optionsdialog.region"));
        ewtComponent.add((Component)lWLabel);
        this.loadCharsetInfo();
        this._regionChoice = new LWChoice();
        int n = 0;
        while (n < _regions.length) {
            this._regionChoice.add(this._regionNames[n]);
            ++n;
        }
        ewtComponent.add((Component)this._regionChoice);
        this._regionChoice.addItemListener((ItemListener)this);
        LWLabel lWLabel2 = new LWLabel(resourceBundle.getString("optionsdialog.htmllabel"));
        ewtComponent.add((Component)lWLabel2);
        this._charsetChoice = new LWChoice();
        int n2 = 0;
        while (n2 < _charsets[0].length) {
            this._charsetChoice.add(this._charsetNames[0][n2]);
            ++n2;
        }
        ewtComponent.add((Component)this._charsetChoice);
        this._defaultCheckbox = new LWCheckbox(resourceBundle.getString("optionsdialog.makedefault"));
        ewtComponent.add((Component)this._defaultCheckbox);
        EwtComponent ewtComponent2 = new EwtComponent();
        ewtComponent2.setLayout((LayoutManager)new EqualRowLayout(10));
        this._okButton = new LWButton(resourceBundle.getString("optionsdialog.okbutton"));
        this._okButton.setBackground(Color.lightGray);
        this._okButton.addActionListener((ActionListener)this);
        ewtComponent2.add((Component)this._okButton);
        this._cancelButton = new LWButton(resourceBundle.getString("optionsdialog.cancelbutton"));
        this._cancelButton.addActionListener((ActionListener)this);
        this._cancelButton.setBackground(Color.lightGray);
        ewtComponent2.add((Component)this._cancelButton);
        EwtComponent ewtComponent3 = new EwtComponent();
        ewtComponent3.setBorder((Border)new MarginBorder(2, 2, 10, 5));
        ewtComponent3.setLayout(new BorderLayout());
        ewtComponent3.add((Component)ewtComponent, "Center");
        ewtComponent3.add((Component)ewtComponent2, "South");
        return ewtComponent3;
    }

    private void loadCharsetInfo() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.CharacterSet", Locale.getDefault());
        this._regionNames = new String[_regions.length];
        int n = 0;
        while (n < _regions.length) {
            this._regionNames[n] = resourceBundle.getString(_regions[n]);
            ++n;
        }
        this._charsetNames = new String[_charsets.length][];
        int n2 = 0;
        while (n2 < _charsets.length) {
            this._charsetNames[n2] = new String[_charsets[n2].length];
            int n3 = 0;
            while (n3 < _charsets[n2].length) {
                this._charsetNames[n2][n3] = resourceBundle.getString(_charsets[n2][n3]);
                ++n3;
            }
            ++n2;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cancelButton) {
            ((Component)((Object)this)).setVisible(false);
            return;
        }
        if (object == this._okButton) {
            if (this._oldSelection != this._charsetChoice.getSelectedIndex() || this._oldMkDefaultState != this._defaultCheckbox.getState() || this._selectionChanged) {
                CharsetEvent charsetEvent = new CharsetEvent(_charsets[this._regionChoice.getSelectedIndex()][this._charsetChoice.getSelectedIndex()], this._defaultCheckbox.getState());
                this.dispatchCharsetEvent(charsetEvent);
            }
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this._regionChoice.getSelectedIndex();
        this._charsetChoice.removeAll();
        int n2 = 0;
        while (n2 < this._charsetNames[n].length) {
            this._charsetChoice.addItem(this._charsetNames[n][n2]);
            ++n2;
        }
        this._selectionChanged = true;
    }

    public void addCharsetListener(CharsetListener charsetListener) {
        if (this._charsetListeners == null) {
            this._charsetListeners = new ListenerManager();
        }
        this._charsetListeners.addListener((EventListener)charsetListener);
    }

    public void removeCharsetListener(CharsetListener charsetListener) {
        this._charsetListeners.removeListener((EventListener)charsetListener);
    }

    private void dispatchCharsetEvent(CharsetEvent charsetEvent) {
        Enumeration enumeration;
        if (this._charsetListeners != null && (enumeration = this._charsetListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                CharsetListener charsetListener = (CharsetListener)enumeration.nextElement();
                charsetListener.charsetChanged(charsetEvent);
            }
        }
    }

    public static void main(String[] stringArray) {
        OptionsDialog optionsDialog = new OptionsDialog(new Frame());
        optionsDialog.setCharset("8859_9");
        optionsDialog.show();
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)((Object)OptionsDialog.this)).setVisible(false);
        }

        /* synthetic */ 2() {
        }
    }
}

