/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.util;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.ewt.event.ListenerManager;
import oracle.help.HelpBook;
import oracle.help.util.LibraryEvent;
import oracle.help.util.LibraryListener;

public class Library
implements Runnable {
    private boolean _booksChanged = false;
    private Vector _books = new Vector(20, 10);
    private Vector _visible = new Vector(20, 10);
    private ListenerManager _listeners;
    private Thread _updateThread;

    public synchronized void addBook(HelpBook helpBook, int n, boolean bl) {
        int n2 = this._getBookIndex(helpBook);
        if (n2 != -1) {
            if (n != -1) {
                this.removeBook((HelpBook)this._books.elementAt(n2));
                return;
            }
            if (bl != this.isBookVisible(n2)) {
                this._visible.setElementAt(new Boolean(bl), n2);
                if (bl) {
                    this._update(2001, this._indexToVisibleIndex(n2), helpBook);
                    return;
                }
                this._update(2002, this._indexToVisibleIndex(n2), helpBook);
            }
            return;
        }
        if (n < 0 || n > this._books.size()) {
            this._books.addElement(helpBook);
            this._visible.addElement(new Boolean(bl));
            if (bl) {
                this._update(2001, -1, helpBook);
            }
        } else {
            this._books.insertElementAt(helpBook, n);
            this._visible.insertElementAt(new Boolean(bl), n);
            if (bl) {
                this._update(2001, this._indexToVisibleIndex(n), helpBook);
            }
        }
        helpBook.setVisible(bl);
        if (this._updateThread == null) {
            this._booksChanged = false;
            this._updateThread = new Thread(this);
            this._updateThread.setDaemon(true);
            this._updateThread.setPriority(1);
            this._updateThread.start();
            return;
        }
        this._booksChanged = true;
    }

    public synchronized void removeBook(HelpBook helpBook) {
        int n = this._getBookIndex(helpBook);
        if (n != -1) {
            this._books.removeElementAt(n);
            this._visible.removeElementAt(n);
            this._update(2002, this._indexToVisibleIndex(n), helpBook);
            helpBook.setVisible(false);
        }
    }

    public synchronized void replaceBook(int n, HelpBook helpBook) {
        HelpBook helpBook2 = this.getBook(n);
        this._books.setElementAt(helpBook, n);
        if (this.isBookVisible(n)) {
            this._update(2002, this._indexToVisibleIndex(n), helpBook2);
            helpBook2.setVisible(false);
            this._update(2001, this._indexToVisibleIndex(n), helpBook);
            helpBook2.setVisible(true);
        }
    }

    public synchronized void setBookVisible(HelpBook helpBook, boolean bl) {
        int n = this._getBookIndex(helpBook);
        if (n != -1 && bl != this.isBookVisible(n)) {
            this._visible.setElementAt(new Boolean(bl), n);
            if (bl) {
                this._update(2001, this._indexToVisibleIndex(n), helpBook);
            } else {
                this._update(2002, this._indexToVisibleIndex(n), helpBook);
            }
            helpBook.setVisible(bl);
        }
    }

    public int getBookCount() {
        return this._books.size();
    }

    public HelpBook getBook(int n) throws ArrayIndexOutOfBoundsException {
        return (HelpBook)this._books.elementAt(n);
    }

    public Enumeration getBooks() {
        return this._books.elements();
    }

    public synchronized HelpBook getVisibleBook(int n) {
        if (n == -1) {
            n = this.getVisibleBookCount() - 1;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.getBookCount()) {
            if (this.isBookVisible(n3)) {
                if (n2 == n) {
                    HelpBook helpBook = this.getBook(n3);
                    return helpBook;
                }
                ++n2;
            }
            ++n3;
        }
        return null;
    }

    public synchronized int getVisibleBookCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.getBookCount()) {
            if (this.isBookVisible(n2)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public synchronized HelpBook[] getVisibleBooks() {
        int n = this.getVisibleBookCount();
        HelpBook[] helpBookArray = new HelpBook[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.getBookCount() && n2 < n) {
            if (this.isBookVisible(n3)) {
                helpBookArray[n2++] = this.getBook(n3);
            }
            ++n3;
        }
        return helpBookArray;
    }

    public boolean isBookVisible(int n) {
        boolean bl = (Boolean)this._visible.elementAt(n);
        return bl;
    }

    public void addLibraryListener(LibraryListener libraryListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)libraryListener);
    }

    public void removeLibraryListener(LibraryListener libraryListener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.removeListener((EventListener)libraryListener);
    }

    public void run() {
        boolean bl = false;
        while (!bl) {
            HelpBook[] helpBookArray = this.getVisibleBooks();
            if (helpBookArray != null) {
                int n = 0;
                while (n < helpBookArray.length) {
                    if (!helpBookArray[n].isInitialized()) {
                        helpBookArray[n].initialize();
                    }
                    ++n;
                }
            }
            if (this._books != null) {
                Vector vector = (Vector)this._books.clone();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    HelpBook helpBook = (HelpBook)enumeration.nextElement();
                    if (helpBook.isInitialized()) continue;
                    helpBook.initialize();
                }
            }
            if (!this._booksChanged) {
                bl = true;
                continue;
            }
            this._booksChanged = false;
        }
        this._updateThread = null;
    }

    private synchronized int _getBookIndex(HelpBook helpBook) {
        int n = 0;
        while (n < this.getBookCount()) {
            if (((HelpBook)this._books.elementAt(n)).equals(helpBook)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private void _update(int var1_1, int var2_2, HelpBook var3_3) {
        if (var2_2 == -1) {
            var2_2 = this.getVisibleBookCount() - 1;
        }
        var4_4 = new LibraryEvent(this, var1_1, var2_2, var3_3);
        if (this._listeners != null && (var5_5 = this._listeners.getListeners()) != null) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            var6_6 = (LibraryListener)var5_5.nextElement();
            var6_6.libraryChanged(var4_4);
lbl8:
            // 2 sources

            ** while (var5_5.hasMoreElements())
        }
lbl9:
        // 1 sources

    }

    private synchronized int _indexToVisibleIndex(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.isBookVisible(n3)) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }
}

