/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.util;

import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

public class MenuDefs {
    public static final String SEPARATOR = "-";
    public static final int MENUID_SEPARATOR = 1000;
    public static final String FILE = "File";
    public static final String DISPLAY = "Display";
    public static final String DISPLAY_NEW = "Display_New";
    public static final String PRINT_TOPIC = "PrintTopic";
    public static final String CLOSE = "Close";
    public static final String EXIT = "Exit";
    public static final String PRINT_TREE = "PrintTree";
    public static final String FILE_MENU_PREFIX = "filemenu";
    public static final int MENUID_FILE_BASE = 1001;
    public static final int MENUID_FILE = 1001;
    public static final int MENUID_DISPLAY = 1002;
    public static final int MENUID_DISPLAY_NEW = 1003;
    public static final int MENUID_PRINT_TOPIC = 1004;
    public static final int MENUID_CLOSE = 1005;
    public static final int MENUID_EXIT = 1006;
    public static final int MENUID_PRINT_TREE = 1007;
    public static final String EDIT = "Edit";
    public static final String COPY = "Copy";
    public static final String EDIT_MENU_PREFIX = "editmenu";
    public static final int MENUID_EDIT_BASE = 1026;
    public static final int MENUID_EDIT = 1026;
    public static final int MENUID_COPY = 1027;
    public static final String VIEW = "View";
    public static final String CONTENTS = "Contents";
    public static final String INDEX = "Index";
    public static final String EXPAND = "Expand";
    public static final String COLLAPSE = "Collapse";
    public static final String EXPAND_ALL = "Expand_All";
    public static final String COLLAPSE_ALL = "Collapse_All";
    public static final String REFRESH = "Refresh";
    public static final int MENUID_VIEW_BASE = 1051;
    public static final int MENUID_VIEW = 1051;
    public static final int MENUID_EXPAND = 1052;
    public static final int MENUID_COLLAPSE = 1053;
    public static final int MENUID_EXPAND_ALL = 1054;
    public static final int MENUID_COLLAPSE_ALL = 1055;
    public static final int MENUID_REFRESH = 1056;
    public static final String GO = "Go";
    public static final String BACK = "Back";
    public static final String FORWARD = "Forward";
    public static final String GO_MENU_PREFIX = "gomenu";
    public static final int MENUID_GO_BASE = 1076;
    public static final int MENUID_GO = 1076;
    public static final int MENUID_BACK = 1077;
    public static final int MENUID_FORWARD = 1078;
    public static final String TOOLS = "Tools";
    public static final String SEARCH = "Search";
    public static final String PREFERENCES = "Preferences";
    public static final String DOCK = "Dock";
    public static final String UNDOCK = "Undock";
    public static final String NAVIGATOR = "Navigator";
    public static final String TOOLS_MENU_PREFIX = "toolsmenu";
    public static final int MENUID_TOOLS_BASE = 2001;
    public static final int MENUID_TOOLS = 2001;
    public static final int MENUID_SEARCH = 2002;
    public static final int MENUID_PREFERENCES = 2003;
    public static final int MENUID_DOCK = 2004;
    public static final int MENUID_UNDOCK = 2005;
    public static final int MENUID_NAVIGATOR = 2006;
    public static final String HELP = "Help";
    public static final String HELP_ON_HELP = "HelpOnHelp";
    public static final String ABOUT = "About";
    public static final String HELP_MENU_PREFIX = "helpmenu";
    public static final int MENUID_HELP_BASE = 2026;
    public static final int MENUID_HELP = 2026;
    public static final int MENUID_HELP_HELP = 2027;
    public static final int MENUID_ABOUT = 2028;

    public static Menu createMenu(ActionListener actionListener, String[] stringArray, ResourceBundle resourceBundle) {
        return MenuDefs.createMenu(actionListener, null, stringArray, resourceBundle, false);
    }

    public static Menu createMenu(ActionListener actionListener, String[] stringArray, ResourceBundle resourceBundle, boolean bl) {
        return MenuDefs.createMenu(actionListener, null, stringArray, resourceBundle, bl);
    }

    public static Menu createMenu(ActionListener actionListener, ItemListener itemListener, String[] stringArray, ResourceBundle resourceBundle, boolean bl) {
        String string;
        Menu menu;
        if (bl) {
            menu = new PopupMenu();
        } else {
            menu = new Menu();
            try {
                string = resourceBundle.getString(stringArray[0]);
            }
            catch (Exception exception) {
                string = stringArray[0];
            }
            MenuDefs.setMenuAttributes(menu, string);
        }
        int n = 1;
        while (n < stringArray.length) {
            try {
                string = resourceBundle.getString(stringArray[n]);
            }
            catch (Exception exception) {
                string = stringArray[n];
            }
            MenuItem menuItem = MenuDefs.createItem(string);
            menuItem.setActionCommand(stringArray[n]);
            menuItem.addActionListener(actionListener);
            if (menuItem instanceof CheckboxMenuItem && itemListener != null) {
                ((CheckboxMenuItem)menuItem).addItemListener(itemListener);
            }
            menu.add(menuItem);
            ++n;
        }
        return menu;
    }

    public static MenuItem createItem(String string) {
        MenuItem menuItem;
        if (string.charAt(0) == '+') {
            menuItem = new CheckboxMenuItem();
            string = string.substring(1);
        } else {
            menuItem = new MenuItem();
        }
        MenuDefs.setMenuAttributes(menuItem, string);
        return menuItem;
    }

    public static void setMenuAttributes(MenuItem menuItem, String string) {
        if (string.equals(SEPARATOR)) {
            menuItem.setLabel(string);
            return;
        }
        if (string.charAt(0) == '&') {
            menuItem.setLabel(string.substring(2));
            menuItem.setShortcut(new MenuShortcut(string.charAt(1)));
            return;
        }
        menuItem.setLabel(string);
    }

    public static void setEnableAll(MenuBar menuBar, boolean bl) {
        int n = 0;
        while (n < menuBar.getMenuCount()) {
            Menu menu = menuBar.getMenu(n);
            int n2 = 0;
            while (n2 < menu.getItemCount()) {
                MenuItem menuItem = menu.getItem(n2);
                menuItem.setEnabled(bl);
                ++n2;
            }
            ++n;
        }
    }

    public static MenuItem getMenuItem(MenuBar menuBar, String string) {
        int n = 0;
        while (n < menuBar.getMenuCount()) {
            Menu menu = menuBar.getMenu(n);
            int n2 = 0;
            while (n2 < menu.getItemCount()) {
                MenuItem menuItem = menu.getItem(n2);
                if (menuItem.getActionCommand().equals(string)) {
                    return menuItem;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }
}

