/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import oracle.help.HelpBook;
import oracle.help.context.GlobalContext;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.navigator.NavigatorWindow;
import oracle.help.topicWindow.TopicWindow;
import oracle.help.topicWindow.TopicWindowPanel;

public class WindowManager {
    private Vector _windows;
    private TopicWindow _currentWindow;
    private TopicWindow _activeWindow;
    private GlobalContext _context;
    private Class _htmlBrowserClass;

    public WindowManager(GlobalContext globalContext) {
        this._context = globalContext;
        this._windows = new Vector(20, 20);
    }

    public void displayURL(HelpBook helpBook, URL uRL, boolean bl, Point point, Dimension dimension) {
        TopicWindow topicWindow;
        NavigatorWindow navigatorWindow = this._context.getNavigatorWindow(false);
        if (bl) {
            topicWindow = this.createTopicWindow();
            this._windows.addElement(topicWindow);
        } else {
            if (navigatorWindow != null && navigatorWindow.isDocked() && navigatorWindow.isVisible()) {
                navigatorWindow.displayUrlDocked(helpBook, uRL);
                return;
            }
            topicWindow = this.getActiveWindow();
        }
        if (!topicWindow.isVisible()) {
            ((Component)topicWindow).setVisible(true);
        }
        topicWindow.displayUrl(helpBook, uRL);
        if (point != null) {
            ((Component)topicWindow).setLocation(point);
        }
        if (dimension != null) {
            ((Component)topicWindow).setSize(dimension);
        }
        topicWindow.toFront();
    }

    public void setHTMLBrowser(Class clazz) {
        if (this._htmlBrowserClass != null && this._windows != null) {
            Enumeration enumeration = this._windows.elements();
            while (enumeration.hasMoreElements()) {
                TopicWindow topicWindow = (TopicWindow)enumeration.nextElement();
                ((Component)topicWindow).setVisible(false);
                topicWindow.dispose();
            }
            this._windows.removeAllElements();
        }
        this._htmlBrowserClass = clazz;
    }

    public Class getHTMLBrowser() {
        return this._htmlBrowserClass;
    }

    public void setActiveWindow() {
        if (this._activeWindow == null) {
            if (this._windows.size() != 0) {
                this._activeWindow = (TopicWindow)this._windows.elementAt(this._windows.size() - 1);
                return;
            }
            this._activeWindow = this.createTopicWindow();
            this._windows.addElement(this._activeWindow);
        }
    }

    public TopicWindow getActiveWindow() {
        this.setActiveWindow();
        return this._activeWindow;
    }

    public void removeAllWindows() {
        if (this._windows == null) {
            return;
        }
        Enumeration enumeration = this._windows.elements();
        while (enumeration.hasMoreElements()) {
            TopicWindow topicWindow = (TopicWindow)enumeration.nextElement();
            ((Component)topicWindow).setVisible(false);
            topicWindow.dispose();
        }
        this._windows.removeAllElements();
        this._activeWindow = null;
    }

    public void removeWindow(TopicWindow topicWindow) {
        this._windows.removeElement(topicWindow);
        if (this._activeWindow == topicWindow) {
            this._activeWindow = null;
        }
        if (this._windows.size() == 0) {
            this._activeWindow = null;
        }
        topicWindow.dispose();
    }

    public void undock(TopicWindowPanel topicWindowPanel, Dimension dimension) {
        TopicWindow topicWindow = new TopicWindow(this, topicWindowPanel);
        this._windows.addElement(topicWindow);
        ((Component)topicWindow).setSize(dimension);
        NavigatorWindow navigatorWindow = this._context.getNavigatorWindow(false);
        Dimension dimension2 = navigatorWindow.getSize();
        Point point = navigatorWindow.getLocation();
        ((Component)topicWindow).setLocation(point.x + dimension2.width + 4, point.y);
        ((Component)topicWindow).setVisible(true);
        if (this._activeWindow == null) {
            this._activeWindow = topicWindow;
        }
    }

    public URL getCurrentWindowUrl() {
        if (this._currentWindow != null) {
            return this._currentWindow.getURL();
        }
        if (this._context.isNavigatorDocked()) {
            return this._context.getNavigatorWindow(false).getDockedUrl();
        }
        return null;
    }

    public HelpBook getCurrentWindowBook() {
        if (this._currentWindow != null) {
            return this._currentWindow.getBook();
        }
        if (this._context.isNavigatorDocked()) {
            return this._context.getNavigatorWindow(false).getDockedBook();
        }
        return null;
    }

    public int getTopicWindowCount() {
        return this._windows.size();
    }

    public TopicWindow createTopicWindow() {
        int n;
        int n2;
        HTMLBrowser hTMLBrowser = null;
        if (this._htmlBrowserClass == null) {
            return null;
        }
        try {
            hTMLBrowser = (HTMLBrowser)this._htmlBrowserClass.newInstance();
        }
        catch (Exception exception) {
            System.out.println("Failed to create instance of " + this._htmlBrowserClass);
        }
        TopicWindow topicWindow = new TopicWindow(this, hTMLBrowser);
        topicWindow.setCharset(this._context.getDefaultCharset());
        Toolkit toolkit = topicWindow.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = TopicWindow.getInitialSize();
        NavigatorWindow navigatorWindow = this._context.getNavigatorWindow(false);
        if (this._context.isNavigatorVisible() && navigatorWindow.isShowing()) {
            Dimension dimension3 = navigatorWindow.getSize();
            Point point = navigatorWindow.getLocation();
            n2 = point.x + dimension3.width;
            n = point.y;
        } else {
            n2 = dimension.width - dimension2.width - 10;
            n = 10;
        }
        n += 24 * (this._windows.size() % 4);
        if (dimension.width < (n2 += 24 * (this._windows.size() % 4)) + dimension2.width) {
            n2 = dimension.width - dimension2.width;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (dimension.height < n + dimension2.height) {
            n = dimension.height - dimension2.height;
        }
        if (n < 0) {
            n = 0;
        }
        ((Component)topicWindow).setLocation(n2, n);
        this.setCurrentWindow(topicWindow);
        return topicWindow;
    }

    public void setCharset(String string) {
        if (this._windows != null) {
            int n = 0;
            while (n < this._windows.size()) {
                ((TopicWindow)this._windows.elementAt(n)).setCharset(string);
                ++n;
            }
        }
    }

    public void dock(TopicWindow topicWindow) {
        Dimension dimension = topicWindow.getSize();
        ((Component)topicWindow).setVisible(false);
        TopicWindowPanel topicWindowPanel = topicWindow.getPanel();
        this.removeWindow(topicWindow);
        if (this._activeWindow == topicWindow) {
            this._activeWindow = null;
        }
        this._currentWindow = null;
        NavigatorWindow navigatorWindow = this._context.getNavigatorWindow(true);
        if (navigatorWindow.isDocked()) {
            navigatorWindow.undockTopicPanel(true, false);
        }
        navigatorWindow.dockTopicWindowPanel(topicWindowPanel, dimension);
        Point point = navigatorWindow.getLocation();
        Dimension dimension2 = navigatorWindow.getSize();
        Toolkit toolkit = topicWindow.getToolkit();
        Dimension dimension3 = toolkit.getScreenSize();
        if (point.x + dimension2.width > dimension3.width) {
            point.x = dimension3.width - (dimension2.width + 10);
        }
        if (point.y + dimension2.height > dimension3.height) {
            point.y = dimension3.height - (dimension2.height + 10);
        }
        ((Component)navigatorWindow).setLocation(point);
        navigatorWindow.setVisible(true);
        navigatorWindow.toFront();
    }

    public void setCurrentWindow(TopicWindow topicWindow) {
        this._currentWindow = topicWindow;
        this._context.refreshNavigator();
    }

    public void setTopicWindowsVisible(boolean bl) {
        if (this._windows != null) {
            Enumeration enumeration = this._windows.elements();
            while (enumeration.hasMoreElements()) {
                TopicWindow topicWindow = (TopicWindow)enumeration.nextElement();
                ((Component)topicWindow).setVisible(bl);
            }
        }
    }

    public GlobalContext getContext() {
        return this._context;
    }
}

