/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import java.io.PrintWriter;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class Address {
    private NVPair _nvaddr;

    public Address(NVPair nvp) throws CreateAddressException {
        if (nvp == null) {
            throw new IllegalArgumentException("Address.Address(): nvp must be non-null.");
        }
        this._nvaddr = nvp;
    }

    public void println(PrintWriter pout) {
        this._nvaddr.println(pout);
    }

    public final String toNVString() {
        return this._nvaddr.toString();
    }

    public String toString() {
        return this.toNVString();
    }

    public void println() {
        System.out.println(this.toString());
    }

    public final String getProtocol() {
        return this._getParameter("PROTOCOL");
    }

    protected final void _setProtocol(String prot) {
        this._setParameter("PROTOCOL", prot);
    }

    public final String _getParameter(String param) {
        return Address._getParameter(this._nvaddr, param);
    }

    protected static String _getParameter(NVPair nvp, String param) {
        NVNavigator navigator = new NVNavigator();
        if (nvp == null) {
            throw new IllegalArgumentException("Address.getParameter(): NVPair nvp is null.");
        }
        if (nvp.getRHSType() == NVPair.RHS_ATOM) {
            throw new IllegalArgumentException("Address.getParameter(): Value of NVPair is an ATOM.");
        }
        NVPair found = navigator.findNVPair(nvp, param);
        if (found == null || found.getRHSType() != NVPair.RHS_ATOM) {
            return null;
        }
        return found.getAtom();
    }

    public final void _setParameter(String param, String value) {
        NVNavigator navigator = new NVNavigator();
        NVPair found = this._nvaddr.getRHSType() == NVPair.RHS_NONE ? null : navigator.findNVPair(this._nvaddr, param);
        if (found == null) {
            NVPair new_param = new NVPair(param, value);
            this._nvaddr.addListElement(new_param);
        } else {
            found.setAtom(value);
        }
    }
}

