/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;

public class AddressFactory {
    private static AddressFactory _sfactory = null;

    public static void loadClass() {
    }

    private AddressFactory() {
    }

    public static AddressFactory getFactory() {
        if (_sfactory == null) {
            _sfactory = new AddressFactory();
        }
        return _sfactory;
    }

    public Address createAddress(NVPair nvp) throws CreateAddressException {
        if (nvp == null) {
            throw new IllegalArgumentException("AddressFactory.createAddress(): NVPair nvp is null.");
        }
        if (nvp.getRHSType() != NVPair.RHS_LIST) {
            throw new CreateAddressException("The ADDRESS section does not contain a list of parameters.");
        }
        NVNavigator nvnavigator = new NVNavigator();
        NVPair prot_nvp = nvnavigator.findNVPair(nvp, "PROTOCOL");
        if (prot_nvp == null) {
            throw new CreateAddressException("A PROTOCOL could not be found for this Address.");
        }
        if (prot_nvp.getRHSType() != NVPair.RHS_ATOM) {
            throw new CreateAddressException("The value for the PROTOCOL in the Address is invalid.");
        }
        return new Address(nvp);
    }

    public Address createAddress(String nvString) throws CreateAddressException {
        NVFactory nvfactory = new NVFactory();
        NVPair nvp = nvfactory.createNVPair(nvString);
        Address addr = this.createAddress(nvp);
        return addr;
    }

    private static void _print(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        Address address;
        String addr;
        AddressFactory addrfactory = AddressFactory.getFactory();
        AddressFactory._print("Verifying createAddress()");
        try {
            AddressFactory._print("  With VALID input: ");
            addr = "(Address = (Protocol = TCPS) (Port = 1521) (Host = winter))";
            AddressFactory._print("    Case 0: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("      Result = " + address.toNVString());
            addr = "(Address = (Protocol = TCP) (Port = 1521) (Host = winter))";
            AddressFactory._print("    Case 1: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("      Result = " + address.toNVString());
            addr = "(address=(service = winter_lsnr)(protocol = spx))";
            AddressFactory._print("    Case 2: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("      Result = " + address.toNVString());
            addr = "(ADDRESS=(PROTOCOl=NMP)(SERVER=winter)(PIPE=ORAPIPE))";
            AddressFactory._print("    Case 3: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("      Result = " + address.toNVString());
            addr = "(ADDRESS=(PROTOCOl=BEQ)(ARGV0 = oracle73DEQ))";
            AddressFactory._print("    Case 4: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("      Result = " + address.toNVString());
            addr = "(ADDRESS=(PROTOCOl=IPC)(KEY = oracle))";
            AddressFactory._print("    Case 5: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("      Result = " + address.toNVString());
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
        AddressFactory._print("\n  With INVALID input: ");
        try {
            addr = "(ADDRESS=(PROTOCOl=IPC)(KEY=winter))";
            AddressFactory._print("    Case 1: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(ADDRESS=NONE)";
            AddressFactory._print("    Case 2: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(()()((())))";
            AddressFactory._print("    Case 3: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(Address=(Host=winter)(Port=1521))";
            AddressFactory._print("    Case 4: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(ADDRESS=(PROTOCOL=(A=B))(HOST=winter)(Port=1521))";
            AddressFactory._print("    Case 5: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(ADDRESS=)";
            AddressFactory._print("    Case 6: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        AddressFactory._print("\n  With PROTOCOL-specific INVALID input: ");
        try {
            addr = "(address = (protocol=tcp)(port=1521))";
            AddressFactory._print("    Case 1: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=tcp)(host=summer))";
            AddressFactory._print("    Case 2: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=tcp)(host=summer)(port=1521)";
            AddressFactory._print("    Case 3: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=tcp)(host=summer)(port=foo))";
            AddressFactory._print("    Case 4: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=spx))";
            AddressFactory._print("    Case 5: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=spx)(service=summer_lsnr)";
            AddressFactory._print("    Case 6: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=nmp)(pipe=orapipe))";
            AddressFactory._print("    Case 7: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=nmp)(server=summer))";
            AddressFactory._print("    Case 8: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=nmp)(server=summer)(pipe=orapipe)";
            AddressFactory._print("    Case 9: " + addr);
            address = addrfactory.createAddress(addr);
            AddressFactory._print("    ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            AddressFactory._print("      Exception Received: " + e.getMessage());
        }
    }
}

