/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class BEQAddress
extends Address {
    public static String BEQ_PROTOCOL = "BEQ";

    protected BEQAddress(NVPair nvp) throws CreateAddressException {
        super(nvp);
        String prot = Address._getParameter(nvp, "PROTOCOL");
        if (prot == null || !prot.equalsIgnoreCase(BEQ_PROTOCOL)) {
            throw new CreateAddressException("Bequeath: Invalid protocol (" + prot + ") in Address.");
        }
        this._setProtocol(BEQ_PROTOCOL);
        this.setSID("ORCL");
    }

    public String getSID() {
        String argv0 = this._getParameter("ARGV0");
        String sid = argv0.substring(8);
        return sid;
    }

    public void setSID(String sid) {
        BEQAddress._validateSID(sid);
        this._setParameter("PROGRAM", "oracle80");
        this._setParameter("ARGV0", "oracle80" + sid);
        this._setParameter("ARGS", "'(DESCRIPTION=(LOCAL=YES)(ADDRESS=(PROTOCOL=BEQ)))'");
    }

    private static void _validateSID(String sid) {
    }

    private static void _print(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        BEQAddress BEQaddr;
        NVPair nvp;
        String addr;
        NVFactory factory = new NVFactory();
        BEQAddress._print("Verifying constructor BEQAddress(nvp)");
        BEQAddress._print("  With VALID input");
        try {
            addr = "(ADDRESS=(PROTOCOL=BEQ)(ARGV0=oracle73ORCL))";
            BEQAddress._print("    Case 1: " + addr);
            nvp = factory.createNVPair(addr);
            BEQaddr = new BEQAddress(nvp);
            BEQAddress._print("      Result: " + BEQaddr.toNVString());
            addr = "(Address = (ARGV0=oracle80EM1) (protocol = BEQ))";
            BEQAddress._print("    Case 2: " + addr);
            nvp = factory.createNVPair(addr);
            BEQaddr = new BEQAddress(nvp);
            BEQAddress._print("      Result: " + BEQaddr.toNVString());
            addr = "(address = (Protocol = BEQ) (argv0 = oracle80Tst))";
            BEQAddress._print("    Case 3: " + addr);
            nvp = factory.createNVPair(addr);
            BEQaddr = new BEQAddress(nvp);
            BEQAddress._print("      Result: " + BEQaddr.toNVString());
        }
        catch (CreateAddressException e) {
            BEQAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
        BEQAddress._print("\n  With INVALID input");
        try {
            addr = "(address = (argv0 = oracle80orcl))";
            BEQAddress._print("    Case 1: Missing protocol: " + addr);
            nvp = factory.createNVPair(addr);
            BEQaddr = new BEQAddress(nvp);
            BEQAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            BEQAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=tcp)(host=winter)(port=1521))";
            BEQAddress._print("    Case 2: Incorrect protocol: " + addr);
            nvp = factory.createNVPair(addr);
            BEQaddr = new BEQAddress(nvp);
            BEQAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            BEQAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=BEQ))";
            BEQAddress._print("    Case 3: Missing ARGV0: " + addr);
            nvp = factory.createNVPair(addr);
            BEQaddr = new BEQAddress(nvp);
            BEQAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            BEQAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=BEQ)(argv0 = oracle80orcl)";
            BEQAddress._print("    Case 4: Parse error: " + addr);
            nvp = factory.createNVPair(addr);
            BEQaddr = new BEQAddress(nvp);
            BEQAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException e) {
            BEQAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
    }
}

