/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class IPCAddress
extends Address {
    public static String IPC_PROTOCOL = "IPC";

    protected IPCAddress(NVPair nvp) throws CreateAddressException {
        super(nvp);
        String prot = Address._getParameter(nvp, "PROTOCOL");
        if (prot == null || !prot.equalsIgnoreCase(IPC_PROTOCOL)) {
            throw new CreateAddressException("IPC: Invalid protocol (" + prot + ") in Address.");
        }
        this._setProtocol(IPC_PROTOCOL);
        String key = Address._getParameter(nvp, "KEY");
        if (key == null) {
            throw new CreateAddressException("IPC: The value for KEY is missing.");
        }
        this.setKey(key);
    }

    public String getKey() {
        return this._getParameter("KEY");
    }

    public void setKey(String key) {
        IPCAddress._validateKey(key);
        this._setParameter("KEY", key);
    }

    private static void _validateKey(String key) {
    }

    private static void _print(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        IPCAddress ipcaddr;
        NVPair nvp;
        String addr;
        NVFactory factory = new NVFactory();
        IPCAddress._print("Verifying constructor IPCAddress(nvp)");
        IPCAddress._print("  With VALID input");
        try {
            addr = "(ADDRESS=(PROTOCOL=IPC)(KEY=winter_lsnr))";
            IPCAddress._print("    Case 1: " + addr);
            nvp = factory.createNVPair(addr);
            ipcaddr = new IPCAddress(nvp);
            IPCAddress._print("      Result: " + ipcaddr.toNVString());
            addr = "(Address = (key = summer_lsnr) (protocol = ipc))";
            IPCAddress._print("    Case 2: " + addr);
            nvp = factory.createNVPair(addr);
            ipcaddr = new IPCAddress(nvp);
            IPCAddress._print("      Result: " + ipcaddr.toNVString());
            addr = "(address = (Protocol = IPC) (Key = novell1))";
            IPCAddress._print("    Case 3: " + addr);
            nvp = factory.createNVPair(addr);
            ipcaddr = new IPCAddress(nvp);
            IPCAddress._print("      Result: " + ipcaddr.toNVString());
        }
        catch (CreateAddressException e) {
            IPCAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
        IPCAddress._print("\n  With INVALID input");
        try {
            addr = "(address = (key=foobar))";
            IPCAddress._print("    Case 1: Missing protocol: " + addr);
            nvp = factory.createNVPair(addr);
            ipcaddr = new IPCAddress(nvp);
            IPCAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            IPCAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=tcp)(host=winter)(port=1521))";
            IPCAddress._print("    Case 2: Incorrect protocol: " + addr);
            nvp = factory.createNVPair(addr);
            ipcaddr = new IPCAddress(nvp);
            IPCAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            IPCAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=ipc))";
            IPCAddress._print("    Case 3: Missing service: " + addr);
            nvp = factory.createNVPair(addr);
            ipcaddr = new IPCAddress(nvp);
            IPCAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            IPCAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=ipc)(key=summer_lsnr)";
            IPCAddress._print("    Case 4: Parse error: " + addr);
            nvp = factory.createNVPair(addr);
            ipcaddr = new IPCAddress(nvp);
            IPCAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException e) {
            IPCAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
    }
}

