/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class NMPAddress
extends Address {
    public static String NMP_PROTOCOL = "NMP";

    public NMPAddress(NVPair nvp) throws CreateAddressException {
        super(nvp);
        String prot = Address._getParameter(nvp, "PROTOCOL");
        if (prot == null || !prot.equalsIgnoreCase(NMP_PROTOCOL)) {
            throw new CreateAddressException("NMP: Invalid protocol (" + prot + ") in Address.");
        }
        this._setProtocol(NMP_PROTOCOL);
        String server = Address._getParameter(nvp, "SERVER");
        if (server == null) {
            throw new CreateAddressException("NMP: The value for SERVER is missing.");
        }
        this.setServer(server);
        String pipe = Address._getParameter(nvp, "PIPE");
        if (pipe == null) {
            throw new CreateAddressException("NMP: The value for PIPE is missing.");
        }
        this.setPipe(pipe);
    }

    public String getServer() {
        return this._getParameter("SERVER");
    }

    public String getPipe() {
        return this._getParameter("PIPE");
    }

    public void setServer(String server) {
        NMPAddress._validateServer(server);
        this._setParameter("SERVER", server);
    }

    public void setPipe(String pipe) {
        NMPAddress._validatePipe(pipe);
        this._setParameter("PIPE", pipe);
    }

    private static void _validateServer(String server) {
    }

    private static void _validatePipe(String pipe) {
    }

    private static void _print(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        NMPAddress nmpaddr;
        NVPair nvp;
        String addr;
        NVFactory factory = new NVFactory();
        NMPAddress._print("Verifying constructor NMPAddress(nvp)");
        NMPAddress._print("  With VALID input");
        try {
            addr = "(ADDRESS=(PROTOCOL=NMP)(SERVER=WINTER)(PIPE=ORAPIPE))";
            NMPAddress._print("    Case 1: " + addr);
            nvp = factory.createNVPair(addr);
            nmpaddr = new NMPAddress(nvp);
            NMPAddress._print("      Result: " + nmpaddr.toNVString());
            addr = "(Address = (Server = Summer) (PIPE = ORAPIPE) (Protocol = NMP))";
            NMPAddress._print("    Case 2: " + addr);
            nvp = factory.createNVPair(addr);
            nmpaddr = new NMPAddress(nvp);
            NMPAddress._print("      Result: " + nmpaddr.toNVString());
            addr = "(address = (protocol = nmp) (pipe = orapipe) (server = stacks))";
            NMPAddress._print("    Case 3: " + addr);
            nvp = factory.createNVPair(addr);
            nmpaddr = new NMPAddress(nvp);
            NMPAddress._print("      Result: " + nmpaddr.toNVString());
        }
        catch (CreateAddressException e) {
            NMPAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
        NMPAddress._print("\n  With INVALID input");
        try {
            addr = "(address = (server=summer)(pipe=orapipe))";
            NMPAddress._print("    Case 1: Missing protocol: " + addr);
            nvp = factory.createNVPair(addr);
            nmpaddr = new NMPAddress(nvp);
            NMPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            NMPAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=spx)(service = winter_lsnr))";
            NMPAddress._print("    Case 2: Incorrect protocol: " + addr);
            nvp = factory.createNVPair(addr);
            nmpaddr = new NMPAddress(nvp);
            NMPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            NMPAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=nmp)(pipe=orapipe))";
            NMPAddress._print("    Case 3: Missing server: " + addr);
            nvp = factory.createNVPair(addr);
            nmpaddr = new NMPAddress(nvp);
            NMPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            NMPAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=nmp)(server=summer))";
            NMPAddress._print("    Case 4: Missing pipe: " + addr);
            nvp = factory.createNVPair(addr);
            nmpaddr = new NMPAddress(nvp);
            NMPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            NMPAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=nmp)(server=summer)(pipe=orapipe)";
            NMPAddress._print("    Case 5: Parse error: " + addr);
            nvp = factory.createNVPair(addr);
            nmpaddr = new NMPAddress(nvp);
            NMPAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException e) {
            NMPAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
    }
}

