/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class SPXAddress
extends Address {
    public static String SPX_PROTOCOL = "SPX";

    protected SPXAddress(NVPair nvp) throws CreateAddressException {
        super(nvp);
        String prot = Address._getParameter(nvp, "PROTOCOL");
        if (prot == null || !prot.equalsIgnoreCase(SPX_PROTOCOL)) {
            throw new CreateAddressException("SPX: Invalid protocol (" + prot + ") in Address.");
        }
        this._setProtocol(SPX_PROTOCOL);
        String service = Address._getParameter(nvp, "SERVICE");
        if (service == null) {
            throw new CreateAddressException("SPX: The value for SERVICE is missing.");
        }
        this.setService(service);
    }

    public String getService() {
        return this._getParameter("SERVICE");
    }

    public void setService(String service) {
        SPXAddress._validateService(service);
        this._setParameter("SERVICE", service);
    }

    private static void _validateService(String service) {
    }

    private static void _print(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        SPXAddress spxaddr;
        NVPair nvp;
        String addr;
        NVFactory factory = new NVFactory();
        SPXAddress._print("Verifying constructor SPXAddress(nvp)");
        SPXAddress._print("  With VALID input");
        try {
            addr = "(ADDRESS=(PROTOCOL=SPX)(SERVICE=WINTER_LSNR))";
            SPXAddress._print("    Case 1: " + addr);
            nvp = factory.createNVPair(addr);
            spxaddr = new SPXAddress(nvp);
            SPXAddress._print("      Result: " + spxaddr.toNVString());
            addr = "(Address = (service = summer_lsnr) (protocol = spx))";
            SPXAddress._print("    Case 2: " + addr);
            nvp = factory.createNVPair(addr);
            spxaddr = new SPXAddress(nvp);
            SPXAddress._print("      Result: " + spxaddr.toNVString());
            addr = "(address = (Protocol = SPX) (Service = novell1))";
            SPXAddress._print("    Case 3: " + addr);
            nvp = factory.createNVPair(addr);
            spxaddr = new SPXAddress(nvp);
            SPXAddress._print("      Result: " + spxaddr.toNVString());
        }
        catch (CreateAddressException e) {
            SPXAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
        SPXAddress._print("\n  With INVALID input");
        try {
            addr = "(address = (service=foobar))";
            SPXAddress._print("    Case 1: Missing protocol: " + addr);
            nvp = factory.createNVPair(addr);
            spxaddr = new SPXAddress(nvp);
            SPXAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            SPXAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=tcp)(host=winter)(port=1521))";
            SPXAddress._print("    Case 2: Incorrect protocol: " + addr);
            nvp = factory.createNVPair(addr);
            spxaddr = new SPXAddress(nvp);
            SPXAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            SPXAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=spx))";
            SPXAddress._print("    Case 3: Missing service: " + addr);
            nvp = factory.createNVPair(addr);
            spxaddr = new SPXAddress(nvp);
            SPXAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            SPXAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=spx)(service=summer_lsnr)";
            SPXAddress._print("    Case 4: Parse error: " + addr);
            nvp = factory.createNVPair(addr);
            spxaddr = new SPXAddress(nvp);
            SPXAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException e) {
            SPXAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
    }
}

