/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.asst.addr;

import oracle.net.asst.addr.Address;
import oracle.net.asst.addr.CreateAddressException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;

public final class TCPAddress
extends Address {
    public static String TCP_PROTOCOL = "TCP";

    protected TCPAddress(NVPair nvp) throws CreateAddressException {
        super(nvp);
        String prot = Address._getParameter(nvp, "PROTOCOL");
        if (prot == null || !prot.equalsIgnoreCase(TCP_PROTOCOL)) {
            throw new CreateAddressException("TCP/IP: Invalid protocol (" + prot + ") in Address.");
        }
        this._setProtocol(TCP_PROTOCOL);
        String host = Address._getParameter(nvp, "HOST");
        if (host == null) {
            throw new CreateAddressException("TCP/IP: The value for the HOST is missing.");
        }
        this.setHost(host);
        String sport = Address._getParameter(nvp, "PORT");
        if (sport == null) {
            throw new CreateAddressException("TCP/IP: The value for PORT is missing.");
        }
        try {
            this.setPort(Integer.valueOf(sport));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CreateAddressException("TCP/IP: The value for PORT (" + sport + ") must be a number.");
        }
    }

    public String getHost() {
        return this._getParameter("HOST");
    }

    public int getPort() {
        String sport = this._getParameter("PORT");
        return Integer.valueOf(sport);
    }

    public void setHost(String host) {
        TCPAddress._validateHost(host);
        this._setParameter("HOST", host);
    }

    public void setPort(int port) {
        TCPAddress._validatePort(port);
        this._setParameter("PORT", String.valueOf(port));
    }

    private static void _validateHost(String host) {
    }

    private static void _validatePort(int port) {
    }

    private static void _print(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        TCPAddress tcpaddr;
        NVPair nvp;
        String addr;
        NVFactory factory = new NVFactory();
        TCPAddress._print("Verifying constructor TCPAddress(nvp)");
        TCPAddress._print("  With VALID input");
        try {
            addr = "(ADDRESS=(PROTOCOL=TCP)(HOST=WINTER)(PORT=1521))";
            TCPAddress._print("    Case 1: " + addr);
            nvp = factory.createNVPair(addr);
            tcpaddr = new TCPAddress(nvp);
            TCPAddress._print("      Result: " + tcpaddr.toNVString());
            addr = "(Address = (Host = summer) (Port = 1526) (Protocol = tcp))";
            TCPAddress._print("    Case 2: " + addr);
            nvp = factory.createNVPair(addr);
            tcpaddr = new TCPAddress(nvp);
            TCPAddress._print("      Result: " + tcpaddr.toNVString());
            addr = "(address = (protocol = tcp) (port = 5000) (host = spring))";
            TCPAddress._print("    Case 3: " + addr);
            nvp = factory.createNVPair(addr);
            tcpaddr = new TCPAddress(nvp);
            TCPAddress._print("      Result: " + tcpaddr.toNVString());
        }
        catch (CreateAddressException e) {
            TCPAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
        TCPAddress._print("\n  With INVALID input");
        try {
            addr = "(address = (host=winter)(port=1521))";
            TCPAddress._print("    Case 1: Missing protocol: " + addr);
            nvp = factory.createNVPair(addr);
            tcpaddr = new TCPAddress(nvp);
            TCPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            TCPAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=spx)(service = winter_lsnr))";
            TCPAddress._print("    Case 2: Incorrect protocol: " + addr);
            nvp = factory.createNVPair(addr);
            tcpaddr = new TCPAddress(nvp);
            TCPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            TCPAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=tcp)(port=1521))";
            TCPAddress._print("    Case 3: Missing host: " + addr);
            nvp = factory.createNVPair(addr);
            tcpaddr = new TCPAddress(nvp);
            TCPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            TCPAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=tcp)(host=summer))";
            TCPAddress._print("    Case 4: Missing port: " + addr);
            nvp = factory.createNVPair(addr);
            tcpaddr = new TCPAddress(nvp);
            TCPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            TCPAddress._print("      Exception Received: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=tcp)(host=summer)(port=1521)";
            TCPAddress._print("    Case 5: Parse error: " + addr);
            nvp = factory.createNVPair(addr);
            tcpaddr = new TCPAddress(nvp);
            TCPAddress._print("      ERROR: expected NVParseException");
        }
        catch (CreateAddressException e) {
            TCPAddress._print("      ERROR: Unexpected exception: " + e.getMessage());
        }
        try {
            addr = "(address = (protocol=tcp)(host=summer)(port=foo))";
            TCPAddress._print("    Case 6: Invalid port: " + addr);
            nvp = factory.createNVPair(addr);
            tcpaddr = new TCPAddress(nvp);
            TCPAddress._print("      ERROR: expected CreateAddressException");
        }
        catch (CreateAddressException e) {
            TCPAddress._print("      Exception Received: " + e.getMessage());
        }
    }
}

